/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs.wizard;

import com.kms.katalon.composer.checkpoint.dialogs.wizard.NewCheckpointCsvPage;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.NewCheckpointDatabasePage;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.NewCheckpointExcelPage;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.NewCheckpointStartingPage;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.NewCheckpointTestDataPage;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class NewCheckpointWizard
extends Wizard {
    private NewCheckpointStartingPage startingPage;
    private NewCheckpointTestDataPage testDataPage;
    private NewCheckpointExcelPage excelPage;
    private NewCheckpointCsvPage csvPage;
    private NewCheckpointDatabasePage databasePage;
    private FolderEntity parentFolder;
    private String name;
    private CheckpointSourceInfo sourceInfo;

    public NewCheckpointWizard(String name, FolderEntity parentFolder) {
        this.setWindowTitle(StringConstants.DIA_WINDOW_TITLE_NEW);
        this.parentFolder = parentFolder;
        this.name = name;
    }

    public void addPages() {
        this.startingPage = new NewCheckpointStartingPage(this.name, this.parentFolder);
        this.testDataPage = new NewCheckpointTestDataPage();
        this.excelPage = new NewCheckpointExcelPage();
        this.csvPage = new NewCheckpointCsvPage();
        this.databasePage = new NewCheckpointDatabasePage();
        this.addPage((IWizardPage)this.startingPage);
        this.addPage((IWizardPage)this.testDataPage);
        this.addPage((IWizardPage)this.excelPage);
        this.addPage((IWizardPage)this.csvPage);
        this.addPage((IWizardPage)this.databasePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (super.getNextPage(page) == null || !((Object)((Object)this.startingPage)).equals(page)) {
            return null;
        }
        String typeName = this.startingPage.getTypeName();
        if (DataFileEntity.DataFileDriverType.ExcelFile.toString().equals(typeName)) {
            return this.excelPage;
        }
        if (DataFileEntity.DataFileDriverType.CSV.toString().equals(typeName)) {
            return this.csvPage;
        }
        if (DataFileEntity.DataFileDriverType.DBData.toString().equals(typeName)) {
            return this.databasePage;
        }
        return this.testDataPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (super.getPreviousPage(page) == null) {
            return null;
        }
        return this.startingPage;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    public boolean performFinish() {
        this.name = this.startingPage.getName();
        String typeName = this.startingPage.getTypeName();
        this.sourceInfo = DataFileEntity.DataFileDriverType.ExcelFile.toString().equals(typeName) ? this.excelPage.getSourceInfo() : (DataFileEntity.DataFileDriverType.CSV.toString().equals(typeName) ? this.csvPage.getSourceInfo() : (DataFileEntity.DataFileDriverType.DBData.toString().equals(typeName) ? this.databasePage.getSourceInfo() : this.testDataPage.getSourceInfo()));
        return true;
    }

    public CheckpointEntity getCheckpoint() {
        CheckpointEntity checkpoint = new CheckpointEntity();
        checkpoint.setName(this.name);
        checkpoint.setDescription(this.startingPage.getCheckpointDescription());
        checkpoint.setParentFolder(this.parentFolder);
        checkpoint.setProject(this.parentFolder.getProject());
        checkpoint.setSourceInfo(this.sourceInfo);
        return checkpoint;
    }
}

