/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.parts;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.parts.providers.CheckpointCellLabelProvider;
import com.kms.katalon.composer.checkpoint.parts.supports.CheckpointCellEditingSupport;
import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.checkpoint.CheckpointCell;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class CheckpointAbstractPart
extends CPart
implements EventHandler,
IComposerPartEvent {
    private static final int DEFAULT_COLUMN_WIDTH = 200;
    @Inject
    protected EModelService modelService;
    @Inject
    protected EPartService partService;
    @Inject
    protected MApplication application;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    protected MPart part;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private UISynchronize sync;
    private Composite compSourceInfoHeader;
    protected Composite compSourceInfoDetails;
    private Composite compTable;
    protected TableViewer tableViewer;
    private CLabel lblArrowIndicator;
    private Label lblSourceInfo;
    private Label lblStatus;
    protected Button btnTakeSnapshot;
    protected CheckpointEntity checkpoint;
    protected CheckpointEntity tempCheckpoint;
    private int selectedColumnIndex = -1;

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.initialize(this.part, this.partService);
        new HelpToolBarForMPart(this.part, this.getDocumentationUrl());
        this.createControls(parent);
        this.addControlListeners();
        this.redrawArrowIndicator();
        this.registerEventListeners();
        this.loadCheckpoint((CheckpointEntity)this.getPart().getObject());
        this.setDirty(false);
    }

    protected abstract String getDocumentationUrl();

    private void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSourceInfoPart(parent);
        this.createDataTablePart(parent);
    }

    private Composite createSourceInfoPart(Composite parent) {
        this.createSourceInfoPartHeader(parent);
        this.createSourceInfoPartDetails(parent);
        this.createTakeSnapshotButton(this.compSourceInfoDetails);
        return parent;
    }

    private void createSourceInfoPartHeader(Composite parent) {
        this.compSourceInfoHeader = new Composite(parent, 0);
        this.compSourceInfoHeader.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glCompositeFileInfoHeader = new GridLayout(3, false);
        glCompositeFileInfoHeader.marginWidth = 0;
        glCompositeFileInfoHeader.marginHeight = 0;
        this.compSourceInfoHeader.setLayout((Layout)glCompositeFileInfoHeader);
        this.compSourceInfoHeader.setCursor(this.compSourceInfoHeader.getDisplay().getSystemCursor(21));
        this.lblArrowIndicator = new CLabel(this.compSourceInfoHeader, 0);
        this.lblSourceInfo = new Label(this.compSourceInfoHeader, 0);
        this.lblSourceInfo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblSourceInfo.setText(StringConstants.PART_SOURCE_INFO);
        ControlUtils.setFontToBeBold((Control)this.lblSourceInfo);
        this.lblStatus = new Label(this.compSourceInfoHeader, 0);
        GridData gdLblFileInfoStatus = new GridData(131072, 0x1000000, true, false, 1, 1);
        gdLblFileInfoStatus.horizontalIndent = 5;
        this.lblStatus.setLayoutData((Object)gdLblFileInfoStatus);
    }

    protected abstract Composite createSourceInfoPartDetails(Composite var1);

    private void createTakeSnapshotButton(Composite parent) {
        this.btnTakeSnapshot = new Button(parent, 0x800008);
        this.btnTakeSnapshot.setText(StringConstants.PART_BTN_TAKE_SNAPSHOT);
        this.btnTakeSnapshot.setLayoutData((Object)new GridData(131072, 4, false, true));
    }

    private Composite createDataTablePart(Composite parent) {
        this.compTable = new Composite(parent, 2048);
        GridLayout glCompTable = new GridLayout();
        glCompTable.marginHeight = 0;
        glCompTable.marginWidth = 0;
        this.compTable.setLayout((Layout)glCompTable);
        this.compTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(this.compTable, 98308);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        final Table table = this.tableViewer.getTable();
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumnNo = tableViewerColumnNo.getColumn();
        tableColumnNo.setText(StringConstants.NO_);
        tableColumnNo.setWidth(40);
        tableViewerColumnNo.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int order = table.indexOf((TableItem)cell.getItem()) + 1;
                cell.setText(Integer.toString(order));
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.createContextMenu(table);
        return parent;
    }

    private void createContextMenu(final Table table) {
        Menu tableContextMenu = new Menu((Control)table);
        table.setMenu(tableContextMenu);
        MenuItem checkColumn = new MenuItem(tableContextMenu, 8);
        checkColumn.setText(StringConstants.PART_MENU_CHECK_COLUMN);
        checkColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointAbstractPart.this.checkUncheckTableColumn(true);
            }
        });
        MenuItem uncheckColumn = new MenuItem(tableContextMenu, 8);
        uncheckColumn.setText(StringConstants.PART_MENU_UNCHECK_COLUMN);
        uncheckColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointAbstractPart.this.checkUncheckTableColumn(false);
            }
        });
        MenuItem checkRow = new MenuItem(tableContextMenu, 8);
        checkRow.setText(StringConstants.PART_MENU_CHECK_ROW);
        checkRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointAbstractPart.this.checkUncheckTableRow(true);
            }
        });
        MenuItem uncheckRow = new MenuItem(tableContextMenu, 8);
        uncheckRow.setText(StringConstants.PART_MENU_UNCHECK_ROW);
        uncheckRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointAbstractPart.this.checkUncheckTableRow(false);
            }
        });
        MenuItem checkAll = new MenuItem(tableContextMenu, 8);
        checkAll.setText(StringConstants.PART_MENU_CHECK_ALL);
        checkAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointAbstractPart.this.checkUncheckAll(true);
            }
        });
        MenuItem uncheckAll = new MenuItem(tableContextMenu, 8);
        uncheckAll.setText(StringConstants.PART_MENU_UNCHECK_ALL);
        uncheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointAbstractPart.this.checkUncheckAll(false);
            }
        });
        table.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                CheckpointAbstractPart.this.selectedColumnIndex = -1;
                ViewerCell cell = CheckpointAbstractPart.this.tableViewer.getCell(Display.getDefault().map(null, (Control)table, new Point(e.x, e.y)));
                if (cell != null) {
                    CheckpointAbstractPart.this.selectedColumnIndex = cell.getColumnIndex();
                }
                e.doit = CheckpointAbstractPart.this.selectedColumnIndex != -1;
            }
        });
    }

    private void checkUncheckTableColumn(boolean isChecked) {
        this.executeOperation((IUndoableOperation)new CheckUncheckColumnOperation(this.selectedColumnIndex, isChecked));
    }

    protected void checkUncheckTableRow(boolean isChecked) {
        Table table = this.tableViewer.getTable();
        int index = table.getSelectionIndex();
        if (index == -1) {
            return;
        }
        this.executeOperation((IUndoableOperation)new CheckUncheckRowOperation(index, isChecked));
    }

    protected void checkUncheckAll(boolean isChecked) {
        this.executeOperation((IUndoableOperation)new CheckUncheckAllOperation(isChecked));
    }

    private void redrawArrowIndicator() {
        this.lblArrowIndicator.getParent().setRedraw(false);
        this.lblArrowIndicator.setImage(this.compSourceInfoDetails.isVisible() ? ImageConstants.IMG_16_ARROW_DOWN : ImageConstants.IMG_16_ARROW);
        this.lblArrowIndicator.getParent().setRedraw(true);
    }

    private void resizeTableOnElasticSourceInfo() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                CheckpointAbstractPart.this.compSourceInfoDetails.setVisible(!CheckpointAbstractPart.this.compSourceInfoDetails.isVisible());
                GridData fileInfoGridData = (GridData)CheckpointAbstractPart.this.compSourceInfoDetails.getLayoutData();
                fileInfoGridData.exclude = !CheckpointAbstractPart.this.compSourceInfoDetails.isVisible();
                CheckpointAbstractPart.this.compTable.layout(true, true);
                CheckpointAbstractPart.this.compTable.getParent().layout();
                CheckpointAbstractPart.this.redrawArrowIndicator();
            }
        });
    }

    private void takeSnapshot() {
        this.executeOperation((IUndoableOperation)new TakeSnapshotOperation());
    }

    private void addControlListeners() {
        MouseAdapter sourceInfoClickListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CheckpointAbstractPart.this.resizeTableOnElasticSourceInfo();
            }
        };
        this.lblArrowIndicator.addMouseListener((MouseListener)sourceInfoClickListener);
        this.lblSourceInfo.addMouseListener((MouseListener)sourceInfoClickListener);
        this.compSourceInfoHeader.addMouseListener((MouseListener)sourceInfoClickListener);
        this.btnTakeSnapshot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointAbstractPart.this.takeSnapshot();
            }
        });
        this.addSourceInfoConstrolListeners();
    }

    protected abstract void addSourceInfoConstrolListeners();

    private void registerEventListeners() {
        this.eventBroker.subscribe("CHECKPOINT/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        Object eventData = event.getProperty("org.eclipse.e4.data");
        if (eventData == null) {
            return;
        }
        switch (event.getTopic()) {
            case "CHECKPOINT/UPDATED": {
                this.updateCheckpointEventAction(eventData);
                break;
            }
            case "EXPLORER/REFRESH_SELECTED_ITEM": {
                this.refreshCheckpointEventAction(eventData);
                break;
            }
        }
    }

    private void refreshCheckpointEventAction(Object eventData) {
        if (!(eventData instanceof CheckpointTreeEntity)) {
            return;
        }
        try {
            CheckpointEntity checkpointEntity = ((CheckpointTreeEntity)eventData).getObject();
            if (!StringUtils.equals((String)checkpointEntity.getId(), (String)this.getCheckpoint().getId())) {
                return;
            }
            if (CheckpointController.getInstance().getById(checkpointEntity.getId()) == null) {
                this.onClose();
                return;
            }
            if (this.isDirty()) {
                this.verifySourceChanged();
                return;
            }
            this.loadCheckpoint(checkpointEntity);
            this.setDirty(false);
        }
        catch (DALException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void updateCheckpointEventAction(Object eventData) {
        if (!eventData.getClass().isArray() || ((Object[])eventData).length != 2) {
            return;
        }
        Object[] data = (Object[])eventData;
        String id = EntityPartUtil.getCheckpointPartId((String)ObjectUtils.toString((Object)data[0]));
        if (!StringUtils.equals((String)id, (String)this.getPart().getElementId())) {
            return;
        }
        this.loadCheckpoint((CheckpointEntity)data[1]);
    }

    private void verifySourceChanged() {
        try {
            if (this.isDirty()) {
                return;
            }
            CheckpointEntity currentCheckpoint = this.getCheckpoint();
            if (currentCheckpoint == null) {
                return;
            }
            CheckpointEntity reloadedCheckpoint = CheckpointController.getInstance().getById(currentCheckpoint.getId());
            if (reloadedCheckpoint == null) {
                FolderTreeEntity parentFolderTreeEntity = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)currentCheckpoint.getParentFolder(), (FolderEntity)FolderController.getInstance().getCheckpointRoot(currentCheckpoint.getProject()));
                if (parentFolderTreeEntity != null) {
                    this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentFolderTreeEntity);
                }
                this.onClose();
                return;
            }
            if (currentCheckpoint.equals((Object)reloadedCheckpoint)) {
                return;
            }
            if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.PART_TITLE_RELOAD, (String)StringConstants.PART_MSG_RELOAD_FILE_CONTENT)) {
                this.loadCheckpoint(reloadedCheckpoint);
                this.setDirty(false);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void loadCheckpoint(CheckpointEntity checkpoint) {
        this.checkpoint = checkpoint;
        this.setCheckpoint(checkpoint.clone());
    }

    private void setCheckpoint(CheckpointEntity checkpoint) {
        this.tempCheckpoint = checkpoint;
        this.refreshPart(this.tempCheckpoint);
    }

    protected void refreshPart(CheckpointEntity checkpoint) {
        this.getPart().setLabel(checkpoint.getName());
        this.getPart().setElementId(EntityPartUtil.getCheckpointPartId((String)checkpoint.getId()));
        this.loadCheckpointSourceInfo(checkpoint.getSourceInfo());
        this.loadCheckpointData(checkpoint);
        this.updateStatus();
    }

    protected abstract void loadCheckpointSourceInfo(CheckpointSourceInfo var1);

    private void loadCheckpointData(CheckpointEntity checkpoint) {
        this.tableViewer.getTable().setRedraw(false);
        this.clearTable();
        this.tableViewer.getTable().setHeaderVisible(true);
        CheckpointSourceInfo sourceInfo = checkpoint.getSourceInfo();
        List checkpointData = checkpoint.getCheckpointData();
        List columnNames = checkpoint.getColumnNames();
        if (sourceInfo == null || checkpointData == null || checkpointData.isEmpty()) {
            this.tableViewer.getTable().setRedraw(true);
            return;
        }
        int i = 0;
        while (i < ((List)checkpointData.get(0)).size()) {
            TableViewerColumn columnViewer = new TableViewerColumn(this.tableViewer, 0);
            columnViewer.setLabelProvider((CellLabelProvider)new CheckpointCellLabelProvider(i));
            columnViewer.setEditingSupport((EditingSupport)new CheckpointCellEditingSupport(columnViewer.getViewer(), i, this));
            TableColumn column = columnViewer.getColumn();
            column.setWidth(200);
            column.setText(StringUtils.defaultString((String)((String)columnNames.get(i))));
            ++i;
        }
        this.tableViewer.setInput((Object)checkpointData);
        this.tableViewer.getTable().setRedraw(true);
    }

    private void clearTable() {
        Table table = this.tableViewer.getTable();
        while (table.getColumnCount() > 1) {
            table.getColumns()[1].dispose();
        }
        this.tableViewer.setInput(Collections.emptyList());
    }

    private void updateStatus() {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                Color color = ColorUtil.getWarningForegroudColor();
                String info = StringConstants.PART_LBL_NO_CHECKPOINT_DATA;
                Date takenDate = CheckpointAbstractPart.this.getCheckpoint().getTakenDate();
                if (takenDate != null) {
                    color = ColorUtil.getTextSuccessfulColor();
                    info = MessageFormat.format(StringConstants.PART_LBL_SNAPSHOT_WAS_TAKEN_ON_X, takenDate.toString());
                }
                CheckpointAbstractPart.this.lblStatus.setForeground(color);
                CheckpointAbstractPart.this.lblStatus.setText(info);
                CheckpointAbstractPart.this.compSourceInfoHeader.layout();
            }
        });
    }

    @Persist
    public void save() {
        try {
            this.checkpoint.copyPropertiesFrom(this.tempCheckpoint);
            CheckpointController.getInstance().update(this.checkpoint);
            this.setDirty(false);
            this.eventBroker.post("CHECKPOINT/UPDATED", (Object)new Object[]{this.checkpoint.getIdForDisplay(), this.checkpoint});
            CheckpointTreeEntity checkpointTreeEntity = TreeEntityUtil.getCheckpointTreeEntity((CheckpointEntity)this.checkpoint, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)checkpointTreeEntity);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR, (String)StringConstants.PART_MSG_UNABLE_TO_SAVE_CHECKPOINT);
        }
    }

    @Focus
    public void onFocused() {
        this.verifySourceChanged();
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
        this.eventBroker.unsubscribe((EventHandler)this);
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.getPart());
        super.dispose();
    }

    public void setDirty(boolean isDirty) {
        this.dirtyable.setDirty(isDirty);
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }

    public MPart getPart() {
        return this.part;
    }

    public CheckpointEntity getCheckpoint() {
        return this.tempCheckpoint;
    }

    public String getEntityId() {
        return this.getCheckpoint().getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.checkpoint == null) {
            return;
        }
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !StringUtils.equals((String)part.getElementId(), (String)this.getPart().getElementId())) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.checkpoint);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof CheckpointEntity)) {
            return;
        }
        CheckpointEntity updatedEntity = (CheckpointEntity)eventData;
        if (!StringUtils.equals((String)updatedEntity.getIdForDisplay(), (String)this.getEntityId())) {
            return;
        }
        this.checkpoint.setTag(updatedEntity.getTag());
        this.checkpoint.setDescription(updatedEntity.getDescription());
    }

    private abstract class AbstractCheckUncheckOperation
    extends AbstractOperation {
        protected Map<CheckpointCell, Boolean> oldCheckedDatas;
        protected boolean isChecked;

        public AbstractCheckUncheckOperation(String label, boolean isChecked) {
            super(label);
            this.oldCheckedDatas = new LinkedHashMap<CheckpointCell, Boolean>();
            this.isChecked = isChecked;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (Map.Entry<CheckpointCell, Boolean> oldCheckedData : this.oldCheckedDatas.entrySet()) {
                oldCheckedData.getKey().setChecked(this.isChecked);
            }
            CheckpointAbstractPart.this.tableViewer.refresh();
            CheckpointAbstractPart.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (Map.Entry<CheckpointCell, Boolean> oldCheckedData : this.oldCheckedDatas.entrySet()) {
                oldCheckedData.getKey().setChecked(oldCheckedData.getValue().booleanValue());
            }
            CheckpointAbstractPart.this.tableViewer.refresh();
            CheckpointAbstractPart.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    protected abstract class ChangeCheckpointSourceInfoOperation
    extends AbstractOperation {
        protected CheckpointSourceInfo oldCheckpointSourceInfo;
        protected CheckpointSourceInfo newCheckpointSourceInfo;

        public ChangeCheckpointSourceInfoOperation(String label) {
            super(label);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CheckpointAbstractPart.this.getCheckpoint().setSourceInfo(this.newCheckpointSourceInfo);
            CheckpointAbstractPart.this.loadCheckpointSourceInfo(this.newCheckpointSourceInfo);
            CheckpointAbstractPart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CheckpointAbstractPart.this.getCheckpoint().setSourceInfo(this.oldCheckpointSourceInfo);
            CheckpointAbstractPart.this.loadCheckpointSourceInfo(this.oldCheckpointSourceInfo);
            CheckpointAbstractPart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class CheckUncheckAllOperation
    extends AbstractCheckUncheckOperation {
        public CheckUncheckAllOperation(boolean isChecked) {
            super(CheckUncheckAllOperation.class.getName(), isChecked);
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            TableItem[] rows = CheckpointAbstractPart.this.tableViewer.getTable().getItems();
            if (rows == null || rows.length == 0) {
                return Status.CANCEL_STATUS;
            }
            TableItem[] tableItemArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem row = tableItemArray[n2];
                Object rowData = row.getData();
                if (rowData != null && rowData instanceof List && !((List)rowData).isEmpty()) {
                    for (Object cellData : (List)rowData) {
                        if (!(cellData instanceof CheckpointCell)) continue;
                        CheckpointCell checkpointCell = (CheckpointCell)cellData;
                        this.oldCheckedDatas.put(checkpointCell, checkpointCell.isChecked());
                        checkpointCell.setChecked(this.isChecked);
                    }
                }
                ++n2;
            }
            CheckpointAbstractPart.this.tableViewer.refresh();
            CheckpointAbstractPart.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class CheckUncheckColumnOperation
    extends AbstractCheckUncheckOperation {
        private int selectedColumnIndex;

        public CheckUncheckColumnOperation(int selectedColumnIndex, boolean isChecked) {
            super(CheckUncheckColumnOperation.class.getName(), isChecked);
            this.selectedColumnIndex = selectedColumnIndex;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.selectedColumnIndex == -1) {
                return Status.CANCEL_STATUS;
            }
            TableItem[] rows = CheckpointAbstractPart.this.tableViewer.getTable().getItems();
            if (rows == null || rows.length == 0) {
                return Status.CANCEL_STATUS;
            }
            TableItem[] tableItemArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                List dataList;
                TableItem row = tableItemArray[n2];
                Object rowData = row.getData();
                if (rowData != null && rowData instanceof List && !(dataList = (List)rowData).isEmpty() && this.selectedColumnIndex <= dataList.size() && dataList.get(this.selectedColumnIndex - 1) instanceof CheckpointCell) {
                    CheckpointCell checkpointCell = (CheckpointCell)dataList.get(this.selectedColumnIndex - 1);
                    this.oldCheckedDatas.put(checkpointCell, checkpointCell.isChecked());
                    checkpointCell.setChecked(this.isChecked);
                }
                ++n2;
            }
            CheckpointAbstractPart.this.tableViewer.refresh();
            CheckpointAbstractPart.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class CheckUncheckRowOperation
    extends AbstractCheckUncheckOperation {
        private int selectedRowIndex;

        public CheckUncheckRowOperation(int selectedRowIndex, boolean isChecked) {
            super(CheckUncheckRowOperation.class.getName(), isChecked);
            this.selectedRowIndex = selectedRowIndex;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.selectedRowIndex == -1) {
                return Status.CANCEL_STATUS;
            }
            Object rowData = CheckpointAbstractPart.this.tableViewer.getTable().getItem(this.selectedRowIndex).getData();
            if (rowData == null || !(rowData instanceof List) || ((List)rowData).isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            for (Object cellData : (List)rowData) {
                if (!(cellData instanceof CheckpointCell)) continue;
                CheckpointCell checkpointCell = (CheckpointCell)cellData;
                this.oldCheckedDatas.put(checkpointCell, checkpointCell.isChecked());
                checkpointCell.setChecked(this.isChecked);
            }
            CheckpointAbstractPart.this.tableViewer.refresh(rowData);
            CheckpointAbstractPart.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class TakeSnapshotOperation
    extends AbstractOperation {
        private CheckpointEntity oldCheckpoint;
        private CheckpointEntity newCheckpoint;

        public TakeSnapshotOperation() {
            super(TakeSnapshotOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                CheckpointEntity currentCheckpoint = CheckpointAbstractPart.this.getCheckpoint();
                this.oldCheckpoint = currentCheckpoint.clone();
                CheckpointController.getInstance().takeSnapshot(currentCheckpoint);
                this.newCheckpoint = currentCheckpoint.clone();
                CheckpointAbstractPart.this.refreshPart(currentCheckpoint);
                CheckpointAbstractPart.this.setDirty(true);
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
                MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)StringConstants.PART_MSG_CANNOT_TAKE_SNAPSHOT, (String)ex.getMessage());
                return Status.CANCEL_STATUS;
            }
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CheckpointAbstractPart.this.setCheckpoint(this.newCheckpoint);
            CheckpointAbstractPart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CheckpointAbstractPart.this.setCheckpoint(this.oldCheckpoint);
            CheckpointAbstractPart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }
}

