/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.transport;

import com.github.dockerjava.transport.DomainSocket;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

class LinuxDomainSocket
extends DomainSocket {
    private static final int MAX_PATH_LENGTH = 108;

    LinuxDomainSocket(String path) throws IOException {
        super(path);
    }

    @Override
    protected void connect(String path, int handle2) {
        SockaddrUn address = new SockaddrUn(1, path.getBytes(StandardCharsets.UTF_8));
        this.connect(handle2, address, address.size());
    }

    private native int connect(int var1, SockaddrUn var2, int var3) throws LastErrorException;

    static {
        Native.register(Platform.C_LIBRARY_NAME);
    }

    public static class SockaddrUn
    extends Structure
    implements Structure.ByReference {
        public short sunFamily;
        public byte[] sunPath = new byte[108];

        private SockaddrUn(byte sunFamily, byte[] path) {
            if (path.length > 108) {
                throw new IllegalArgumentException("Path cannot exceed 108 bytes");
            }
            System.arraycopy(path, 0, this.sunPath, 0, path.length);
            this.sunPath[path.length] = 0;
            this.sunFamily = sunFamily;
            this.allocateMemory();
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("sunFamily", "sunPath");
        }
    }
}

