/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchemaElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

@Internal
public class GraphqlTypeComparators {
    public static <T extends GraphQLSchemaElement> List<T> sortTypes(Comparator<? super GraphQLSchemaElement> comparator, Collection<T> types) {
        ArrayList<T> sorted2 = new ArrayList<T>(types);
        sorted2.sort(comparator);
        return ImmutableList.copyOf(sorted2);
    }

    public static Comparator<? super GraphQLSchemaElement> asIsOrder() {
        return (o1, o2) -> 0;
    }

    public static Comparator<? super GraphQLSchemaElement> byNameAsc() {
        return Comparator.comparing(graphQLSchemaElement -> ((GraphQLNamedSchemaElement)graphQLSchemaElement).getName());
    }
}

