/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Assert;
import graphql.Internal;
import graphql.schema.GraphQLSchema;
import graphql.schema.diffing.DiffImpl;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.EditOperation;
import graphql.schema.diffing.EditorialCostForMapping;
import graphql.schema.diffing.FillupIsolatedVertices;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.SchemaDiffingRunningCheck;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.SchemaGraphFactory;
import graphql.schema.diffing.Vertex;
import graphql.schema.diffing.ana.EditOperationAnalysisResult;
import graphql.schema.diffing.ana.EditOperationAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
public class SchemaDiffing {
    private final SchemaDiffingRunningCheck runningCheck = new SchemaDiffingRunningCheck();
    SchemaGraph sourceGraph;
    SchemaGraph targetGraph;

    public void stop() {
        this.runningCheck.stop();
    }

    public List<EditOperation> diffGraphQLSchema(GraphQLSchema graphQLSchema1, GraphQLSchema graphQLSchema2) throws Exception {
        this.sourceGraph = new SchemaGraphFactory("source-").createGraph(graphQLSchema1);
        this.targetGraph = new SchemaGraphFactory("target-").createGraph(graphQLSchema2);
        return this.diffImpl((SchemaGraph)this.sourceGraph, (SchemaGraph)this.targetGraph).listOfEditOperations.get(0);
    }

    public EditOperationAnalysisResult diffAndAnalyze(GraphQLSchema graphQLSchema1, GraphQLSchema graphQLSchema2) throws Exception {
        this.sourceGraph = new SchemaGraphFactory("source-").createGraph(graphQLSchema1);
        this.targetGraph = new SchemaGraphFactory("target-").createGraph(graphQLSchema2);
        DiffImpl.OptimalEdit optimalEdit = this.diffImpl(this.sourceGraph, this.targetGraph);
        EditOperationAnalyzer editOperationAnalyzer = new EditOperationAnalyzer(graphQLSchema1, graphQLSchema1, this.sourceGraph, this.targetGraph);
        return editOperationAnalyzer.analyzeEdits(optimalEdit.listOfEditOperations.get(0), optimalEdit.mappings.get(0));
    }

    public DiffImpl.OptimalEdit diffGraphQLSchemaAllEdits(GraphQLSchema graphQLSchema1, GraphQLSchema graphQLSchema2) throws Exception {
        this.sourceGraph = new SchemaGraphFactory("source-").createGraph(graphQLSchema1);
        this.targetGraph = new SchemaGraphFactory("target-").createGraph(graphQLSchema2);
        return this.diffImpl(this.sourceGraph, this.targetGraph);
    }

    private DiffImpl.OptimalEdit diffImpl(SchemaGraph sourceGraph, SchemaGraph targetGraph) throws Exception {
        int sizeDiff = targetGraph.size() - sourceGraph.size();
        System.out.println("graph diff: " + sizeDiff);
        FillupIsolatedVertices fillupIsolatedVertices = new FillupIsolatedVertices(sourceGraph, targetGraph, this.runningCheck);
        fillupIsolatedVertices.ensureGraphAreSameSize();
        FillupIsolatedVertices.IsolatedVertices isolatedVertices = fillupIsolatedVertices.getIsolatedVertices();
        Assert.assertTrue(sourceGraph.size() == targetGraph.size());
        Mapping fixedMappings = isolatedVertices.mapping;
        System.out.println("fixed mappings: " + fixedMappings.size() + " vs " + sourceGraph.size());
        if (fixedMappings.size() == sourceGraph.size()) {
            ArrayList<EditOperation> result = new ArrayList<EditOperation>();
            EditorialCostForMapping.editorialCostForMapping(fixedMappings, sourceGraph, targetGraph, result);
            return new DiffImpl.OptimalEdit(Collections.singletonList(fixedMappings), Collections.singletonList(result), result.size());
        }
        DiffImpl diffImpl = new DiffImpl(sourceGraph, targetGraph, isolatedVertices, this.runningCheck);
        ArrayList<Vertex> nonMappedSource = new ArrayList<Vertex>(sourceGraph.getVertices());
        nonMappedSource.removeAll(fixedMappings.getSources());
        ArrayList<Vertex> nonMappedTarget = new ArrayList<Vertex>(targetGraph.getVertices());
        nonMappedTarget.removeAll(fixedMappings.getTargets());
        this.runningCheck.check();
        this.sortListBasedOnPossibleMapping(nonMappedSource, isolatedVertices);
        ArrayList<Vertex> sourceVertices = new ArrayList<Vertex>();
        sourceVertices.addAll(fixedMappings.getSources());
        sourceVertices.addAll(nonMappedSource);
        ArrayList<Vertex> targetGraphVertices = new ArrayList<Vertex>();
        targetGraphVertices.addAll(fixedMappings.getTargets());
        targetGraphVertices.addAll(nonMappedTarget);
        DiffImpl.OptimalEdit optimalEdit = diffImpl.diffImpl(fixedMappings, sourceVertices, targetGraphVertices);
        return optimalEdit;
    }

    private void sortListBasedOnPossibleMapping(List<Vertex> sourceVertices, FillupIsolatedVertices.IsolatedVertices isolatedVertices) {
        Collections.sort(sourceVertices, (v1, v2) -> {
            int v2Count = isolatedVertices.possibleMappings.get((Vertex)v2).size();
            int v1Count = isolatedVertices.possibleMappings.get((Vertex)v1).size();
            return Integer.compare(v2Count, v1Count);
        });
    }

    private List<EditOperation> calcEdgeOperations(Mapping mapping) {
        List<Edge> edges = this.sourceGraph.getEdges();
        ArrayList<EditOperation> result = new ArrayList<EditOperation>();
        for (Edge sourceEdge : edges) {
            Vertex target2;
            Vertex target1 = mapping.getTarget(sourceEdge.getFrom());
            Edge targetEdge = this.targetGraph.getEdge(target1, target2 = mapping.getTarget(sourceEdge.getTo()));
            if (targetEdge == null) {
                result.add(EditOperation.deleteEdge("Delete edge " + sourceEdge, sourceEdge));
                continue;
            }
            if (sourceEdge.getLabel().equals(targetEdge.getLabel())) continue;
            result.add(EditOperation.changeEdge("Change " + sourceEdge + " to " + targetEdge, sourceEdge, targetEdge));
        }
        for (Edge targetEdge : this.targetGraph.getEdges()) {
            Vertex sourceTo;
            Vertex sourceFrom = mapping.getSource(targetEdge.getFrom());
            if (this.sourceGraph.getEdge(sourceFrom, sourceTo = mapping.getSource(targetEdge.getTo())) != null) continue;
            result.add(EditOperation.insertEdge("Insert edge " + targetEdge, targetEdge));
        }
        return result;
    }
}

