/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.ImplementingTypesChecker;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarWiringEnvironment;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.SchemaTypeDirectivesChecker;
import graphql.schema.idl.SchemaTypeExtensionsChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.UnionTypesChecker;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.DirectiveIllegalLocationError;
import graphql.schema.idl.errors.MissingInterfaceTypeError;
import graphql.schema.idl.errors.MissingScalarImplementationError;
import graphql.schema.idl.errors.MissingTypeError;
import graphql.schema.idl.errors.MissingTypeResolverError;
import graphql.schema.idl.errors.NonUniqueArgumentError;
import graphql.schema.idl.errors.NonUniqueNameError;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Internal
public class SchemaTypeChecker {
    public List<GraphQLError> checkTypeRegistry(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        ArrayList<GraphQLError> errors2 = new ArrayList<GraphQLError>();
        this.checkForMissingTypes(errors2, typeRegistry);
        SchemaTypeExtensionsChecker typeExtensionsChecker = new SchemaTypeExtensionsChecker();
        typeExtensionsChecker.checkTypeExtensions(errors2, typeRegistry);
        ImplementingTypesChecker implementingTypesChecker = new ImplementingTypesChecker();
        implementingTypesChecker.checkImplementingTypes(errors2, typeRegistry);
        UnionTypesChecker unionTypesChecker = new UnionTypesChecker();
        unionTypesChecker.checkUnionType(errors2, typeRegistry);
        SchemaExtensionsChecker.checkSchemaInvariants(errors2, typeRegistry);
        this.checkScalarImplementationsArePresent(errors2, typeRegistry, wiring);
        this.checkTypeResolversArePresent(errors2, typeRegistry, wiring);
        this.checkFieldsAreSensible(errors2, typeRegistry);
        this.checkDirectiveDefinitions(typeRegistry, errors2);
        SchemaTypeDirectivesChecker directivesChecker = new SchemaTypeDirectivesChecker(typeRegistry, wiring);
        directivesChecker.checkTypeDirectives(errors2);
        return errors2;
    }

    private void checkForMissingTypes(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry) {
        List<ObjectTypeExtensionDefinition> typeExtensions = typeRegistry.objectTypeExtensions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        typeExtensions.forEach(typeExtension -> {
            List<Type> implementsTypes = typeExtension.getImplements();
            implementsTypes.forEach(this.checkInterfaceTypeExists(typeRegistry, errors2, (TypeDefinition)typeExtension));
            this.checkFieldTypesPresent(typeRegistry, errors2, (TypeDefinition)typeExtension, typeExtension.getFieldDefinitions());
        });
        Map<String, TypeDefinition> typesMap = typeRegistry.types();
        List<ObjectTypeDefinition> objectTypes = this.filterTo(typesMap, ObjectTypeDefinition.class);
        objectTypes.forEach(objectType -> {
            List<Type> implementsTypes = objectType.getImplements();
            implementsTypes.forEach(this.checkInterfaceTypeExists(typeRegistry, errors2, (TypeDefinition)objectType));
            this.checkFieldTypesPresent(typeRegistry, errors2, (TypeDefinition)objectType, objectType.getFieldDefinitions());
        });
        List<InterfaceTypeDefinition> interfaceTypes = this.filterTo(typesMap, InterfaceTypeDefinition.class);
        interfaceTypes.forEach(interfaceType -> {
            List<FieldDefinition> fields = interfaceType.getFieldDefinitions();
            this.checkFieldTypesPresent(typeRegistry, errors2, (TypeDefinition)interfaceType, fields);
        });
        List<UnionTypeDefinition> unionTypes = this.filterTo(typesMap, UnionTypeDefinition.class);
        unionTypes.forEach(unionType -> {
            List<Type> memberTypes = unionType.getMemberTypes();
            memberTypes.forEach(this.checkTypeExists("union member", typeRegistry, errors2, (TypeDefinition)unionType));
        });
        List<InputObjectTypeDefinition> inputTypes = this.filterTo(typesMap, InputObjectTypeDefinition.class);
        inputTypes.forEach(inputType -> {
            List<InputValueDefinition> inputValueDefinitions = inputType.getInputValueDefinitions();
            List<Type> inputValueTypes = inputValueDefinitions.stream().map(InputValueDefinition::getType).collect(Collectors.toList());
            inputValueTypes.forEach(this.checkTypeExists("input value", typeRegistry, errors2, (TypeDefinition)inputType));
        });
    }

    private void checkDirectiveDefinitions(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors2) {
        ArrayList<DirectiveDefinition> directiveDefinitions = new ArrayList<DirectiveDefinition>(typeRegistry.getDirectiveDefinitions().values());
        directiveDefinitions.forEach(directiveDefinition -> {
            List<InputValueDefinition> arguments = directiveDefinition.getInputValueDefinitions();
            SchemaTypeChecker.checkNamedUniqueness(errors2, arguments, InputValueDefinition::getName, (name, arg) -> new NonUniqueNameError((DirectiveDefinition)directiveDefinition, (InputValueDefinition)arg));
            List<Type> inputValueTypes = arguments.stream().map(InputValueDefinition::getType).collect(Collectors.toList());
            inputValueTypes.forEach(this.checkTypeExists(typeRegistry, errors2, "directive definition", (Node)directiveDefinition, directiveDefinition.getName()));
            directiveDefinition.getDirectiveLocations().forEach(directiveLocation -> {
                String locationName = directiveLocation.getName();
                try {
                    Introspection.DirectiveLocation.valueOf(locationName);
                }
                catch (IllegalArgumentException e) {
                    errors2.add(new DirectiveIllegalLocationError((DirectiveDefinition)directiveDefinition, locationName));
                }
            });
        });
    }

    private void checkScalarImplementationsArePresent(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) {
        typeRegistry.scalars().forEach((scalarName, scalarTypeDefinition) -> {
            ScalarWiringEnvironment environment;
            WiringFactory wiringFactory = wiring.getWiringFactory();
            if (!wiringFactory.providesScalar(environment = new ScalarWiringEnvironment(typeRegistry, (ScalarTypeDefinition)scalarTypeDefinition, (List<ScalarTypeExtensionDefinition>)ImmutableKit.emptyList())) && !wiring.getScalars().containsKey(scalarName)) {
                errors2.add(new MissingScalarImplementationError((String)scalarName));
            }
        });
    }

    private void checkFieldsAreSensible(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry) {
        Map<String, TypeDefinition> typesMap = typeRegistry.types();
        Map<String, DirectiveDefinition> directiveDefinitionMap = typeRegistry.getDirectiveDefinitions();
        List<ObjectTypeDefinition> objectTypes = this.filterTo(typesMap, ObjectTypeDefinition.class);
        objectTypes.forEach(objectType -> this.checkObjTypeFields(errors2, (ObjectTypeDefinition)objectType, objectType.getFieldDefinitions(), directiveDefinitionMap));
        List<InterfaceTypeDefinition> interfaceTypes = this.filterTo(typesMap, InterfaceTypeDefinition.class);
        interfaceTypes.forEach(interfaceType -> this.checkInterfaceFields(errors2, (InterfaceTypeDefinition)interfaceType, interfaceType.getFieldDefinitions(), directiveDefinitionMap));
        List<EnumTypeDefinition> enumTypes = this.filterTo(typesMap, EnumTypeDefinition.class);
        enumTypes.forEach(enumType -> this.checkEnumValues(errors2, (EnumTypeDefinition)enumType, enumType.getEnumValueDefinitions(), directiveDefinitionMap));
        List<InputObjectTypeDefinition> inputTypes = this.filterTo(typesMap, InputObjectTypeDefinition.class);
        inputTypes.forEach(inputType -> this.checkInputValues(errors2, (InputObjectTypeDefinition)inputType, inputType.getInputValueDefinitions(), Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, directiveDefinitionMap));
    }

    private void checkObjTypeFields(List<GraphQLError> errors2, ObjectTypeDefinition typeDefinition, List<FieldDefinition> fieldDefinitions, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        SchemaTypeChecker.checkNamedUniqueness(errors2, fieldDefinitions, FieldDefinition::getName, (name, fieldDef) -> new NonUniqueNameError((TypeDefinition)typeDefinition, (FieldDefinition)fieldDef));
        fieldDefinitions.forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors2, fld.getInputValueDefinitions(), InputValueDefinition::getName, (name, inputValueDefinition) -> new NonUniqueArgumentError((TypeDefinition)typeDefinition, (FieldDefinition)fld, (String)name)));
        fieldDefinitions.forEach(fld -> fld.getDirectives().forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors2, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)typeDefinition, (FieldDefinition)fld, (String)argumentName))));
    }

    private void checkInterfaceFields(List<GraphQLError> errors2, InterfaceTypeDefinition interfaceType, List<FieldDefinition> fieldDefinitions, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        SchemaTypeChecker.checkNamedUniqueness(errors2, fieldDefinitions, FieldDefinition::getName, (name, fieldDef) -> new NonUniqueNameError((TypeDefinition)interfaceType, (FieldDefinition)fieldDef));
        fieldDefinitions.forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors2, fld.getInputValueDefinitions(), InputValueDefinition::getName, (name, inputValueDefinition) -> new NonUniqueArgumentError((TypeDefinition)interfaceType, (FieldDefinition)fld, (String)name)));
        fieldDefinitions.forEach(fieldDefinition -> {
            List<Directive> directives = fieldDefinition.getDirectives();
            directives.forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors2, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)interfaceType, (FieldDefinition)fieldDefinition, (String)argumentName)));
        });
    }

    private void checkEnumValues(List<GraphQLError> errors2, EnumTypeDefinition enumType, List<EnumValueDefinition> enumValueDefinitions, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        SchemaTypeChecker.checkNamedUniqueness(errors2, enumValueDefinitions, EnumValueDefinition::getName, (name, inputValueDefinition) -> new NonUniqueNameError((TypeDefinition)enumType, (EnumValueDefinition)inputValueDefinition));
        enumValueDefinitions.forEach(enumValue -> enumValue.getDirectives().forEach(directive -> {
            BiFunction<String, Argument, NonUniqueArgumentError> errorFunction = (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)enumType, (EnumValueDefinition)enumValue, (String)argumentName);
            SchemaTypeChecker.checkNamedUniqueness(errors2, directive.getArguments(), Argument::getName, errorFunction);
        }));
    }

    private void checkInputValues(List<GraphQLError> errors2, InputObjectTypeDefinition inputType, List<InputValueDefinition> inputValueDefinitions, Introspection.DirectiveLocation directiveLocation, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        SchemaTypeChecker.checkNamedUniqueness(errors2, inputValueDefinitions, InputValueDefinition::getName, (name, inputValueDefinition) -> {
            InputObjectTypeDefinition as = inputType;
            return new NonUniqueNameError(as, (InputValueDefinition)inputValueDefinition);
        });
        inputValueDefinitions.forEach(inputValueDef -> inputValueDef.getDirectives().forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors2, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)inputType, (InputValueDefinition)inputValueDef, (String)argumentName))));
    }

    static <T, E extends GraphQLError> void checkNamedUniqueness(List<GraphQLError> errors2, List<T> listOfNamedThings, Function<T, String> namer, BiFunction<String, T, E> errorFunction) {
        LinkedHashSet names = new LinkedHashSet();
        listOfNamedThings.forEach(thing -> {
            String name = (String)namer.apply(thing);
            if (names.contains(name)) {
                errors2.add((GraphQLError)errorFunction.apply(name, thing));
            } else {
                names.add(name);
            }
        });
    }

    private void checkTypeResolversArePresent(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) {
        Predicate<InterfaceTypeDefinition> noDynamicResolverForInterface = interfaceTypeDef -> !wiring.getWiringFactory().providesTypeResolver(new InterfaceWiringEnvironment(typeRegistry, (InterfaceTypeDefinition)interfaceTypeDef));
        Predicate<UnionTypeDefinition> noDynamicResolverForUnion = unionTypeDef -> !wiring.getWiringFactory().providesTypeResolver(new UnionWiringEnvironment(typeRegistry, (UnionTypeDefinition)unionTypeDef));
        Predicate<TypeDefinition> noTypeResolver = typeDefinition -> !wiring.getTypeResolvers().containsKey(typeDefinition.getName());
        Consumer<TypeDefinition> addError = typeDefinition -> errors2.add(new MissingTypeResolverError((TypeDefinition)typeDefinition));
        typeRegistry.types().values().stream().filter(typeDef -> typeDef instanceof InterfaceTypeDefinition).map(InterfaceTypeDefinition.class::cast).filter(noDynamicResolverForInterface).filter(noTypeResolver).forEach(addError);
        typeRegistry.types().values().stream().filter(typeDef -> typeDef instanceof UnionTypeDefinition).map(UnionTypeDefinition.class::cast).filter(noDynamicResolverForUnion).filter(noTypeResolver).forEach(addError);
    }

    private void checkFieldTypesPresent(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors2, TypeDefinition typeDefinition, List<FieldDefinition> fields) {
        List<Type> fieldTypes = fields.stream().map(FieldDefinition::getType).collect(Collectors.toList());
        fieldTypes.forEach(this.checkTypeExists("field", typeRegistry, errors2, typeDefinition));
        List<Type> fieldInputValues = fields.stream().map(f -> f.getInputValueDefinitions().stream().map(InputValueDefinition::getType).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        fieldInputValues.forEach(this.checkTypeExists("field input", typeRegistry, errors2, typeDefinition));
    }

    private Consumer<Type> checkTypeExists(String typeOfType, TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors2, TypeDefinition typeDefinition) {
        return t2 -> {
            TypeName unwrapped = TypeInfo.typeInfo(t2).getTypeName();
            if (!typeRegistry.hasType(unwrapped)) {
                errors2.add(new MissingTypeError(typeOfType, typeDefinition, unwrapped));
            }
        };
    }

    private Consumer<Type> checkTypeExists(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors2, String typeOfType, Node element, String elementName) {
        return ivType -> {
            TypeName unwrapped = TypeInfo.typeInfo(ivType).getTypeName();
            if (!typeRegistry.hasType(unwrapped)) {
                errors2.add(new MissingTypeError(typeOfType, element, elementName, unwrapped));
            }
        };
    }

    private Consumer<? super Type> checkInterfaceTypeExists(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors2, TypeDefinition typeDefinition) {
        return t2 -> {
            TypeInfo typeInfo = TypeInfo.typeInfo(t2);
            TypeName unwrapped = typeInfo.getTypeName();
            Optional<TypeDefinition> type = typeRegistry.getType(unwrapped);
            if (!type.isPresent()) {
                errors2.add(new MissingInterfaceTypeError("interface", typeDefinition, unwrapped));
            } else if (!(type.get() instanceof InterfaceTypeDefinition)) {
                errors2.add(new MissingInterfaceTypeError("interface", typeDefinition, unwrapped));
            }
        };
    }

    private <T extends TypeDefinition> List<T> filterTo(Map<String, TypeDefinition> types, Class<? extends T> clazz) {
        return types.values().stream().filter(t2 -> clazz.equals(t2.getClass())).map(clazz::cast).collect(Collectors.toList());
    }
}

