/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.com.google.common.collect.Sets;
import graphql.util.InterThreadMemoizedSupplier;
import graphql.util.IntraThreadMemoizedSupplier;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public class FpKit {
    public static <T> Map<String, T> getByName(List<T> namedObjects, Function<T, String> nameFn, BinaryOperator<T> mergeFunc) {
        return namedObjects.stream().collect(Collectors.toMap(nameFn, Function.identity(), mergeFunc, LinkedHashMap::new));
    }

    public static <T, NewKey> Map<NewKey, ImmutableList<T>> groupingBy(Collection<T> list, Function<T, NewKey> function) {
        return list.stream().collect(Collectors.groupingBy(function, LinkedHashMap::new, Collectors.mapping(Function.identity(), ImmutableList.toImmutableList())));
    }

    public static <T, NewKey> Map<NewKey, ImmutableList<T>> filterAndGroupingBy(Collection<T> list, Predicate<? super T> predicate, Function<T, NewKey> function) {
        return list.stream().filter(predicate).collect(Collectors.groupingBy(function, LinkedHashMap::new, Collectors.mapping(Function.identity(), ImmutableList.toImmutableList())));
    }

    public static <T, NewKey> Map<NewKey, ImmutableList<T>> groupingBy(Stream<T> stream, Function<T, NewKey> function) {
        return stream.collect(Collectors.groupingBy(function, LinkedHashMap::new, Collectors.mapping(Function.identity(), ImmutableList.toImmutableList())));
    }

    public static <T, NewKey> Map<NewKey, T> groupingByUniqueKey(Collection<T> list, Function<T, NewKey> keyFunction2) {
        return list.stream().collect(Collectors.toMap(keyFunction2, Function.identity(), FpKit.throwingMerger(), LinkedHashMap::new));
    }

    public static <T, NewKey> Map<NewKey, T> groupingByUniqueKey(Stream<T> stream, Function<T, NewKey> keyFunction2) {
        return stream.collect(Collectors.toMap(keyFunction2, Function.identity(), FpKit.throwingMerger(), LinkedHashMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static <T> Map<String, T> getByName(List<T> namedObjects, Function<T, String> nameFn) {
        return FpKit.getByName(namedObjects, nameFn, FpKit.mergeFirst());
    }

    public static <T> BinaryOperator<T> mergeFirst() {
        return (o1, o2) -> o1;
    }

    public static <T> Collection<T> toCollection(Object iterableResult) {
        if (iterableResult instanceof Collection) {
            return (Collection)iterableResult;
        }
        Iterable<T> iterable = FpKit.toIterable(iterableResult);
        Iterator<T> iterator2 = iterable.iterator();
        ArrayList<T> list = new ArrayList<T>();
        while (iterator2.hasNext()) {
            list.add(iterator2.next());
        }
        return list;
    }

    public static <T> List<T> toListOrSingletonList(Object possibleIterable) {
        if (possibleIterable instanceof List) {
            return (List)possibleIterable;
        }
        if (FpKit.isIterable(possibleIterable)) {
            return ImmutableList.copyOf(FpKit.toIterable(possibleIterable));
        }
        return ImmutableList.of(possibleIterable);
    }

    public static boolean isIterable(Object result) {
        return result.getClass().isArray() || result instanceof Iterable || result instanceof Stream || result instanceof Iterator;
    }

    public static <T> Iterable<T> toIterable(Object iterableResult) {
        if (iterableResult instanceof Iterable) {
            return (Iterable)iterableResult;
        }
        if (iterableResult instanceof Stream) {
            return ((Stream)iterableResult)::iterator;
        }
        if (iterableResult instanceof Iterator) {
            return () -> (Iterator)iterableResult;
        }
        if (iterableResult.getClass().isArray()) {
            return () -> new ArrayIterator(iterableResult);
        }
        throw new ClassCastException("not Iterable: " + iterableResult.getClass());
    }

    public static OptionalInt toSize(Object iterableResult) {
        if (iterableResult instanceof Collection) {
            return OptionalInt.of(((Collection)iterableResult).size());
        }
        if (iterableResult.getClass().isArray()) {
            return OptionalInt.of(Array.getLength(iterableResult));
        }
        return OptionalInt.empty();
    }

    public static <T> List<T> concat(List<T> l, T t2) {
        return FpKit.concat(l, Collections.singletonList(t2));
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        ArrayList<T> l = new ArrayList<T>(l1);
        l.addAll(l2);
        l.trimToSize();
        return l;
    }

    public static <T> List<T> valuesToList(Map<?, T> map) {
        return new ArrayList<T>(map.values());
    }

    public static <K, V, U> List<U> mapEntries(Map<K, V> map, BiFunction<K, V, U> function) {
        return map.entrySet().stream().map(entry -> function.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public static <T> List<List<T>> transposeMatrix(List<? extends List<T>> matrix) {
        int rowCount = matrix.size();
        int colCount = matrix.get(0).size();
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                T val = matrix.get(i).get(j);
                if (result.size() <= j) {
                    result.add(j, new ArrayList());
                }
                ((List)result.get(j)).add(i, val);
            }
        }
        return result;
    }

    public static <T> CompletableFuture<List<T>> flatList(CompletableFuture<List<List<T>>> cf) {
        return cf.thenApply(FpKit::flatList);
    }

    public static <T> List<T> flatList(List<List<T>> listLists) {
        return listLists.stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public static <T> Optional<T> findOne(Collection<T> list, Predicate<T> filter) {
        return list.stream().filter(filter).findFirst();
    }

    public static <T> T findOneOrNull(List<T> list, Predicate<T> filter) {
        return FpKit.findOne(list, filter).orElse(null);
    }

    public static <T> int findIndex(List<T> list, Predicate<T> filter) {
        for (int i = 0; i < list.size(); ++i) {
            if (!filter.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> List<T> filterList(Collection<T> list, Predicate<T> filter) {
        return list.stream().filter(filter).collect(Collectors.toList());
    }

    public static <T> Set<T> filterSet(Collection<T> input, Predicate<T> filter) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (T t2 : input) {
            if (!filter.test(t2)) continue;
            result.add(t2);
        }
        return result.build();
    }

    public static <K, V> Function<K, List<V>> newList() {
        return k -> new ArrayList();
    }

    public static <T> Supplier<T> intraThreadMemoize(Supplier<T> delegate) {
        return new IntraThreadMemoizedSupplier<T>(delegate);
    }

    public static <T> Supplier<T> interThreadMemoize(Supplier<T> delegate) {
        return new InterThreadMemoizedSupplier<T>(delegate);
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        if (set1.size() == 1 && set2.contains(set1.iterator().next())) {
            return set1;
        }
        if (set2.size() == 1 && set1.contains(set2.iterator().next())) {
            return set2;
        }
        if (set1.size() < set2.size()) {
            return Sets.intersection(set1, set2);
        }
        return Sets.intersection(set2, set1);
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private final Object array;
        private final int size;
        private int i;

        private ArrayIterator(Object array) {
            this.array = array;
            this.size = Array.getLength(array);
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (T)Array.get(this.array, this.i++);
        }
    }
}

