/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.Config;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdmServer {
    private static final String SESSION = "/session";
    private static final String GET = "GET";
    private static final String DELETE = "DELETE";
    private static final String POST = "POST";
    private static final String SESSIONID = "\"sessionId\":";
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, URL> sessionMap = new ConcurrentHashMap<String, URL>();
    private Map<String, WebDriverManager> wdmMap = new ConcurrentHashMap<String, WebDriverManager>();
    private Config config = new Config();
    private String path;

    public WdmServer(int port) {
        String serverPath = this.config.getServerPath();
        this.path = serverPath.endsWith("/") ? serverPath.substring(0, serverPath.length() - 1) : serverPath;
        Javalin app = Javalin.create().start(port);
        Handler handler = this::handleRequest;
        app.get(String.valueOf(this.path) + "/chromedriver", handler);
        app.get(String.valueOf(this.path) + "/firefoxdriver", handler);
        app.get(String.valueOf(this.path) + "/edgedriver", handler);
        app.get(String.valueOf(this.path) + "/iedriver", handler);
        app.get(String.valueOf(this.path) + "/operadriver", handler);
        app.post(String.valueOf(this.path) + SESSION, handler);
        app.post(String.valueOf(this.path) + SESSION + "/*", handler);
        app.get(String.valueOf(this.path) + SESSION + "/*", handler);
        app.delete(String.valueOf(this.path) + SESSION + "/*", handler);
        String localHostAddress = this.getLocalHostAddress();
        log.info("WebDriverManager Server listening on http://{}:{}{}", localHostAddress, port, this.path);
    }

    private String getLocalHostAddress() {
        String localHostAddress;
        try {
            localHostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            localHostAddress = InetAddress.getLoopbackAddress().getHostAddress();
        }
        return localHostAddress;
    }

    private void handleRequest(Context ctx) throws IOException {
        String requestMethod = ctx.method();
        String requestPath = ctx.path();
        log.info("Request: {} {}", (Object)requestMethod, (Object)requestPath);
        Optional<WebDriverManager> driverManager = this.createDriverManager(requestPath);
        if (driverManager.isPresent()) {
            this.resolveDriver(ctx, driverManager.get());
        } else {
            this.seleniumServer(ctx);
        }
    }

    private void seleniumServer(Context ctx) throws IOException {
        URL seleniumServerUrl;
        String requestMethod = ctx.method();
        String requestPath = ctx.path().replace(this.path, "");
        String requestBody = ctx.body();
        log.debug("Body: {} ", (Object)requestBody);
        Session session = new Gson().fromJson(requestBody, Session.class);
        boolean isSessionCreate = session != null && session.getCapabilities() != null && session.getCapabilities().getFirstMatch() != null;
        WebDriverManager wdm = null;
        if (isSessionCreate) {
            String browserName = session.getCapabilities().getFirstMatch().get(0).getBrowserName();
            String version = session.getCapabilities().getFirstMatch().get(0).getVersion();
            wdm = WebDriverManager.getInstance(browserName).browserInDocker().browserVersion(version);
            wdm.create();
            seleniumServerUrl = wdm.getDockerSeleniumServerUrl();
        } else {
            String sessionIdFromPath = this.getSessionIdFromPath(requestPath);
            seleniumServerUrl = this.sessionMap.get(sessionIdFromPath);
        }
        String response = this.exchange(String.valueOf(seleniumServerUrl.toString().replaceAll("/\\z", "")) + requestPath, requestMethod, requestBody, this.config.getServerTimeoutSec());
        log.info("Response: {}", (Object)response);
        ctx.contentType("application/json");
        ctx.result(response);
        if (isSessionCreate) {
            String sessionId = this.getSessionIdFromResponse(response);
            this.sessionMap.put(sessionId, seleniumServerUrl);
            this.wdmMap.put(sessionId, wdm);
        }
        if (requestMethod.equalsIgnoreCase(DELETE) && requestPath.startsWith("/session/")) {
            String sessionIdFromPath = this.getSessionIdFromPath(requestPath);
            this.wdmMap.get(sessionIdFromPath).quit();
            this.wdmMap.remove(sessionIdFromPath);
            this.sessionMap.remove(sessionIdFromPath);
        }
    }

    private String getSessionIdFromResponse(String response) {
        response = response.substring(response.indexOf(SESSIONID) + SESSIONID.length() + 1);
        response = response.substring(0, response.indexOf("\""));
        return response;
    }

    private String getSessionIdFromPath(String path) {
        path = path.substring(path.indexOf("/") + 1);
        int i = (path = path.substring(path.indexOf("/") + 1)).indexOf("/");
        if (i != -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    private Optional<WebDriverManager> createDriverManager(String requestPath) {
        Optional<WebDriverManager> out;
        switch (requestPath.replace(this.path, "").substring(1)) {
            case "chromedriver": {
                out = Optional.of(WebDriverManager.chromedriver());
                break;
            }
            case "firefoxdriver": {
                out = Optional.of(WebDriverManager.firefoxdriver());
                break;
            }
            case "edgedriver": {
                out = Optional.of(WebDriverManager.edgedriver());
                break;
            }
            case "iedriver": {
                out = Optional.of(WebDriverManager.iedriver());
                break;
            }
            case "operadriver": {
                out = Optional.of(WebDriverManager.operadriver());
                break;
            }
            default: {
                out = Optional.empty();
            }
        }
        return out;
    }

    private synchronized void resolveDriver(Context ctx, WebDriverManager driverManager) throws IOException {
        TreeMap<String, List<String>> queryParamMap = new TreeMap<String, List<String>>(ctx.queryParamMap());
        if (!queryParamMap.isEmpty()) {
            log.info("Server query string for configuration {}", (Object)queryParamMap);
            for (Map.Entry entry : queryParamMap.entrySet()) {
                String configKey = "wdm." + (String)entry.getKey();
                String configValue = (String)((List)entry.getValue()).get(0);
                log.trace("\t{} = {}", (Object)configKey, (Object)configValue);
                System.setProperty(configKey, configValue);
            }
        }
        driverManager.config().setAvoidExport(true);
        driverManager.config().setAvoidBrowserDetection(true);
        driverManager.setup();
        File driver = new File(driverManager.getDownloadedDriverPath());
        String driverVersion = driverManager.getDownloadedDriverVersion();
        String driverName = driver.getName();
        String driverLength = String.valueOf(driver.length());
        ctx.res.setHeader("Content-Disposition", "attachment; filename=\"" + driverName + "\"");
        ctx.result(FileUtils.openInputStream(driver));
        log.info("Server response: {} {} ({} bytes)", driverName, driverVersion, driverLength);
        for (String key : queryParamMap.keySet()) {
            System.clearProperty("wdm." + key);
        }
    }

    /*
     * Exception decompiling
     */
    public String exchange(String url, String method, String json, int timeoutSec) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[0, 1, 9] lbl44 : CaseStatement: default:\u000a, @NONE, blocks:[0, 1, 9] lbl44 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class Capabilities {
        List<FirstMatch> firstMatch;

        Capabilities() {
        }

        public List<FirstMatch> getFirstMatch() {
            return this.firstMatch;
        }
    }

    static class FirstMatch {
        String browserName;
        String version;

        FirstMatch() {
        }

        public String getBrowserName() {
            return this.browserName;
        }

        public String getVersion() {
            return this.version;
        }
    }

    static class Session {
        Capabilities capabilities;

        Session() {
        }

        public Capabilities getCapabilities() {
            return this.capabilities;
        }
    }
}

