/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.config;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Architecture {
    DEFAULT(Collections.emptyList()),
    X32(Arrays.asList("i686", "x86")),
    X64(Collections.emptyList()),
    ARM64(Arrays.asList("aarch64", "m1", "arm64"));

    List<String> archLabels;

    private Architecture(List<String> archLabels) {
        this.archLabels = archLabels;
    }

    public Stream<String> archLabelsStream() {
        return this.archLabels.stream();
    }

    public boolean matchString(String strMatch) {
        return this.archLabelsStream().anyMatch(strMatch::contains);
    }

    public boolean matchUrl(URL url2) {
        return this.archLabelsStream().anyMatch(x -> url2.getFile().contains((CharSequence)x)) || url2.getFile().contains(this.toString().toLowerCase(Locale.ROOT));
    }

    public <T> List<T> filterArm64(List<T> input) {
        if (this != ARM64) {
            return input.stream().filter(x -> !x.toString().toLowerCase(Locale.ROOT).contains(ARM64.toString().toLowerCase(Locale.ROOT)) && !ARM64.matchString(x.toString())).collect(Collectors.toList());
        }
        return input;
    }

    public String toString() {
        return this.name().contains("X") ? this.name().replace("X", "") : this.name();
    }
}

