/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.config;

import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.ConfigKey;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String HOME = "~";
    static final String PWD = ".";
    static final String SCREEN_RESOLUTION_SEPARATOR = "x";
    ConfigKey<String> properties = new ConfigKey<String>("wdm.properties", String.class, "webdrivermanager.properties");
    ConfigKey<String> cachePath = new ConfigKey<String>("wdm.cachePath", String.class);
    ConfigKey<String> resolutionCachePath = new ConfigKey<String>("wdm.resolutionCachePath", String.class);
    ConfigKey<Boolean> forceDownload = new ConfigKey<Boolean>("wdm.forceDownload", Boolean.class);
    ConfigKey<Boolean> useMirror = new ConfigKey<Boolean>("wdm.useMirror", Boolean.class);
    ConfigKey<Boolean> useBetaVersions = new ConfigKey<Boolean>("wdm.useBetaVersions", Boolean.class);
    ConfigKey<Boolean> avoidExport = new ConfigKey<Boolean>("wdm.avoidExport", Boolean.class);
    ConfigKey<Boolean> avoidOutputTree = new ConfigKey<Boolean>("wdm.avoidOutputTree", Boolean.class);
    ConfigKey<Boolean> avoidBrowserDetection = new ConfigKey<Boolean>("wdm.avoidBrowserDetection", Boolean.class);
    ConfigKey<Boolean> avoidFallback = new ConfigKey<Boolean>("wdm.avoidFallback", Boolean.class);
    ConfigKey<Boolean> avoidResolutionCache = new ConfigKey<Boolean>("wdm.avoidResolutionCache", Boolean.class);
    ConfigKey<Boolean> avoidTmpFolder = new ConfigKey<Boolean>("wdm.avoidTmpFolder", Boolean.class);
    ConfigKey<Boolean> avoidShutdownHook = new ConfigKey<Boolean>("wdm.avoidShutdownHook", Boolean.class);
    ConfigKey<Boolean> avoidExternalConnections = new ConfigKey<Boolean>("wdm.avoidExternalConnections", Boolean.class);
    ConfigKey<Integer> timeout = new ConfigKey<Integer>("wdm.timeout", Integer.class);
    ConfigKey<Boolean> commandsPropertiesOnlineFirst = new ConfigKey<Boolean>("wdm.commandsPropertiesOnlineFirst", Boolean.class);
    ConfigKey<URL> commandsPropertiesUrl = new ConfigKey<URL>("wdm.commandsPropertiesUrl", URL.class);
    ConfigKey<Boolean> clearResolutionCache = new ConfigKey<Boolean>("wdm.clearResolutionCache", Boolean.class);
    ConfigKey<Boolean> clearDriverCache = new ConfigKey<Boolean>("wdm.clearDriverCache", Boolean.class);
    ConfigKey<String> architecture = new ConfigKey<String>("wdm.architecture", String.class, this.defaultArchitecture());
    ConfigKey<String> os = new ConfigKey<String>("wdm.os", String.class, this.defaultOsName());
    ConfigKey<String> proxy = new ConfigKey<String>("wdm.proxy", String.class);
    ConfigKey<String> proxyUser = new ConfigKey<String>("wdm.proxyUser", String.class);
    ConfigKey<String> proxyPass = new ConfigKey<String>("wdm.proxyPass", String.class);
    ConfigKey<String> ignoreVersions = new ConfigKey<String>("wdm.ignoreVersions", String.class);
    ConfigKey<String> gitHubToken = new ConfigKey<String>("wdm.gitHubToken", String.class);
    ConfigKey<String> defaultBrowser = new ConfigKey<String>("wdm.defaultBrowser", String.class);
    ConfigKey<String> chromeDriverVersion = new ConfigKey<String>("wdm.chromeDriverVersion", String.class);
    ConfigKey<String> chromeVersion = new ConfigKey<String>("wdm.chromeVersion", String.class);
    ConfigKey<String> chromeDriverExport = new ConfigKey<String>("wdm.chromeDriverExport", String.class);
    ConfigKey<URL> chromeDriverUrl = new ConfigKey<URL>("wdm.chromeDriverUrl", URL.class);
    ConfigKey<URL> chromeDriverMirrorUrl = new ConfigKey<URL>("wdm.chromeDriverMirrorUrl", URL.class);
    ConfigKey<String> chromeDownloadUrlPattern = new ConfigKey<String>("wdm.chromeDownloadUrlPattern", String.class);
    ConfigKey<String> chromeGoodVersionsUrl = new ConfigKey<String>("wdm.chromeGoodVersionsUrl", String.class);
    ConfigKey<String> chromeLastGoodVersionsUrl = new ConfigKey<String>("wdm.chromeLastGoodVersionsUrl", String.class);
    ConfigKey<String> edgeDriverVersion = new ConfigKey<String>("wdm.edgeDriverVersion", String.class);
    ConfigKey<String> edgeVersion = new ConfigKey<String>("wdm.edgeVersion", String.class);
    ConfigKey<String> edgeDriverExport = new ConfigKey<String>("wdm.edgeDriverExport", String.class);
    ConfigKey<URL> edgeDriverUrl = new ConfigKey<URL>("wdm.edgeDriverUrl", URL.class);
    ConfigKey<String> edgeDownloadUrlPattern = new ConfigKey<String>("wdm.edgeDownloadUrlPattern", String.class);
    ConfigKey<String> geckoDriverVersion = new ConfigKey<String>("wdm.geckoDriverVersion", String.class);
    ConfigKey<String> firefoxVersion = new ConfigKey<String>("wdm.firefoxVersion", String.class);
    ConfigKey<String> firefoxDriverExport = new ConfigKey<String>("wdm.geckoDriverExport", String.class);
    ConfigKey<URL> firefoxDriverUrl = new ConfigKey<URL>("wdm.geckoDriverUrl", URL.class);
    ConfigKey<URL> firefoxDriverMirrorUrl = new ConfigKey<URL>("wdm.geckoDriverMirrorUrl", URL.class);
    ConfigKey<URL> firefoxDriverGoodVersionsUrl = new ConfigKey<URL>("wdm.geckoDriverGoodVersionsUrl", URL.class);
    ConfigKey<String> iExplorerDriverVersion = new ConfigKey<String>("wdm.iExplorerDriverVersion", String.class);
    ConfigKey<String> iExplorerDriverExport = new ConfigKey<String>("wdm.iExplorerDriverExport", String.class);
    ConfigKey<URL> iExplorerDriverUrl = new ConfigKey<URL>("wdm.iExplorerDriverUrl", URL.class);
    ConfigKey<String> operaDriverVersion = new ConfigKey<String>("wdm.operaDriverVersion", String.class);
    ConfigKey<String> operaVersion = new ConfigKey<String>("wdm.operaVersion", String.class);
    ConfigKey<String> operaDriverExport = new ConfigKey<String>("wdm.operaDriverExport", String.class);
    ConfigKey<URL> operaDriverUrl = new ConfigKey<URL>("wdm.operaDriverUrl", URL.class);
    ConfigKey<URL> operaDriverMirrorUrl = new ConfigKey<URL>("wdm.operaDriverMirrorUrl", URL.class);
    ConfigKey<String> chromiumDriverVersion = new ConfigKey<String>("wdm.chromiumDriverVersion", String.class);
    ConfigKey<String> chromiumVersion = new ConfigKey<String>("wdm.chromiumVersion", String.class);
    ConfigKey<String> chromiumDriverSnapPath = new ConfigKey<String>("wdm.chromiumDriverSnapPath", String.class);
    ConfigKey<Boolean> useChromiumDriverSnap = new ConfigKey<Boolean>("wdm.useChromiumDriverSnap", Boolean.class);
    ConfigKey<String> safariVersion = new ConfigKey<String>("wdm.safariVersion", String.class);
    ConfigKey<Integer> ttl = new ConfigKey<Integer>("wdm.ttl", Integer.class);
    ConfigKey<Integer> ttlForBrowsers = new ConfigKey<Integer>("wdm.ttlForBrowsers", Integer.class);
    ConfigKey<String> resolutionCache = new ConfigKey<String>("wdm.resolutionCache", String.class);
    ConfigKey<String> browserVersionDetectionRegex = new ConfigKey<String>("wdm.browserVersionDetectionRegex", String.class);
    ConfigKey<String> browserVersionDetectionCommand = new ConfigKey<String>("wdm.browserVersionDetectionCommand", String.class);
    ConfigKey<Integer> serverPort = new ConfigKey<Integer>("wdm.serverPort", Integer.class);
    ConfigKey<String> serverPath = new ConfigKey<String>("wdm.serverPath", String.class);
    ConfigKey<Integer> serverTimeoutSec = new ConfigKey<Integer>("wdm.serverTimeoutSec", Integer.class);
    ConfigKey<String> dockerDaemonUrl = new ConfigKey<String>("wdm.dockerDaemonUrl", String.class);
    ConfigKey<String> dockerHubUrl = new ConfigKey<String>("wdm.dockerHubUrl", String.class);
    ConfigKey<String> dockerNetwork = new ConfigKey<String>("wdm.dockerNetwork", String.class);
    ConfigKey<String> dockerTimezone = new ConfigKey<String>("wdm.dockerTimezone", String.class);
    ConfigKey<String> dockerLang = new ConfigKey<String>("wdm.dockerLang", String.class);
    ConfigKey<String> dockerShmSize = new ConfigKey<String>("wdm.dockerShmSize", String.class);
    ConfigKey<String> dockerTmpfsSize = new ConfigKey<String>("wdm.dockerTmpfsSize", String.class);
    ConfigKey<String> dockerTmpfsMount = new ConfigKey<String>("wdm.dockerTmpfsMount", String.class);
    ConfigKey<Integer> dockerStopTimeoutSec = new ConfigKey<Integer>("wdm.dockerStopTimeoutSec", Integer.class);
    ConfigKey<Boolean> dockerEnableVnc = new ConfigKey<Boolean>("wdm.dockerEnableVnc", Boolean.class);
    ConfigKey<Boolean> dockerViewOnly = new ConfigKey<Boolean>("wdm.dockerViewOnly", Boolean.class);
    ConfigKey<Boolean> dockerEnableRecording = new ConfigKey<Boolean>("wdm.dockerEnableRecording", Boolean.class);
    ConfigKey<String> dockerScreenResolution = new ConfigKey<String>("wdm.dockerScreenResolution", String.class);
    ConfigKey<String> dockerVncPassword = new ConfigKey<String>("wdm.dockerVncPassword", String.class);
    ConfigKey<Integer> dockerBrowserPort = new ConfigKey<Integer>("wdm.dockerBrowserPort", Integer.class);
    ConfigKey<Integer> dockerVncPort = new ConfigKey<Integer>("wdm.dockerVncPort", Integer.class);
    ConfigKey<Integer> dockerNoVncPort = new ConfigKey<Integer>("wdm.dockerNoVncPort", Integer.class);
    ConfigKey<Integer> dockerRecordingFrameRate = new ConfigKey<Integer>("wdm.dockerRecordingFrameRate", Integer.class);
    ConfigKey<Path> dockerRecordingOutput = new ConfigKey<Path>("wdm.dockerRecordingOutput", Path.class);
    ConfigKey<String> dockerRecordingPrefix = new ConfigKey<String>("wdm.dockerRecordingPrefix", String.class);
    ConfigKey<String> dockerBrowserSelenoidImageFormat = new ConfigKey<String>("wdm.dockerBrowserSelenoidImageFormat", String.class);
    ConfigKey<String> dockerBrowserTwilioImageFormat = new ConfigKey<String>("wdm.dockerBrowserTwilioImageFormat", String.class);
    ConfigKey<String> dockerBrowserAerokubeImageFormat = new ConfigKey<String>("wdm.dockerBrowserAerokubeImageFormat", String.class);
    ConfigKey<String> dockerBrowserMobileImageFormat = new ConfigKey<String>("wdm.dockerBrowserMobileImageFormat", String.class);
    ConfigKey<String> dockerRecordingImage = new ConfigKey<String>("wdm.dockerRecordingImage", String.class);
    ConfigKey<String> dockerNoVncImage = new ConfigKey<String>("wdm.dockerNoVncImage", String.class);
    ConfigKey<String> dockerCustomImage = new ConfigKey<String>("wdm.dockerCustomImage", String.class);
    ConfigKey<String> dockerVolumes = new ConfigKey<String>("wdm.dockerVolumes", String.class);
    ConfigKey<String> dockerExtraHosts = new ConfigKey<String>("wdm.dockerExtraHosts", String.class);
    ConfigKey<String> dockerEnvVariables = new ConfigKey<String>("wdm.dockerEnvVariables", String.class);
    ConfigKey<String> dockerDefaultArgs = new ConfigKey<String>("wdm.dockerDefaultArgs", String.class);
    ConfigKey<Boolean> dockerLocalFallback = new ConfigKey<Boolean>("wdm.dockerLocalFallback", Boolean.class);
    ConfigKey<String> dockerPrivateEndpoint = new ConfigKey<String>("wdm.dockerPrivateEndpoint", String.class);
    ConfigKey<Boolean> dockerAvoidPulling = new ConfigKey<Boolean>("wdm.dockerAvoidPulling", Boolean.class);
    ConfigKey<String> remoteAddress = new ConfigKey<String>("wdm.remoteAddress", String.class);
    ConfigKey<String> browserWatcherVersion = new ConfigKey<String>("wdm.browserWatcherVersion", String.class);
    ConfigKey<Boolean> tracing = new ConfigKey<Boolean>("wdm.tracing", Boolean.class);

    private <T> T resolve(ConfigKey<T> configKey) {
        String name = configKey.getName();
        T tValue = configKey.getValue();
        Class<T> type = configKey.getType();
        return this.resolver(name, tValue, type);
    }

    private <T> T resolver(String name, T tValue, Class<T> type) {
        String strValue = System.getenv(name.toUpperCase(Locale.ROOT).replace(PWD, "_"));
        if (strValue == null) {
            strValue = System.getProperty(name);
        }
        if (strValue == null && tValue != null) {
            return tValue;
        }
        if (strValue == null) {
            strValue = this.getProperty(name);
        }
        return this.parse(type, strValue);
    }

    private <T> T parse(Class<T> type, String strValue) {
        Object output = null;
        if (type.equals(String.class)) {
            output = strValue;
        } else if (type.equals(Integer.class)) {
            output = Integer.valueOf(strValue);
        } else if (type.equals(Boolean.class)) {
            output = Boolean.valueOf(strValue);
        } else if (type.equals(Path.class)) {
            output = Paths.get(strValue, new String[0]);
        } else if (type.equals(URL.class)) {
            try {
                output = new URL(strValue);
            }
            catch (Exception e) {
                throw new WebDriverManagerException(e);
            }
        } else {
            throw new WebDriverManagerException("Type " + type.getTypeName() + " cannot be parsed");
        }
        return (T)output;
    }

    private String getProperty(String key) {
        String value = null;
        String propertiesValue = "/" + this.getProperties();
        String defaultProperties = "/webdrivermanager.properties";
        try {
            value = this.getPropertyFrom(propertiesValue, key);
            if (value == null) {
                value = this.getPropertyFrom(defaultProperties, key);
            }
        }
        finally {
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    private String getPropertyFrom(String properties, String key) {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream inputStream = Config.class.getResourceAsStream(properties);){
                props.load(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.trace("Property {} not found in {}", (Object)key, (Object)properties);
        }
        return props.getProperty(key);
    }

    public void reset() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() == ConfigKey.class) {
                try {
                    ((ConfigKey)field.get(this)).reset();
                }
                catch (Exception e) {
                    this.log.warn("Exception resetting {}", (Object)field);
                }
            }
            ++n2;
        }
    }

    private String defaultOsName() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (SystemUtils.IS_OS_WINDOWS) {
            osName = OperatingSystem.WIN.name();
        } else if (SystemUtils.IS_OS_LINUX) {
            osName = OperatingSystem.LINUX.name();
        } else if (SystemUtils.IS_OS_MAC) {
            osName = OperatingSystem.MAC.name();
        }
        return osName;
    }

    private String defaultArchitecture() {
        if (Architecture.ARM64.matchString(System.getProperty("os.arch"))) {
            return "ARM64";
        }
        return "X" + System.getProperty("sun.arch.data.model");
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public boolean isExecutable(File file) {
        return this.resolve(this.os).equalsIgnoreCase("win") ? file.getName().toLowerCase(Locale.ROOT).endsWith(".exe") : file.canExecute();
    }

    public String getProperties() {
        return this.resolve(this.properties);
    }

    public Config setProperties(String properties) {
        this.properties.setValue(properties);
        return this;
    }

    private File getFileFromPath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public File getCacheFolder() {
        return this.getFileFromPath(this.getCachePath());
    }

    public String getCachePath() {
        return this.resolvePath(this.resolve(this.cachePath));
    }

    private String resolvePath(String path) {
        if (path != null) {
            if (path.startsWith("~/")) {
                path = Paths.get(System.getProperty("user.home"), path.substring(1)).toString();
            } else if (path.equals(PWD)) {
                path = Paths.get("", new String[0]).toAbsolutePath().toString();
            }
        }
        return path;
    }

    public Config setCachePath(String value) {
        this.cachePath.setValue(value);
        return this;
    }

    public File getResolutionCachePath() {
        String resCachePath = this.resolvePath(this.resolve(this.resolutionCachePath));
        if (Config.isNullOrEmpty(resCachePath)) {
            resCachePath = this.getCachePath();
        }
        return this.getFileFromPath(resCachePath);
    }

    public Config setResolutionCachePath(String value) {
        this.resolutionCachePath.setValue(value);
        return this;
    }

    public boolean isForceDownload() {
        return this.resolve(this.forceDownload);
    }

    public Config setForceDownload(boolean value) {
        this.forceDownload.setValue(value);
        return this;
    }

    public boolean isUseMirror() {
        return this.resolve(this.useMirror);
    }

    public Config setUseMirror(boolean value) {
        this.useMirror.setValue(value);
        return this;
    }

    public boolean isUseBetaVersions() {
        return this.resolve(this.useBetaVersions);
    }

    public Config setUseBetaVersions(boolean value) {
        this.useBetaVersions.setValue(value);
        return this;
    }

    public boolean isAvoidExport() {
        return this.resolve(this.avoidExport);
    }

    public Config setAvoidExport(boolean value) {
        this.avoidExport.setValue(value);
        return this;
    }

    public boolean isAvoidOutputTree() {
        return this.resolve(this.avoidOutputTree);
    }

    public Config setAvoidOutputTree(boolean value) {
        this.avoidOutputTree.setValue(value);
        return this;
    }

    public boolean isAvoidBrowserDetection() {
        return this.resolve(this.avoidBrowserDetection);
    }

    public Config setAvoidBrowserDetection(boolean value) {
        this.avoidBrowserDetection.setValue(value);
        return this;
    }

    public boolean isAvoidFallback() {
        return this.resolve(this.avoidFallback);
    }

    public Config setAvoidFallback(boolean value) {
        this.avoidFallback.setValue(value);
        return this;
    }

    public boolean isAvoidResolutionCache() {
        return this.resolve(this.avoidResolutionCache);
    }

    public Config setAvoidResolutionCache(boolean value) {
        this.avoidResolutionCache.setValue(value);
        return this;
    }

    public boolean isAvoidTmpFolder() {
        return this.resolve(this.avoidTmpFolder);
    }

    public Config setAvoidTmpFolder(boolean value) {
        this.avoidTmpFolder.setValue(value);
        return this;
    }

    public boolean isAvoidShutdownHook() {
        return this.resolve(this.avoidShutdownHook);
    }

    public Config setAvoidShutdownHook(boolean value) {
        this.avoidShutdownHook.setValue(value);
        return this;
    }

    public boolean isAvoidExternalConnections() {
        return this.resolve(this.avoidExternalConnections);
    }

    public Config setAvoidExternalConnections(boolean value) {
        this.avoidExternalConnections.setValue(value);
        return this;
    }

    public int getTimeout() {
        return this.resolve(this.timeout);
    }

    public Config setTimeout(int value) {
        this.timeout.setValue(value);
        return this;
    }

    public boolean isCommandsPropertiesOnlineFirst() {
        return this.resolve(this.commandsPropertiesOnlineFirst);
    }

    public Config setCommandsPropertiesOnlineFirst(boolean value) {
        this.commandsPropertiesOnlineFirst.setValue(value);
        return this;
    }

    public URL getCommandsPropertiesUrl() {
        return this.resolve(this.commandsPropertiesUrl);
    }

    public Config setCommandsPropertiesUrl(URL value) {
        this.commandsPropertiesUrl.setValue(value);
        return this;
    }

    public boolean isClearResolutionCache() {
        return this.resolve(this.clearResolutionCache);
    }

    public Config setClearResolutionCache(Boolean value) {
        this.clearResolutionCache.setValue(value);
        return this;
    }

    public boolean isClearDriverCache() {
        return this.resolve(this.clearDriverCache);
    }

    public Config setClearDriverCache(Boolean value) {
        this.clearDriverCache.setValue(value);
        return this;
    }

    public Architecture getArchitecture() {
        String architectureString = this.resolve(this.architecture);
        if ("32".equals(architectureString)) {
            return Architecture.X32;
        }
        if ("64".equals(architectureString)) {
            return Architecture.X64;
        }
        return Architecture.valueOf(architectureString.toUpperCase(Locale.ROOT));
    }

    public Config setArchitecture(Architecture value) {
        this.architecture.setValue(value.name());
        return this;
    }

    public String getOs() {
        return this.resolve(this.os);
    }

    public OperatingSystem getOperatingSystem() {
        return OperatingSystem.valueOf(this.getOs());
    }

    public Config setOs(String value) {
        this.os.setValue(value);
        return this;
    }

    public String getProxy() {
        return this.resolve(this.proxy);
    }

    public Config setProxy(String value) {
        this.proxy.setValue(value);
        return this;
    }

    public String getProxyUser() {
        return this.resolve(this.proxyUser);
    }

    public Config setProxyUser(String value) {
        this.proxyUser.setValue(value);
        return this;
    }

    public String getProxyPass() {
        return this.resolve(this.proxyPass);
    }

    public Config setProxyPass(String value) {
        this.proxyPass.setValue(value);
        return this;
    }

    public List<String> getIgnoreVersions() {
        String ignored = this.resolve(this.ignoreVersions);
        String[] out = new String[]{};
        if (!Config.isNullOrEmpty(ignored)) {
            out = ignored.split(",");
        }
        return Arrays.asList(out);
    }

    public Config setIgnoreVersions(String ... value) {
        this.ignoreVersions.setValue(String.join((CharSequence)",", value));
        return this;
    }

    public String getGitHubToken() {
        return this.resolve(this.gitHubToken);
    }

    public Config setGitHubToken(String value) {
        this.gitHubToken.setValue(value);
        return this;
    }

    public String getDefaultBrowser() {
        return this.resolve(this.defaultBrowser);
    }

    public Config setDefaultBrowser(String value) {
        this.defaultBrowser.setValue(value);
        return this;
    }

    public int getTtl() {
        return this.resolve(this.ttl);
    }

    public Config setTtl(int value) {
        this.ttl.setValue(value);
        return this;
    }

    public int getTtlForBrowsers() {
        return this.resolve(this.ttlForBrowsers);
    }

    public Config setTtlForBrowsers(int value) {
        this.ttlForBrowsers.setValue(value);
        return this;
    }

    public String getResolutionCache() {
        return this.resolve(this.resolutionCache);
    }

    public Config setResolutionCache(String value) {
        this.resolutionCache.setValue(value);
        return this;
    }

    public String getBrowserVersionDetectionRegex() {
        return this.resolve(this.browserVersionDetectionRegex);
    }

    public Config setBrowserVersionDetectionRegex(String value) {
        this.browserVersionDetectionRegex.setValue(value);
        return this;
    }

    public String getChromeDriverVersion() {
        return this.resolve(this.chromeDriverVersion);
    }

    public Config setChromeDriverVersion(String value) {
        this.chromeDriverVersion.setValue(value);
        return this;
    }

    public String getChromeVersion() {
        return this.resolve(this.chromeVersion);
    }

    public Config setChromeVersion(String value) {
        this.chromeVersion.setValue(value);
        return this;
    }

    public String getChromeDriverExport() {
        return this.resolve(this.chromeDriverExport);
    }

    public Config setChromeDriverExport(String value) {
        this.chromeDriverExport.setValue(value);
        return this;
    }

    public URL getChromeDriverUrl() {
        return this.resolve(this.chromeDriverUrl);
    }

    public Config setChromeDriverUrl(URL value) {
        this.chromeDriverUrl.setValue(value);
        return this;
    }

    public URL getChromeDriverMirrorUrl() {
        return this.resolve(this.chromeDriverMirrorUrl);
    }

    public Config setChromeDriverMirrorUrl(URL value) {
        this.chromeDriverMirrorUrl.setValue(value);
        return this;
    }

    public String getChromeDownloadUrlPattern() {
        return this.resolve(this.chromeDownloadUrlPattern);
    }

    public Config setChromeDownloadUrlPattern(String value) {
        this.chromeDownloadUrlPattern.setValue(value);
        return this;
    }

    public String getChromeGoodVersionsUrl() {
        return this.resolve(this.chromeGoodVersionsUrl);
    }

    public Config setChromeGoodVersionsUrl(String value) {
        this.chromeGoodVersionsUrl.setValue(value);
        return this;
    }

    public String getChromeLastGoodVersionsUrl() {
        return this.resolve(this.chromeLastGoodVersionsUrl);
    }

    public Config setChromeLastGoodVersionsUrl(String value) {
        this.chromeLastGoodVersionsUrl.setValue(value);
        return this;
    }

    public String getEdgeDriverVersion() {
        return this.resolve(this.edgeDriverVersion);
    }

    public Config setEdgeDriverVersion(String value) {
        this.edgeDriverVersion.setValue(value);
        return this;
    }

    public String getEdgeVersion() {
        return this.resolve(this.edgeVersion);
    }

    public Config setEdgeVersion(String value) {
        this.edgeVersion.setValue(value);
        return this;
    }

    public String getEdgeDriverExport() {
        return this.resolve(this.edgeDriverExport);
    }

    public Config setEdgeDriverExport(String value) {
        this.edgeDriverExport.setValue(value);
        return this;
    }

    public URL getEdgeDriverUrl() {
        return this.resolve(this.edgeDriverUrl);
    }

    public Config setEdgeDriverUrl(URL value) {
        this.edgeDriverUrl.setValue(value);
        return this;
    }

    public String getEdgeDownloadUrlPattern() {
        return this.resolve(this.edgeDownloadUrlPattern);
    }

    public Config setEdgeDownloadUrlPattern(String value) {
        this.edgeDownloadUrlPattern.setValue(value);
        return this;
    }

    public String getGeckoDriverVersion() {
        return this.resolve(this.geckoDriverVersion);
    }

    public Config setGeckoDriverVersion(String value) {
        this.geckoDriverVersion.setValue(value);
        return this;
    }

    public String getFirefoxVersion() {
        return this.resolve(this.firefoxVersion);
    }

    public Config setFirefoxVersion(String value) {
        this.firefoxVersion.setValue(value);
        return this;
    }

    public String getFirefoxDriverExport() {
        return this.resolve(this.firefoxDriverExport);
    }

    public Config setFirefoxDriverExport(String value) {
        this.firefoxDriverExport.setValue(value);
        return this;
    }

    public URL getFirefoxDriverUrl() {
        return this.resolve(this.firefoxDriverUrl);
    }

    public Config setFirefoxDriverUrl(URL value) {
        this.firefoxDriverUrl.setValue(value);
        return this;
    }

    public URL getFirefoxDriverMirrorUrl() {
        return this.resolve(this.firefoxDriverMirrorUrl);
    }

    public Config setFirefoxDriverMirrorUrl(URL value) {
        this.firefoxDriverMirrorUrl.setValue(value);
        return this;
    }

    public URL getFirefoxDriverGoodVersionsUrl() {
        return this.resolve(this.firefoxDriverGoodVersionsUrl);
    }

    public Config setFirefoxDriverGoodVersionsUrl(URL value) {
        this.firefoxDriverGoodVersionsUrl.setValue(value);
        return this;
    }

    public String getIExplorerDriverVersion() {
        return this.resolve(this.iExplorerDriverVersion);
    }

    public Config setIExplorerDriverVersion(String value) {
        this.iExplorerDriverVersion.setValue(value);
        return this;
    }

    public String getIExplorerDriverExport() {
        return this.resolve(this.iExplorerDriverExport);
    }

    public Config setIExplorerDriverExport(String value) {
        this.iExplorerDriverExport.setValue(value);
        return this;
    }

    public URL getIExplorerDriverUrl() {
        return this.resolve(this.iExplorerDriverUrl);
    }

    public Config setIExplorerDriverUrl(URL value) {
        this.iExplorerDriverUrl.setValue(value);
        return this;
    }

    public String getOperaDriverVersion() {
        return this.resolve(this.operaDriverVersion);
    }

    public Config setOperaDriverVersion(String value) {
        this.operaDriverVersion.setValue(value);
        return this;
    }

    public String getOperaVersion() {
        return this.resolve(this.operaVersion);
    }

    public Config setOperaVersion(String value) {
        this.operaVersion.setValue(value);
        return this;
    }

    public String getOperaDriverExport() {
        return this.resolve(this.operaDriverExport);
    }

    public Config setOperaDriverExport(String value) {
        this.operaDriverExport.setValue(value);
        return this;
    }

    public URL getOperaDriverUrl() {
        return this.resolve(this.operaDriverUrl);
    }

    public Config setOperaDriverUrl(URL value) {
        this.operaDriverUrl.setValue(value);
        return this;
    }

    public URL getOperaDriverMirrorUrl() {
        return this.resolve(this.operaDriverMirrorUrl);
    }

    public Config setOperaDriverMirrorUrl(URL value) {
        this.operaDriverMirrorUrl.setValue(value);
        return this;
    }

    public String getChromiumDriverVersion() {
        return this.resolve(this.chromiumDriverVersion);
    }

    public Config setChromiumDriverVersion(String value) {
        this.chromiumDriverVersion.setValue(value);
        return this;
    }

    public String getSafariVersion() {
        return this.resolve(this.safariVersion);
    }

    public Config setSafariVersion(String value) {
        this.safariVersion.setValue(value);
        return this;
    }

    public String getChromiumVersion() {
        return this.resolve(this.chromiumVersion);
    }

    public Config setChromiumVersion(String value) {
        this.chromiumVersion.setValue(value);
        return this;
    }

    public String getChromiumDriverSnapPath() {
        return this.resolve(this.chromiumDriverSnapPath);
    }

    public Config setChromiumDriverSnapPath(String value) {
        this.chromiumDriverSnapPath.setValue(value);
        return this;
    }

    public boolean isUseChromiumDriverSnap() {
        return this.resolve(this.useChromiumDriverSnap);
    }

    public Config setUseChromiumDriverSnap(boolean value) {
        this.useChromiumDriverSnap.setValue(value);
        return this;
    }

    public String getBrowserVersionDetectionCommand() {
        return this.resolve(this.browserVersionDetectionCommand);
    }

    public Config setBrowserVersionDetectionCommand(String value) {
        this.browserVersionDetectionCommand.setValue(value);
        return this;
    }

    public int getServerPort() {
        return this.resolve(this.serverPort);
    }

    public Config setServerPath(String value) {
        this.serverPath.setValue(value);
        return this;
    }

    public String getServerPath() {
        return this.resolve(this.serverPath);
    }

    public Config setServerPort(int value) {
        this.serverPort.setValue(value);
        return this;
    }

    public int getServerTimeoutSec() {
        return this.resolve(this.serverTimeoutSec);
    }

    public Config setServerTimeoutSec(int value) {
        this.serverTimeoutSec.setValue(value);
        return this;
    }

    public String getDockerDaemonUrl() {
        return this.resolve(this.dockerDaemonUrl);
    }

    public Config setDockerDaemonUrl(String value) {
        this.dockerDaemonUrl.setValue(value);
        return this;
    }

    public String getDockerHubUrl() {
        return this.resolve(this.dockerHubUrl);
    }

    public Config setDockerHubUrl(String value) {
        this.dockerHubUrl.setValue(value);
        return this;
    }

    public String getDockerNetwork() {
        return this.resolve(this.dockerNetwork);
    }

    public Config setDockerNetwork(String value) {
        this.dockerNetwork.setValue(value);
        return this;
    }

    public String getDockerTimezone() {
        return this.resolve(this.dockerTimezone);
    }

    public Config setDockerTimezone(String value) {
        this.dockerTimezone.setValue(value);
        return this;
    }

    public String getDockerLang() {
        return this.resolve(this.dockerLang);
    }

    public Config setDockerLang(String value) {
        this.dockerLang.setValue(value);
        return this;
    }

    public long getDockerMemSizeBytes(String memSize) {
        String size = memSize.toLowerCase(Locale.ROOT);
        long bytes = 0L;
        try {
            bytes = Integer.parseInt(size.substring(0, size.length() - 1));
        }
        catch (Exception e) {
            this.log.warn("Exception parsing size to bytes", e);
        }
        if (size.endsWith("g")) {
            bytes *= 0x40000000L;
        } else if (size.endsWith("m")) {
            bytes *= 0x100000L;
        } else if (size.endsWith("k")) {
            bytes *= 1024L;
        }
        this.log.trace("The memory size {} is equivalent to {} bytes)", (Object)memSize, (Object)bytes);
        return bytes;
    }

    public String getDockerShmSize() {
        return this.resolve(this.dockerShmSize);
    }

    public Config setDockerShmSize(String value) {
        this.dockerShmSize.setValue(value);
        return this;
    }

    public String getDockerTmpfsSize() {
        return this.resolve(this.dockerTmpfsSize);
    }

    public Config setDockerTmpfsSize(String value) {
        this.dockerTmpfsSize.setValue(value);
        return this;
    }

    public String getDockerTmpfsMount() {
        return this.resolve(this.dockerTmpfsMount);
    }

    public Config setDockerTmpfsMount(String value) {
        this.dockerTmpfsMount.setValue(value);
        return this;
    }

    public int getDockerStopTimeoutSec() {
        return this.resolve(this.dockerStopTimeoutSec);
    }

    public Config setDockerStopTimeoutSec(int value) {
        this.dockerStopTimeoutSec.setValue(value);
        return this;
    }

    public boolean isDockerEnabledVnc() {
        return this.resolve(this.dockerEnableVnc);
    }

    public Config setDockerEnabledVnc(boolean value) {
        this.dockerEnableVnc.setValue(value);
        return this;
    }

    public boolean isDockerViewOnly() {
        return this.resolve(this.dockerViewOnly);
    }

    public Config setDockerViewOnly(boolean value) {
        this.dockerViewOnly.setValue(value);
        return this;
    }

    public boolean isDockerEnabledRecording() {
        return this.resolve(this.dockerEnableRecording);
    }

    public Config setDockerEnabledRecording(boolean value) {
        this.dockerEnableRecording.setValue(value);
        return this;
    }

    public String getDockerScreenResolution() {
        return this.resolve(this.dockerScreenResolution);
    }

    public String getDockerVideoSize() {
        String screenResolution = this.getDockerScreenResolution().toLowerCase(Locale.ROOT);
        int count = StringUtils.countMatches((CharSequence)screenResolution, SCREEN_RESOLUTION_SEPARATOR);
        if (count == 2) {
            screenResolution = screenResolution.substring(0, screenResolution.lastIndexOf(SCREEN_RESOLUTION_SEPARATOR));
        }
        this.log.trace("The screen resolution {} corresponds to a video size of {}", (Object)this.getDockerScreenResolution(), (Object)screenResolution);
        return screenResolution;
    }

    public Config setDockerScreenResolution(String value) {
        this.dockerScreenResolution.setValue(value);
        return this;
    }

    public String getDockerVncPassword() {
        return this.resolve(this.dockerVncPassword);
    }

    public Config setDockerVncPassword(String value) {
        this.dockerVncPassword.setValue(value);
        return this;
    }

    public int getDockerBrowserPort() {
        return this.resolve(this.dockerBrowserPort);
    }

    public Config setDockerBrowserPort(int value) {
        this.dockerBrowserPort.setValue(value);
        return this;
    }

    public int getDockerVncPort() {
        return this.resolve(this.dockerVncPort);
    }

    public Config setDockerVncPort(int value) {
        this.dockerVncPort.setValue(value);
        return this;
    }

    public int getDockerNoVncPort() {
        return this.resolve(this.dockerNoVncPort);
    }

    public Config setDockerNoVncPort(int value) {
        this.dockerNoVncPort.setValue(value);
        return this;
    }

    public int getDockerRecordingFrameRate() {
        return this.resolve(this.dockerRecordingFrameRate);
    }

    public Config setDockerRecordingFrameRate(int value) {
        this.dockerRecordingFrameRate.setValue(value);
        return this;
    }

    public Path getDockerRecordingOutput() {
        return this.resolve(this.dockerRecordingOutput);
    }

    public Config setDockerRecordingOutput(Path value) {
        this.dockerRecordingOutput.setValue(value);
        return this;
    }

    public String getDockerRecordingPrefix() {
        return this.resolve(this.dockerRecordingPrefix);
    }

    public Config setDockerRecordingPrefix(String value) {
        this.dockerRecordingPrefix.setValue(value);
        return this;
    }

    public String getDockerBrowserSelenoidImageFormat() {
        return this.resolve(this.dockerBrowserSelenoidImageFormat);
    }

    public Config setDockerBrowserSelenoidImageFormat(String value) {
        this.dockerBrowserSelenoidImageFormat.setValue(value);
        return this;
    }

    public String getDockerBrowserTwilioImageFormat() {
        return this.resolve(this.dockerBrowserTwilioImageFormat);
    }

    public Config setDockerBrowserTwilioImageFormat(String value) {
        this.dockerBrowserTwilioImageFormat.setValue(value);
        return this;
    }

    public String getDockerBrowserAerokubeImageFormat() {
        return this.resolve(this.dockerBrowserAerokubeImageFormat);
    }

    public Config setDockerBrowserAerokubeImageFormat(String value) {
        this.dockerBrowserAerokubeImageFormat.setValue(value);
        return this;
    }

    public String getDockerBrowserMobileImageFormat() {
        return this.resolve(this.dockerBrowserMobileImageFormat);
    }

    public Config setDockerBrowserMobileImageFormat(String value) {
        this.dockerBrowserMobileImageFormat.setValue(value);
        return this;
    }

    public String getDockerRecordingImage() {
        return this.resolve(this.dockerRecordingImage);
    }

    public Config setDockerRecordingImage(String value) {
        this.dockerRecordingImage.setValue(value);
        return this;
    }

    public String getDockerNoVncImage() {
        return this.resolve(this.dockerNoVncImage);
    }

    public Config setDockerNoVncImage(String value) {
        this.dockerNoVncImage.setValue(value);
        return this;
    }

    public String getDockerCustomImage() {
        return this.resolve(this.dockerCustomImage);
    }

    public Config setDockerCustomImage(String value) {
        this.dockerCustomImage.setValue(value);
        return this;
    }

    public String getBrowserWatcherVersion() {
        return this.resolve(this.browserWatcherVersion);
    }

    public Config setBrowserWatcherVersion(String value) {
        this.browserWatcherVersion.setValue(value);
        return this;
    }

    public String getDockerVolumes() {
        String volumes = this.resolve(this.dockerVolumes);
        if (volumes.contains(".:")) {
            String currentFolder = FilenameUtils.getFullPathNoEndSeparator(new File("\u00b7").getAbsolutePath());
            volumes = volumes.replace(".:", String.valueOf(currentFolder) + ":");
        }
        if (volumes.contains(HOME)) {
            String homeFolder = System.getProperty("user.home");
            volumes = volumes.replace(HOME, homeFolder);
        }
        return volumes;
    }

    public Config setDockerVolumes(String ... value) {
        this.dockerVolumes.setValue(String.join((CharSequence)":", value));
        return this;
    }

    public List<String> getDockerExtraHosts() {
        String extraHosts = this.resolve(this.dockerExtraHosts);
        String[] out = new String[]{};
        if (!Config.isNullOrEmpty(extraHosts)) {
            out = extraHosts.split(",");
        }
        return Arrays.asList(out);
    }

    public Config setDockerExtraHosts(String ... value) {
        this.dockerExtraHosts.setValue(String.join((CharSequence)",", value));
        return this;
    }

    public List<String> getDockerEnvVariables() {
        String envVariables = this.resolve(this.dockerEnvVariables);
        String[] out = new String[]{};
        if (!Config.isNullOrEmpty(envVariables)) {
            out = envVariables.split(",");
        }
        return Arrays.asList(out);
    }

    public Config setDockerEnvVariables(String ... value) {
        this.dockerEnvVariables.setValue(String.join((CharSequence)",", value));
        return this;
    }

    public String getDockerDefaultArgs() {
        return this.resolve(this.dockerDefaultArgs);
    }

    public Config setDockerDefaultArgs(String value) {
        this.dockerDefaultArgs.setValue(value);
        return this;
    }

    public boolean isDockerLocalFallback() {
        return this.resolve(this.dockerLocalFallback);
    }

    public Config setDockerLocalFallback(boolean value) {
        this.dockerLocalFallback.setValue(value);
        return this;
    }

    public String getDockerPrivateEndpoint() {
        return this.resolve(this.dockerPrivateEndpoint);
    }

    public Config setDockerPrivateEndpoint(String value) {
        this.dockerPrivateEndpoint.setValue(value);
        return this;
    }

    public boolean getDockerAvoidPulling() {
        return this.resolve(this.dockerAvoidPulling);
    }

    public Config setDockerAvoidPulling(boolean value) {
        this.dockerAvoidPulling.setValue(value);
        return this;
    }

    public String getRemoteAddress() {
        return this.resolve(this.remoteAddress);
    }

    public Config setRemoteAddress(String value) {
        this.remoteAddress.setValue(value);
        return this;
    }

    public Config setEnableTracing(boolean value) {
        this.tracing.setValue(value);
        return this;
    }

    public boolean getEnableTracing() {
        return this.resolve(this.tracing);
    }
}

