/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.online.GitHubApi;
import io.github.bonigarcia.wdm.online.Parser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;

public class OperaDriverManager
extends WebDriverManager {
    protected static final String TAG_NAME_PREFIX = "v.";
    protected static final int RELATION_OPERA_OPERADRIVER = 14;

    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.OPERA;
    }

    @Override
    protected String getDriverName() {
        return "operadriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getOperaDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getOperaVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setOperaDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setOperaVersion(browserVersion);
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getOperaDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getOperaDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getOperaDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url2) {
        this.config().setOperaDriverUrl(url2);
    }

    @Override
    protected Optional<String> getLatestDriverVersionFromRepository() {
        if (this.config().isUseBetaVersions()) {
            return Optional.empty();
        }
        return this.getDriverVersionFromRepository(Optional.empty());
    }

    @Override
    protected String getCurrentVersion(URL url2) {
        if (this.config().isUseMirror()) {
            int i = url2.getFile().lastIndexOf("/");
            int j = url2.getFile().substring(0, i).lastIndexOf("/") + 1;
            String currentVersion = url2.getFile().substring(j, i);
            return currentVersion;
        }
        String currentVersion = url2.getFile().substring(url2.getFile().indexOf("/v") + 2, url2.getFile().lastIndexOf("/"));
        if (currentVersion.startsWith(".")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected List<URL> getDriverUrls(String driverVersion) throws IOException {
        if (this.isUseMirror()) {
            String versionPath = driverVersion;
            if (!driverVersion.isEmpty()) {
                versionPath = driverVersion.startsWith("0") ? "v" + versionPath : TAG_NAME_PREFIX + versionPath;
            }
            return this.getDriversFromMirror(this.getMirrorUrl().get(), versionPath);
        }
        return this.getDriversFromGitHub(driverVersion);
    }

    @Override
    protected List<File> postDownload(File archive) {
        log.trace("Post processing for Opera: {}", (Object)archive);
        File extractFolder = archive.getParentFile().listFiles(this.getFolderFilter())[0];
        if (!extractFolder.isFile()) {
            File target;
            try {
                File operadriver;
                boolean isOperaDriver;
                log.trace("Opera extract folder (to be deleted): {}", (Object)extractFolder);
                File[] listFiles = extractFolder.listFiles();
                int i = 0;
                do {
                    if (i >= listFiles.length) {
                        throw new WebDriverManagerException("Driver for Opera not found in zip file");
                    }
                    operadriver = listFiles[i];
                    isOperaDriver = operadriver.getName().contains(this.getDriverName());
                    ++i;
                    log.trace("{} is valid: {}", (Object)operadriver, (Object)isOperaDriver);
                } while (!isOperaDriver);
                log.info("Operadriver: {}", (Object)operadriver);
                target = new File(archive.getParentFile().getAbsolutePath(), operadriver.getName());
                log.trace("Operadriver target: {}", (Object)target);
                this.downloader.renameFile(operadriver, target);
            }
            finally {
                this.downloader.deleteFolder(extractFolder);
            }
            return Collections.singletonList(target);
        }
        return super.postDownload(archive);
    }

    @Override
    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        URL operaDriverUrl = this.config.getOperaDriverUrl();
        try {
            log.debug("Reading {} to discover operadriver version", (Object)operaDriverUrl);
            GitHubApi[] versions = Parser.parseJson(this.httpClient, operaDriverUrl.toString(), GitHubApi[].class);
            int majorBrowserVersion = Integer.parseInt(this.resolvedBrowserVersion);
            int majorDriverVersion = majorBrowserVersion + 14;
            List fileteredList = Arrays.stream(versions).filter(r -> r.getTagName().startsWith(TAG_NAME_PREFIX + majorDriverVersion)).collect(Collectors.toList());
            if (!fileteredList.isEmpty()) {
                return Optional.of(((GitHubApi)fileteredList.get(0)).getTagName().replace(TAG_NAME_PREFIX, ""));
            }
        }
        catch (Exception e) {
            log.warn("Exception getting operadriver version from {}", (Object)operaDriverUrl, (Object)e);
        }
        return Optional.empty();
    }

    @Override
    protected Capabilities getCapabilities() {
        Optional<Path> browserPath;
        ChromeOptions options = new ChromeOptions();
        if (!this.isUsingDocker() && (browserPath = this.getBrowserPath()).isPresent()) {
            options.setBinary(browserPath.get().toFile());
        }
        return options;
    }

    @Override
    public WebDriverManager exportParameter(String exportParameter) {
        this.config().setOperaDriverExport(exportParameter);
        return this;
    }
}

