/*
 * Decompiled with CFR 0.152.
 */
package io.ous.jtoml.impl;

import io.ous.jtoml.impl.Token;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SymbolToken implements Token
{
    CurlyLeft('{'),
    CurlyRight('}'),
    SquareLeft('['),
    SquareRight(']'),
    Dot('.'),
    Comma(','),
    Equals('='),
    SingleQuote('\''),
    DoubleQuote('\"'),
    Newline('\n');

    private final char symbol;
    private static final Map<Character, SymbolToken> MAPPING;

    private SymbolToken(char symbol) {
        this.symbol = symbol;
    }

    char getSymbol() {
        return this.symbol;
    }

    @Override
    public Token.TokenType getType() {
        return Token.TokenType.Symbol;
    }

    public String toString() {
        return String.valueOf(this.symbol);
    }

    public static SymbolToken getSymbolToken(char c) {
        return MAPPING.get(Character.valueOf(c));
    }

    public static SymbolToken valueOf(char c) throws IllegalArgumentException {
        SymbolToken ret = SymbolToken.getSymbolToken(c);
        if (ret == null) {
            throw new IllegalArgumentException("No Symbol token for character: " + c);
        }
        return ret;
    }

    static {
        SymbolToken[] values2 = SymbolToken.values();
        MAPPING = new HashMap<Character, SymbolToken>(20);
        for (SymbolToken token : values2) {
            MAPPING.put(Character.valueOf(token.getSymbol()), token);
        }
    }
}

