/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dataloader.annotations.PublicApi;
import org.dataloader.impl.Assertions;

@PublicApi
public class BatchLoaderEnvironment {
    private final Object context;
    private final Map<Object, Object> keyContexts;
    private final List<Object> keyContextsList;

    private BatchLoaderEnvironment(Object context, List<Object> keyContextsList, Map<Object, Object> keyContexts) {
        this.context = context;
        this.keyContexts = keyContexts;
        this.keyContextsList = keyContextsList;
    }

    public <T> T getContext() {
        return (T)this.context;
    }

    public Map<Object, Object> getKeyContexts() {
        return this.keyContexts;
    }

    public List<Object> getKeyContextsList() {
        return this.keyContextsList;
    }

    public static Builder newBatchLoaderEnvironment() {
        return new Builder();
    }

    public static class Builder {
        private Object context;
        private Map<Object, Object> keyContexts = Collections.emptyMap();
        private List<Object> keyContextsList = Collections.emptyList();

        private Builder() {
        }

        public Builder context(Object context) {
            this.context = context;
            return this;
        }

        public <K> Builder keyContexts(List<K> keys2, List<Object> keyContexts) {
            Assertions.nonNull(keys2);
            Assertions.nonNull(keyContexts);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < keys2.size(); ++i) {
                K key = keys2.get(i);
                Object keyContext = null;
                if (i < keyContexts.size()) {
                    keyContext = keyContexts.get(i);
                }
                if (keyContext != null) {
                    map.put(key, keyContext);
                }
                list.add(keyContext);
            }
            this.keyContexts = map;
            this.keyContextsList = list;
            return this;
        }

        public BatchLoaderEnvironment build() {
            return new BatchLoaderEnvironment(this.context, this.keyContextsList, this.keyContexts);
        }
    }
}

