/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.bidi.script.ArrayLocalValue;
import org.openqa.selenium.bidi.script.ChannelValue;
import org.openqa.selenium.bidi.script.DateLocalValue;
import org.openqa.selenium.bidi.script.MapLocalValue;
import org.openqa.selenium.bidi.script.ObjectLocalValue;
import org.openqa.selenium.bidi.script.PrimitiveProtocolValue;
import org.openqa.selenium.bidi.script.PrimitiveType;
import org.openqa.selenium.bidi.script.RegExpValue;
import org.openqa.selenium.bidi.script.RemoteReference;
import org.openqa.selenium.bidi.script.ResultOwnership;
import org.openqa.selenium.bidi.script.SerializationOptions;
import org.openqa.selenium.bidi.script.SetLocalValue;

public abstract class LocalValue {
    public abstract Map<String, Object> toJson();

    public static LocalValue stringValue(String value) {
        return new PrimitiveProtocolValue(PrimitiveType.STRING, value);
    }

    public static LocalValue numberValue(long value) {
        return new PrimitiveProtocolValue(PrimitiveType.NUMBER, value);
    }

    public static LocalValue numberValue(double value) {
        return new PrimitiveProtocolValue(PrimitiveType.NUMBER, value);
    }

    public static LocalValue numberValue(SpecialNumberType specialNumber) {
        return new PrimitiveProtocolValue(PrimitiveType.SPECIAL_NUMBER, specialNumber.toString());
    }

    public static LocalValue undefinedValue() {
        return new PrimitiveProtocolValue(PrimitiveType.UNDEFINED);
    }

    public static LocalValue nullValue() {
        return new PrimitiveProtocolValue(PrimitiveType.NULL);
    }

    public static LocalValue booleanValue(boolean value) {
        return new PrimitiveProtocolValue(PrimitiveType.BOOLEAN, value);
    }

    public static LocalValue bigIntValue(String value) {
        return new PrimitiveProtocolValue(PrimitiveType.BIGINT, value);
    }

    public static LocalValue arrayValue(List<LocalValue> value) {
        return new ArrayLocalValue(value);
    }

    public static LocalValue dateValue(String value) {
        return new DateLocalValue(value);
    }

    public static LocalValue mapValue(Map<Object, LocalValue> value) {
        return new MapLocalValue(value);
    }

    public static LocalValue objectValue(Map<Object, LocalValue> value) {
        return new ObjectLocalValue(value);
    }

    public static LocalValue regExpValue(String pattern) {
        return new RegExpValue(pattern);
    }

    public static LocalValue regExpValue(String pattern, String flags) {
        return new RegExpValue(pattern, flags);
    }

    public static LocalValue setValue(Set<LocalValue> value) {
        return new SetLocalValue(value);
    }

    public static LocalValue channelValue(String channelId) {
        return new ChannelValue(channelId);
    }

    public static LocalValue channelValue(String channelId, SerializationOptions options) {
        return new ChannelValue(channelId, options);
    }

    public static LocalValue channelValue(String channelId, SerializationOptions options, ResultOwnership resultOwnership) {
        return new ChannelValue(channelId, options, resultOwnership);
    }

    public static LocalValue remoteReference(String handle2, String sharedId) {
        return new RemoteReference(handle2, sharedId);
    }

    public static LocalValue remoteReference(RemoteReference.Type type, String id) {
        return new RemoteReference(type, id);
    }

    static enum SpecialNumberType {
        NAN("NaN"),
        MINUS_ZERO("-0"),
        INFINITY("Infinity"),
        MINUS_INFINITY("-Infinity");

        private final String type;

        private SpecialNumberType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

