/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.profiler.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v121.profiler.model.ProfileNode;
import org.openqa.selenium.json.JsonInput;

public class Profile {
    private final List<ProfileNode> nodes;
    private final Number startTime;
    private final Number endTime;
    private final Optional<List<Integer>> samples;
    private final Optional<List<Integer>> timeDeltas;

    public Profile(List<ProfileNode> nodes, Number startTime, Number endTime, Optional<List<Integer>> samples, Optional<List<Integer>> timeDeltas) {
        this.nodes = Objects.requireNonNull(nodes, "nodes is required");
        this.startTime = Objects.requireNonNull(startTime, "startTime is required");
        this.endTime = Objects.requireNonNull(endTime, "endTime is required");
        this.samples = samples;
        this.timeDeltas = timeDeltas;
    }

    public List<ProfileNode> getNodes() {
        return this.nodes;
    }

    public Number getStartTime() {
        return this.startTime;
    }

    public Number getEndTime() {
        return this.endTime;
    }

    public Optional<List<Integer>> getSamples() {
        return this.samples;
    }

    public Optional<List<Integer>> getTimeDeltas() {
        return this.timeDeltas;
    }

    private static Profile fromJson(JsonInput input) {
        List nodes = null;
        Number startTime = 0;
        Number endTime = 0;
        Optional<List<Integer>> samples = Optional.empty();
        Optional<List<Integer>> timeDeltas = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodes": {
                    nodes = input.readArray((Type)((Object)ProfileNode.class));
                    continue block14;
                }
                case "startTime": {
                    startTime = input.nextNumber();
                    continue block14;
                }
                case "endTime": {
                    endTime = input.nextNumber();
                    continue block14;
                }
                case "samples": {
                    samples = Optional.ofNullable(input.readArray((Type)((Object)Integer.class)));
                    continue block14;
                }
                case "timeDeltas": {
                    timeDeltas = Optional.ofNullable(input.readArray((Type)((Object)Integer.class)));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Profile(nodes, startTime, endTime, samples, timeDeltas);
    }
}

