/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.autofill.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v122.autofill.model.FillingStrategy;
import org.openqa.selenium.devtools.v122.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class FilledField {
    private final String htmlType;
    private final String id;
    private final String name;
    private final String value;
    private final String autofillType;
    private final FillingStrategy fillingStrategy;
    private final BackendNodeId fieldId;

    public FilledField(String htmlType, String id, String name, String value, String autofillType, FillingStrategy fillingStrategy, BackendNodeId fieldId) {
        this.htmlType = Objects.requireNonNull(htmlType, "htmlType is required");
        this.id = Objects.requireNonNull(id, "id is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.autofillType = Objects.requireNonNull(autofillType, "autofillType is required");
        this.fillingStrategy = Objects.requireNonNull(fillingStrategy, "fillingStrategy is required");
        this.fieldId = Objects.requireNonNull(fieldId, "fieldId is required");
    }

    public String getHtmlType() {
        return this.htmlType;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getAutofillType() {
        return this.autofillType;
    }

    public FillingStrategy getFillingStrategy() {
        return this.fillingStrategy;
    }

    public BackendNodeId getFieldId() {
        return this.fieldId;
    }

    private static FilledField fromJson(JsonInput input) {
        String htmlType = null;
        String id = null;
        String name = null;
        String value = null;
        String autofillType = null;
        FillingStrategy fillingStrategy = null;
        BackendNodeId fieldId = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "htmlType": {
                    htmlType = input.nextString();
                    continue block18;
                }
                case "id": {
                    id = input.nextString();
                    continue block18;
                }
                case "name": {
                    name = input.nextString();
                    continue block18;
                }
                case "value": {
                    value = input.nextString();
                    continue block18;
                }
                case "autofillType": {
                    autofillType = input.nextString();
                    continue block18;
                }
                case "fillingStrategy": {
                    fillingStrategy = (FillingStrategy)((Object)input.read((Type)((Object)FillingStrategy.class)));
                    continue block18;
                }
                case "fieldId": {
                    fieldId = (BackendNodeId)input.read((Type)((Object)BackendNodeId.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FilledField(htmlType, id, name, value, autofillType, fillingStrategy, fieldId);
    }
}

