/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122;

import java.util.function.Function;
import java.util.logging.Level;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v122.log.Log;
import org.openqa.selenium.devtools.v122.log.model.LogEntry;
import org.openqa.selenium.devtools.v122.runtime.model.Timestamp;
import org.openqa.selenium.json.JsonInput;

public class v122Log
implements org.openqa.selenium.devtools.idealized.log.Log {
    @Override
    public Command<Void> enable() {
        return Log.enable();
    }

    @Override
    public Command<Void> clear() {
        return Log.clear();
    }

    @Override
    public Event<org.openqa.selenium.devtools.idealized.log.model.LogEntry> entryAdded() {
        return new Event<org.openqa.selenium.devtools.idealized.log.model.LogEntry>(Log.entryAdded().getMethod(), input -> {
            Function mapper = ConverterFunctions.map("entry", LogEntry.class);
            LogEntry entry = (LogEntry)mapper.apply((JsonInput)input);
            return new org.openqa.selenium.devtools.idealized.log.model.LogEntry(entry.getSource().toString(), new org.openqa.selenium.logging.LogEntry(this.fromCdpLevel(entry.getLevel()), this.fromCdpTimestamp(entry.getTimestamp()), entry.getText()));
        });
    }

    private Level fromCdpLevel(LogEntry.Level level) {
        switch (level.toString()) {
            case "verbose": {
                return Level.FINEST;
            }
            case "info": {
                return Level.INFO;
            }
            case "warning": {
                return Level.WARNING;
            }
            case "error": {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }

    private long fromCdpTimestamp(Timestamp timestamp) {
        try {
            return Long.parseLong(timestamp.toString());
        }
        catch (NumberFormatException e) {
            return System.currentTimeMillis();
        }
    }
}

