/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.Network;
import org.openqa.selenium.devtools.v122.fetch.Fetch;
import org.openqa.selenium.devtools.v122.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v122.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.v122.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v122.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.v122.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.v122.fetch.model.RequestStage;
import org.openqa.selenium.devtools.v122.network.Network;
import org.openqa.selenium.devtools.v122.network.model.Request;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class v122Network
extends org.openqa.selenium.devtools.idealized.Network<AuthRequired, RequestPaused> {
    private static final Logger LOG = Logger.getLogger(v122Network.class.getName());

    public v122Network(DevTools devTools) {
        super(devTools);
    }

    @Override
    protected Command<Void> setUserAgentOverride(Network.UserAgent userAgent) {
        return Network.setUserAgentOverride(userAgent.userAgent(), userAgent.acceptLanguage(), userAgent.platform(), Optional.empty());
    }

    @Override
    protected Command<Void> enableNetworkCaching() {
        return Network.setCacheDisabled(false);
    }

    @Override
    protected Command<Void> disableNetworkCaching() {
        return Network.setCacheDisabled(true);
    }

    @Override
    protected Command<Void> enableFetchForAllPatterns() {
        return Fetch.enable(Optional.of(List.of(new RequestPattern(Optional.of("*"), Optional.empty(), Optional.of(RequestStage.REQUEST)), new RequestPattern(Optional.of("*"), Optional.empty(), Optional.of(RequestStage.RESPONSE)))), Optional.of(true));
    }

    @Override
    protected Command<Void> disableFetch() {
        return Fetch.disable();
    }

    @Override
    protected Event<AuthRequired> authRequiredEvent() {
        return Fetch.authRequired();
    }

    @Override
    protected String getUriFrom(AuthRequired authRequired) {
        return authRequired.getAuthChallenge().getOrigin();
    }

    @Override
    protected Command<Void> continueWithAuth(AuthRequired authRequired, UsernameAndPassword credentials) {
        return Fetch.continueWithAuth(authRequired.getRequestId(), new AuthChallengeResponse(AuthChallengeResponse.Response.PROVIDECREDENTIALS, Optional.of(credentials.username()), Optional.ofNullable(credentials.password())));
    }

    @Override
    protected Command<Void> cancelAuth(AuthRequired authRequired) {
        return Fetch.continueWithAuth(authRequired.getRequestId(), new AuthChallengeResponse(AuthChallengeResponse.Response.CANCELAUTH, Optional.empty(), Optional.empty()));
    }

    @Override
    public Event<RequestPaused> requestPausedEvent() {
        return Fetch.requestPaused();
    }

    @Override
    public Either<HttpRequest, HttpResponse> createSeMessages(RequestPaused pausedReq) {
        if (pausedReq.getResponseStatusCode().isPresent() || pausedReq.getResponseErrorReason().isPresent()) {
            boolean bodyIsBase64Encoded;
            String body2;
            try {
                Fetch.GetResponseBodyResponse base64Body = this.devTools.send(Fetch.getResponseBody(pausedReq.getRequestId()));
                body2 = base64Body.getBody();
                bodyIsBase64Encoded = base64Body.getBase64Encoded() != null && base64Body.getBase64Encoded() != false;
            }
            catch (DevToolsException e) {
                int code = pausedReq.getResponseStatusCode().orElse(200);
                if (code < 300 && code > 399) {
                    LOG.warning("Unable to get body for request id " + pausedReq.getRequestId());
                }
                body2 = null;
                bodyIsBase64Encoded = false;
            }
            ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
            pausedReq.getResponseHeaders().ifPresent(resHeaders2 -> resHeaders2.forEach(header -> headers.add(new AbstractMap.SimpleEntry<String, String>(header.getName(), header.getValue()))));
            HttpResponse res = this.createHttpResponse(pausedReq.getResponseStatusCode(), body2, bodyIsBase64Encoded, headers);
            return Either.right(res);
        }
        Request cdpReq = pausedReq.getRequest();
        HttpRequest req = this.createHttpRequest(cdpReq.getMethod(), cdpReq.getUrl(), cdpReq.getHeaders(), cdpReq.getPostData());
        return Either.left(req);
    }

    @Override
    protected String getRequestId(RequestPaused pausedReq) {
        return pausedReq.getRequestId().toString();
    }

    @Override
    protected Command<Void> continueWithoutModification(RequestPaused pausedRequest) {
        return Fetch.continueRequest(pausedRequest.getRequestId(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Override
    protected Command<Void> continueRequest(RequestPaused pausedReq, HttpRequest req) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (InputStream is = (InputStream)req.getContent().get();){
            is.transferTo(bos);
        }
        catch (IOException e) {
            return this.continueWithoutModification(pausedReq);
        }
        ArrayList headers = new ArrayList();
        req.forEachHeader((name, value) -> headers.add(new HeaderEntry((String)name, (String)value)));
        return Fetch.continueRequest(pausedReq.getRequestId(), Optional.of(req.getUri()), Optional.of(req.getMethod().toString()), Optional.of(Base64.getEncoder().encodeToString(bos.toByteArray())), Optional.of(headers), Optional.empty());
    }

    @Override
    protected Command<Void> fulfillRequest(RequestPaused pausedReq, HttpResponse res) {
        ArrayList headers = new ArrayList();
        res.forEachHeader((name, value) -> headers.add(new HeaderEntry((String)name, (String)value)));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (InputStream is = (InputStream)res.getContent().get();){
            is.transferTo(bos);
        }
        catch (IOException e) {
            bos.reset();
        }
        return Fetch.fulfillRequest(pausedReq.getRequestId(), res.getStatus(), Optional.of(headers), Optional.empty(), Optional.of(Base64.getEncoder().encodeToString(bos.toByteArray())), Optional.empty());
    }
}

