/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.page.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v85.network.model.LoaderId;
import org.openqa.selenium.devtools.v85.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class Frame {
    private final FrameId id;
    private final Optional<String> parentId;
    private final LoaderId loaderId;
    private final Optional<String> name;
    private final String url;
    private final Optional<String> urlFragment;
    private final String securityOrigin;
    private final String mimeType;
    private final Optional<String> unreachableUrl;

    public Frame(FrameId id, Optional<String> parentId, LoaderId loaderId, Optional<String> name, String url2, Optional<String> urlFragment, String securityOrigin, String mimeType, Optional<String> unreachableUrl) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.parentId = parentId;
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.name = name;
        this.url = Objects.requireNonNull(url2, "url is required");
        this.urlFragment = urlFragment;
        this.securityOrigin = Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.unreachableUrl = unreachableUrl;
    }

    public FrameId getId() {
        return this.id;
    }

    public Optional<String> getParentId() {
        return this.parentId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    @Beta
    public Optional<String> getUrlFragment() {
        return this.urlFragment;
    }

    public String getSecurityOrigin() {
        return this.securityOrigin;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Beta
    public Optional<String> getUnreachableUrl() {
        return this.unreachableUrl;
    }

    private static Frame fromJson(JsonInput input) {
        FrameId id = null;
        Optional<String> parentId = Optional.empty();
        LoaderId loaderId = null;
        Optional<String> name = Optional.empty();
        String url2 = null;
        Optional<String> urlFragment = Optional.empty();
        String securityOrigin = null;
        String mimeType = null;
        Optional<String> unreachableUrl = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block22;
                }
                case "parentId": {
                    parentId = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read((Type)((Object)LoaderId.class));
                    continue block22;
                }
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "url": {
                    url2 = input.nextString();
                    continue block22;
                }
                case "urlFragment": {
                    urlFragment = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "securityOrigin": {
                    securityOrigin = input.nextString();
                    continue block22;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block22;
                }
                case "unreachableUrl": {
                    unreachableUrl = Optional.ofNullable(input.nextString());
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Frame(id, parentId, loaderId, name, url2, urlFragment, securityOrigin, mimeType, unreachableUrl);
    }
}

