/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.function.Supplier;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.ErrorCodec;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class ErrorFilter
implements Filter {
    private final ErrorCodec errors;

    public ErrorFilter() {
        this(ErrorCodec.createDefault());
    }

    public ErrorFilter(ErrorCodec errors2) {
        this.errors = Require.nonNull("Error codec", errors2);
    }

    @Override
    public HttpHandler apply(HttpHandler next) {
        return req -> {
            try {
                return next.execute(req);
            }
            catch (Throwable throwable) {
                return (HttpResponse)((HttpResponse)((HttpResponse)new HttpResponse().setHeader("Cache-Control", "none")).setHeader("Content-Type", "application/json; charset=utf-8")).setStatus(this.errors.getHttpStatusCode(throwable)).setContent((Supplier)Contents.asJson(this.errors.encode(throwable)));
            }
        };
    }
}

