/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AddWebDriverSpecHeaders;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorFilter;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.DumpHttpExchangeFilter;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.service.DriverService;

@Beta
public class RemoteWebDriverBuilder {
    private static final Logger LOG = Logger.getLogger(RemoteWebDriverBuilder.class.getName());
    private static final Set<String> ILLEGAL_METADATA_KEYS = Set.of("alwaysMatch", "capabilities", "desiredCapabilities", "firstMatch");
    private final List<Capabilities> requestedCapabilities = new ArrayList<Capabilities>();
    private final Map<String, Object> additionalCapabilities = new TreeMap<String, Object>();
    private final Map<String, Object> metadata = new TreeMap<String, Object>();
    private Function<ClientConfig, HttpHandler> handlerFactory = config -> {
        HttpClient.Factory factory = HttpClient.Factory.createDefault();
        HttpClient client = factory.createClient((ClientConfig)config);
        return client.with(new CloseHttpClientFilter(factory, client));
    };
    private ClientConfig clientConfig = ClientConfig.defaultConfig();
    private URI remoteHost = null;
    private DriverService driverService;
    private Credentials credentials = null;
    private boolean useCustomConfig;
    private Augmenter augmenter = new Augmenter();

    RemoteWebDriverBuilder() {
    }

    public RemoteWebDriverBuilder oneOf(Capabilities maybeThis, Capabilities ... orOneOfThese) {
        Require.nonNull("Capabilities to use", maybeThis);
        if (!this.requestedCapabilities.isEmpty()) {
            LOG.log(Debug.getDebugLogLevel(), "Removing existing requested capabilities: " + this.requestedCapabilities);
            this.requestedCapabilities.clear();
        }
        this.addAlternative(maybeThis);
        for (Capabilities caps : orOneOfThese) {
            Require.nonNull("Capabilities to use", caps);
            this.addAlternative(caps);
        }
        return this;
    }

    public RemoteWebDriverBuilder addAlternative(Capabilities options) {
        Require.nonNull("Capabilities to use", options);
        this.requestedCapabilities.add(new ImmutableCapabilities(options));
        return this;
    }

    public RemoteWebDriverBuilder addMetadata(String key, Object value) {
        Require.nonNull("Metadata key", key);
        Require.nonNull("Metadata value", value);
        if (ILLEGAL_METADATA_KEYS.contains(key)) {
            throw new IllegalArgumentException(String.format("Cannot add %s as metadata key", key));
        }
        Object previous = this.metadata.put(key, value);
        if (previous != null) {
            LOG.log(Debug.getDebugLogLevel(), String.format("Overwriting metadata %s. Previous value %s, new value %s", key, previous, value));
        }
        return this;
    }

    public RemoteWebDriverBuilder setCapability(String capabilityName, Object value) {
        Require.nonNull("Capability name", capabilityName);
        Require.nonNull("Capability value", value);
        Object previous = this.additionalCapabilities.put(capabilityName, value);
        if (previous != null) {
            LOG.log(Debug.getDebugLogLevel(), () -> String.format("Overwriting capability %s. Previous value %s, new value %s", capabilityName, previous, value));
        }
        return this;
    }

    public RemoteWebDriverBuilder address(String uri2) {
        Require.nonNull("Address", uri2);
        try {
            return this.address(new URI(uri2));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create URI from " + uri2);
        }
    }

    public RemoteWebDriverBuilder address(URL url2) {
        Require.nonNull("Address", url2);
        try {
            return this.address(url2.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create URI from " + url2);
        }
    }

    public RemoteWebDriverBuilder address(URI uri2) {
        Require.nonNull("URI", uri2);
        if (this.driverService != null || this.clientConfig.baseUri() != null && !this.clientConfig.baseUri().equals(uri2)) {
            throw new IllegalArgumentException("Attempted to set the base uri on both this builder and the http client config. Please set in only one place. " + uri2);
        }
        this.remoteHost = uri2;
        return this;
    }

    public RemoteWebDriverBuilder authenticateAs(UsernameAndPassword usernameAndPassword) {
        Require.nonNull("User name and password", usernameAndPassword);
        this.credentials = usernameAndPassword;
        return this;
    }

    public RemoteWebDriverBuilder config(ClientConfig config) {
        Require.nonNull("HTTP client config", config);
        if (config.baseUri() != null && (this.remoteHost != null || this.driverService != null)) {
            throw new IllegalArgumentException("Base URI has already been set. Cannot also set it via client config");
        }
        this.clientConfig = config;
        this.useCustomConfig = true;
        return this;
    }

    public RemoteWebDriverBuilder withDriverService(DriverService service) {
        Require.nonNull("Driver service", service);
        if (this.clientConfig.baseUri() != null || this.remoteHost != null) {
            throw new IllegalArgumentException("Base URI has already been set. Cannot also set driver service.");
        }
        this.driverService = service;
        return this;
    }

    RemoteWebDriverBuilder connectingWith(Function<ClientConfig, HttpHandler> handlerFactory) {
        Require.nonNull("Handler factory", handlerFactory);
        this.handlerFactory = handlerFactory;
        return this;
    }

    public RemoteWebDriverBuilder augmentUsing(Augmenter augmenter) {
        Require.nonNull("Augmenter", augmenter);
        this.augmenter = augmenter;
        return this;
    }

    WebDriver getLocalDriver() {
        if (this.remoteHost != null || this.clientConfig.baseUri() != null || this.driverService != null) {
            return null;
        }
        Set infos = StreamSupport.stream(ServiceLoader.load(WebDriverInfo.class).spliterator(), false).filter(WebDriverInfo::isAvailable).collect(Collectors.toSet());
        ImmutableCapabilities additional = new ImmutableCapabilities(this.additionalCapabilities);
        Optional first = this.requestedCapabilities.stream().map(caps -> caps.merge(additional)).flatMap(caps -> infos.stream().filter(WebDriverInfo::isAvailable).filter(info -> info.isSupporting((Capabilities)caps)).map(info -> () -> info.createDriver((Capabilities)caps).orElseThrow(() -> new SessionNotCreatedException("Unable to create session with " + caps)))).findFirst();
        if (!first.isPresent()) {
            throw new SessionNotCreatedException("Unable to find matching driver for capabilities");
        }
        WebDriver localDriver = (WebDriver)((Supplier)first.get()).get();
        if (localDriver != null && this.useCustomConfig) {
            localDriver.quit();
            throw new IllegalArgumentException("ClientConfig instances do not work for Local Drivers");
        }
        return localDriver;
    }

    public WebDriver build() {
        if (this.requestedCapabilities.isEmpty() && this.additionalCapabilities.isEmpty()) {
            throw new SessionNotCreatedException("One set of browser options must be specified");
        }
        Set<String> clobberedCapabilities = this.getClobberedCapabilities();
        if (!clobberedCapabilities.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unable to create session. Additional capabilities %s overwrite capabilities in requested options", clobberedCapabilities));
        }
        WebDriver driver = this.getLocalDriver();
        if (driver == null) {
            driver = this.getRemoteDriver();
        }
        return this.augmenter.augment(driver);
    }

    private WebDriver getRemoteDriver() {
        Either<SessionNotCreatedException, ProtocolHandshake.Result> result;
        this.startDriverServiceIfNecessary();
        ClientConfig driverClientConfig = this.clientConfig;
        URI baseUri = this.getBaseUri();
        if (baseUri != null) {
            driverClientConfig = driverClientConfig.baseUri(baseUri);
        }
        if (this.credentials != null) {
            driverClientConfig = driverClientConfig.authenticateAs(this.credentials);
        }
        HttpHandler client = this.handlerFactory.apply(driverClientConfig);
        HttpHandler handler = Require.nonNull("Http handler", client).with(new AddWebDriverSpecHeaders().andThen(new ErrorFilter()).andThen(new DumpHttpExchangeFilter()));
        try {
            result = new ProtocolHandshake().createSession(handler, this.getPayload());
        }
        catch (IOException e) {
            throw new SessionNotCreatedException("Unable to create new remote session.", e);
        }
        if (result.isRight()) {
            CommandExecutor executor = result.map(res -> this.createExecutor(handler, (ProtocolHandshake.Result)res));
            return new RemoteWebDriver(executor, (Capabilities)new ImmutableCapabilities());
        }
        throw result.left();
    }

    private URI getBaseUri() {
        if (this.remoteHost != null) {
            return this.remoteHost;
        }
        if (this.driverService != null && this.driverService.isRunning()) {
            try {
                return this.driverService.getUrl().toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Unable to get driver service URI", e);
            }
        }
        return this.clientConfig.baseUri();
    }

    private DriverService startDriverServiceIfNecessary() {
        if (this.driverService == null) {
            return null;
        }
        try {
            this.driverService.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.driverService;
    }

    private CommandExecutor createExecutor(HttpHandler handler, ProtocolHandshake.Result result) {
        Dialect dialect = result.getDialect();
        Function<Command, HttpRequest> commandEncoder = dialect.getCommandCodec()::encode;
        Function<HttpResponse, Response> responseDecoder = dialect.getResponseCodec()::decode;
        Response newSessionResponse = result.createResponse();
        String id = newSessionResponse.getSessionId();
        CommandExecutor baseExecutor = cmd -> (Response)commandEncoder.andThen(handler::execute).andThen(responseDecoder).apply(cmd);
        CommandExecutor handleNewSession = cmd -> {
            if ("newSession".equals(cmd.getName())) {
                return newSessionResponse;
            }
            return baseExecutor.execute(cmd);
        };
        CommandExecutor addSessionId = cmd -> {
            Response res = handleNewSession.execute(cmd);
            if (res.getSessionId() == null) {
                res.setSessionId(id);
            }
            return res;
        };
        CommandExecutor stopService = cmd -> {
            try {
                Response response = addSessionId.execute(cmd);
                return response;
            }
            finally {
                if (this.driverService != null && "quit".equals(cmd.getName())) {
                    try {
                        this.driverService.stop();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        return stopService;
    }

    private Set<String> getClobberedCapabilities() {
        Set<String> names = this.additionalCapabilities.keySet();
        return this.requestedCapabilities.stream().map(Capabilities::getCapabilityNames).flatMap(Collection::stream).filter(names::contains).collect(Collectors.toSet());
    }

    private NewSessionPayload getPayload() {
        TreeMap<String, Object> roughPayload = new TreeMap<String, Object>(this.metadata);
        TreeMap<String, Object> w3cCaps = new TreeMap<String, Object>();
        w3cCaps.put("alwaysMatch", this.additionalCapabilities);
        if (!this.requestedCapabilities.isEmpty()) {
            w3cCaps.put("firstMatch", this.requestedCapabilities);
        }
        roughPayload.put("capabilities", w3cCaps);
        return NewSessionPayload.create(roughPayload);
    }

    private static class CloseHttpClientFilter
    implements Filter {
        private final HttpClient.Factory factory;
        private final HttpClient client;

        CloseHttpClientFilter(HttpClient.Factory factory, HttpClient client) {
            this.factory = Require.nonNull("Http client factory", factory);
            this.client = Require.nonNull("Http client", client);
        }

        @Override
        public HttpHandler apply(HttpHandler next) {
            return req -> {
                try {
                    HttpResponse httpResponse = next.execute(req);
                    return httpResponse;
                }
                finally {
                    if (req.getMethod() == HttpMethod.DELETE) {
                        HttpSessionId.getSessionId(req.getUri()).ifPresent(id -> {
                            if (("/session/" + id).equals(req.getUri())) {
                                try {
                                    this.client.close();
                                }
                                catch (Exception e) {
                                    LOG.log(Level.WARNING, "Exception swallowed while closing http client", e);
                                }
                                this.factory.cleanupIdleClients();
                            }
                        });
                    }
                }
            };
        }
    }
}

