/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import java.io.File;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.manager.SeleniumManager;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.remote.NoSuchDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class DriverFinder {
    private static final Logger LOG = Logger.getLogger(DriverFinder.class.getName());

    public static SeleniumManagerOutput.Result getPath(DriverService service, Capabilities options) {
        return DriverFinder.getPath(service, options, false);
    }

    public static SeleniumManagerOutput.Result getPath(DriverService service, Capabilities options, boolean offline) {
        String message;
        Require.nonNull("Browser options", options);
        String driverName = service.getDriverName();
        SeleniumManagerOutput.Result result = new SeleniumManagerOutput.Result(service.getExecutable());
        if (result.getDriverPath() == null) {
            result = new SeleniumManagerOutput.Result(System.getProperty(service.getDriverProperty()));
            if (result.getDriverPath() == null) {
                try {
                    result = SeleniumManager.getInstance().getDriverPath(options, offline);
                }
                catch (RuntimeException e) {
                    throw new NoSuchDriverException(String.format("Unable to obtain: %s, error %s", options, e.getMessage()), e);
                }
            } else {
                LOG.fine(String.format("Skipping Selenium Manager, path to %s found in system property: %s", driverName, result.getDriverPath()));
            }
        } else {
            LOG.fine(String.format("Skipping Selenium Manager, path to %s specified in Service class: %s", driverName, result.getDriverPath()));
        }
        if (result.getDriverPath() == null) {
            message = String.format("Unable to locate or obtain %s", driverName);
        } else if (!new File(result.getDriverPath()).exists()) {
            message = String.format("%s at location %s, does not exist", driverName, result.getDriverPath());
        } else if (!new File(result.getDriverPath()).canExecute()) {
            message = String.format("%s located at %s, cannot be executed", driverName, result.getDriverPath());
        } else {
            return result;
        }
        throw new NoSuchDriverException(message);
    }
}

