/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Internal;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.SelectionSetContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.util.TraverserContext;
import java.util.Map;
import java.util.Objects;

@Internal
public class QueryVisitorFieldEnvironmentImpl
implements QueryVisitorFieldEnvironment {
    private final boolean typeNameIntrospectionField;
    private final Field field;
    private final GraphQLFieldDefinition fieldDefinition;
    private final GraphQLOutputType parentType;
    private final GraphQLFieldsContainer unmodifiedParentType;
    private final Map<String, Object> arguments;
    private final QueryVisitorFieldEnvironment parentEnvironment;
    private final SelectionSetContainer selectionSetContainer;
    private final TraverserContext<Node> traverserContext;
    private final GraphQLSchema schema;

    public QueryVisitorFieldEnvironmentImpl(boolean typeNameIntrospectionField, Field field, GraphQLFieldDefinition fieldDefinition, GraphQLOutputType parentType, GraphQLFieldsContainer unmodifiedParentType, QueryVisitorFieldEnvironment parentEnvironment, Map<String, Object> arguments, SelectionSetContainer selectionSetContainer, TraverserContext<Node> traverserContext, GraphQLSchema schema) {
        this.typeNameIntrospectionField = typeNameIntrospectionField;
        this.field = field;
        this.fieldDefinition = fieldDefinition;
        this.parentType = parentType;
        this.unmodifiedParentType = unmodifiedParentType;
        this.parentEnvironment = parentEnvironment;
        this.arguments = arguments;
        this.selectionSetContainer = selectionSetContainer;
        this.traverserContext = traverserContext;
        this.schema = schema;
    }

    @Override
    public GraphQLSchema getSchema() {
        return this.schema;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    @Override
    public GraphQLOutputType getParentType() {
        return this.parentType;
    }

    @Override
    public QueryVisitorFieldEnvironment getParentEnvironment() {
        return this.parentEnvironment;
    }

    @Override
    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    @Override
    public SelectionSetContainer getSelectionSetContainer() {
        return this.selectionSetContainer;
    }

    @Override
    public GraphQLFieldsContainer getFieldsContainer() {
        if (this.isTypeNameIntrospectionField()) {
            throw new IllegalStateException("introspection field __typename doesn't have a fields container");
        }
        return this.unmodifiedParentType;
    }

    @Override
    public boolean isTypeNameIntrospectionField() {
        return this.typeNameIntrospectionField;
    }

    @Override
    public TraverserContext<Node> getTraverserContext() {
        return this.traverserContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryVisitorFieldEnvironmentImpl that = (QueryVisitorFieldEnvironmentImpl)o;
        return this.typeNameIntrospectionField == that.typeNameIntrospectionField && Objects.equals(this.field, that.field) && Objects.equals(this.fieldDefinition, that.fieldDefinition) && Objects.equals(this.parentType, that.parentType) && Objects.equals(this.unmodifiedParentType, that.unmodifiedParentType) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.parentEnvironment, that.parentEnvironment) && Objects.equals(this.selectionSetContainer, that.selectionSetContainer);
    }

    public int hashCode() {
        return Objects.hash(this.typeNameIntrospectionField, this.field, this.fieldDefinition, this.parentType, this.unmodifiedParentType, this.arguments, this.parentEnvironment, this.selectionSetContainer);
    }

    public String toString() {
        return "QueryVisitorFieldEnvironmentImpl{field=" + this.field + ", fieldDefinition=" + this.fieldDefinition + ", parentType=" + this.parentType + ", arguments=" + this.arguments + '}';
    }
}

