/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.ConditionalNodes;
import graphql.execution.MergedField;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.normalized.FieldCollectorNormalizedQueryParams;
import graphql.normalized.NormalizedField;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class FieldCollectorNormalizedQuery {
    private final ConditionalNodes conditionalNodes = new ConditionalNodes();
    private final ValuesResolver valuesResolver = new ValuesResolver();

    public CollectFieldResult collectFields(FieldCollectorNormalizedQueryParams parameters, NormalizedField normalizedField, MergedField mergedField, int level) {
        GraphQLUnmodifiedType fieldType = GraphQLTypeUtil.unwrapAll(normalizedField.getFieldDefinition().getType());
        if (!(fieldType instanceof GraphQLCompositeType)) {
            return new CollectFieldResult(Collections.emptyList(), Collections.emptyMap());
        }
        LinkedHashMap<String, Map<GraphQLObjectType, NormalizedField>> subFields = new LinkedHashMap<String, Map<GraphQLObjectType, NormalizedField>>();
        LinkedHashMap<NormalizedField, MergedField> mergedFieldByNormalizedField = new LinkedHashMap<NormalizedField, MergedField>();
        LinkedHashSet<GraphQLObjectType> possibleObjects = new LinkedHashSet<GraphQLObjectType>(this.resolvePossibleObjects((GraphQLCompositeType)((Object)fieldType), parameters.getGraphQLSchema()));
        for (Field field : mergedField.getFields()) {
            if (field.getSelectionSet() == null) continue;
            this.collectFields(parameters, field.getSelectionSet(), subFields, mergedFieldByNormalizedField, possibleObjects, level, normalizedField);
        }
        List<NormalizedField> children = this.subFieldsToList(subFields);
        return new CollectFieldResult(children, mergedFieldByNormalizedField);
    }

    public CollectFieldResult collectFromOperation(FieldCollectorNormalizedQueryParams parameters, OperationDefinition operationDefinition, GraphQLObjectType rootType) {
        LinkedHashMap<String, Map<GraphQLObjectType, NormalizedField>> subFields = new LinkedHashMap<String, Map<GraphQLObjectType, NormalizedField>>();
        LinkedHashMap<NormalizedField, MergedField> mergedFieldByNormalizedField = new LinkedHashMap<NormalizedField, MergedField>();
        LinkedHashSet<GraphQLObjectType> possibleObjects = new LinkedHashSet<GraphQLObjectType>();
        possibleObjects.add(rootType);
        this.collectFields(parameters, operationDefinition.getSelectionSet(), subFields, mergedFieldByNormalizedField, possibleObjects, 1, null);
        List<NormalizedField> children = this.subFieldsToList(subFields);
        return new CollectFieldResult(children, mergedFieldByNormalizedField);
    }

    private List<NormalizedField> subFieldsToList(Map<String, Map<GraphQLObjectType, NormalizedField>> subFields) {
        ArrayList<NormalizedField> children = new ArrayList<NormalizedField>();
        subFields.values().forEach(setMergedFieldWTCMap -> children.addAll(setMergedFieldWTCMap.values()));
        return children;
    }

    private void collectFields(FieldCollectorNormalizedQueryParams parameters, SelectionSet selectionSet, Map<String, Map<GraphQLObjectType, NormalizedField>> result, Map<NormalizedField, MergedField> mergedFieldByNormalizedField, Set<GraphQLObjectType> possibleObjects, int level, NormalizedField parent) {
        for (Selection selection : selectionSet.getSelections()) {
            if (selection instanceof Field) {
                this.collectField(parameters, result, mergedFieldByNormalizedField, (Field)selection, possibleObjects, level, parent);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectInlineFragment(parameters, result, mergedFieldByNormalizedField, (InlineFragment)selection, possibleObjects, level, parent);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.collectFragmentSpread(parameters, result, mergedFieldByNormalizedField, (FragmentSpread)selection, possibleObjects, level, parent);
        }
    }

    private void collectFragmentSpread(FieldCollectorNormalizedQueryParams parameters, Map<String, Map<GraphQLObjectType, NormalizedField>> result, Map<NormalizedField, MergedField> mergedFieldByNormalizedField, FragmentSpread fragmentSpread, Set<GraphQLObjectType> possibleObjects, int level, NormalizedField parent) {
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), fragmentSpread.getDirectives())) {
            return;
        }
        FragmentDefinition fragmentDefinition = Assert.assertNotNull(parameters.getFragmentsByName().get(fragmentSpread.getName()));
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), fragmentDefinition.getDirectives())) {
            return;
        }
        GraphQLCompositeType newCondition = (GraphQLCompositeType)parameters.getGraphQLSchema().getType(fragmentDefinition.getTypeCondition().getName());
        Set<GraphQLObjectType> newConditions = this.narrowDownPossibleObjects(possibleObjects, newCondition, parameters.getGraphQLSchema());
        this.collectFields(parameters, fragmentDefinition.getSelectionSet(), result, mergedFieldByNormalizedField, newConditions, level, parent);
    }

    private void collectInlineFragment(FieldCollectorNormalizedQueryParams parameters, Map<String, Map<GraphQLObjectType, NormalizedField>> result, Map<NormalizedField, MergedField> mergedFieldByNormalizedField, InlineFragment inlineFragment, Set<GraphQLObjectType> possibleObjects, int level, NormalizedField parent) {
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), inlineFragment.getDirectives())) {
            return;
        }
        Set<GraphQLObjectType> newPossibleObjects = possibleObjects;
        if (inlineFragment.getTypeCondition() != null) {
            GraphQLCompositeType newCondition = (GraphQLCompositeType)parameters.getGraphQLSchema().getType(inlineFragment.getTypeCondition().getName());
            newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newCondition, parameters.getGraphQLSchema());
        }
        this.collectFields(parameters, inlineFragment.getSelectionSet(), result, mergedFieldByNormalizedField, newPossibleObjects, level, parent);
    }

    private void collectField(FieldCollectorNormalizedQueryParams parameters, Map<String, Map<GraphQLObjectType, NormalizedField>> result, Map<NormalizedField, MergedField> mergedFieldByNormalizedField, Field field, Set<GraphQLObjectType> objectTypes, int level, NormalizedField parent) {
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), field.getDirectives())) {
            return;
        }
        String name = field.getResultKey();
        result.computeIfAbsent(name, ignored -> new LinkedHashMap());
        Map<GraphQLObjectType, NormalizedField> existingFieldWTC = result.get(name);
        for (GraphQLObjectType objectType : objectTypes) {
            if (existingFieldWTC.containsKey(objectType)) {
                NormalizedField normalizedField = existingFieldWTC.get(objectType);
                MergedField mergedField1 = mergedFieldByNormalizedField.get(normalizedField);
                MergedField updatedMergedField = mergedField1.transform(builder -> builder.addField(field));
                mergedFieldByNormalizedField.put(normalizedField, updatedMergedField);
                continue;
            }
            GraphQLFieldDefinition fieldDefinition = field.getName().equals(Introspection.TypeNameMetaFieldDef.getName()) ? Introspection.TypeNameMetaFieldDef : (field.getName().equals(Introspection.SchemaMetaFieldDef.getName()) ? Introspection.SchemaMetaFieldDef : (field.getName().equals(Introspection.TypeMetaFieldDef.getName()) ? Introspection.TypeMetaFieldDef : Assert.assertNotNull(objectType.getFieldDefinition(field.getName()), () -> String.format("no field with name %s found in object %s", field.getName(), objectType.getName()))));
            Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldDefinition.getArguments(), field.getArguments(), parameters.getVariables());
            NormalizedField newFieldWTC = NormalizedField.newQueryExecutionField().alias(field.getAlias()).arguments(argumentValues).objectType(objectType).fieldDefinition(fieldDefinition).level(level).parent(parent).build();
            existingFieldWTC.put(objectType, newFieldWTC);
            mergedFieldByNormalizedField.put(newFieldWTC, MergedField.newMergedField(field).build());
        }
    }

    private Set<GraphQLObjectType> narrowDownPossibleObjects(Set<GraphQLObjectType> currentOnes, GraphQLCompositeType typeCondition, GraphQLSchema graphQLSchema) {
        List<GraphQLObjectType> resolvedTypeCondition = this.resolvePossibleObjects(typeCondition, graphQLSchema);
        if (currentOnes.size() == 0) {
            return new LinkedHashSet<GraphQLObjectType>(resolvedTypeCondition);
        }
        LinkedHashSet<GraphQLObjectType> result = new LinkedHashSet<GraphQLObjectType>(currentOnes);
        result.retainAll(resolvedTypeCondition);
        return result;
    }

    private List<GraphQLObjectType> resolvePossibleObjects(GraphQLCompositeType type, GraphQLSchema graphQLSchema) {
        if (type instanceof GraphQLObjectType) {
            return Collections.singletonList((GraphQLObjectType)type);
        }
        if (type instanceof GraphQLInterfaceType) {
            return graphQLSchema.getImplementations((GraphQLInterfaceType)type);
        }
        if (type instanceof GraphQLUnionType) {
            List<GraphQLNamedOutputType> types = ((GraphQLUnionType)type).getTypes();
            return new ArrayList<GraphQLNamedOutputType>(types);
        }
        return (List)Assert.assertShouldNeverHappen();
    }

    public static class CollectFieldResult {
        private final List<NormalizedField> children;
        private final Map<NormalizedField, MergedField> mergedFieldByNormalized;

        public CollectFieldResult(List<NormalizedField> children, Map<NormalizedField, MergedField> mergedFieldByNormalized) {
            this.children = children;
            this.mergedFieldByNormalized = mergedFieldByNormalized;
        }

        public List<NormalizedField> getChildren() {
            return this.children;
        }

        public Map<NormalizedField, MergedField> getMergedFieldByNormalized() {
            return this.mergedFieldByNormalized;
        }
    }
}

