/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;

@Internal
public class GraphqlCharCoercing
implements Coercing<Character, Character> {
    private Character convertImpl(Object input) {
        if (input instanceof String && ((String)input).length() == 1) {
            return Character.valueOf(((String)input).charAt(0));
        }
        if (input instanceof Character) {
            return (Character)input;
        }
        return null;
    }

    @Override
    public Character serialize(Object input) {
        Character result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Expected type 'Char' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @Override
    public Character parseValue(Object input) {
        Character result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Expected type 'Char' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @Override
    public Character parseLiteral(Object input) {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        String value = ((StringValue)input).getValue();
        if (value.length() != 1) {
            throw new CoercingParseLiteralException("Empty 'StringValue' provided.");
        }
        return Character.valueOf(value.charAt(0));
    }
}

