/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.NamedNode;
import graphql.language.NodeParentTree;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlElementParentTree;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import graphql.schema.idl.SchemaDirectiveWiringEnvironmentImpl;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.WiringFactory;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;

@Internal
public class SchemaGeneratorDirectiveHelper {
    private NodeParentTree<NamedNode<?>> buildAstTree(NamedNode<?> ... nodes) {
        ArrayDeque nodeStack = new ArrayDeque();
        for (NamedNode<?> node : nodes) {
            nodeStack.push(node);
        }
        return new NodeParentTree(nodeStack);
    }

    private GraphqlElementParentTree buildRuntimeTree(GraphQLSchemaElement ... elements) {
        ArrayDeque<GraphQLSchemaElement> nodeStack = new ArrayDeque<GraphQLSchemaElement>();
        for (GraphQLSchemaElement element : elements) {
            nodeStack.push(element);
        }
        return new GraphqlElementParentTree(nodeStack);
    }

    private List<GraphQLArgument> wireArguments(GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer, NamedNode<?> fieldsContainerNode, Parameters params, GraphQLFieldDefinition field) {
        return ImmutableKit.map(field.getArguments(), argument -> {
            NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(fieldsContainerNode, field.getDefinition(), argument.getDefinition());
            GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(fieldsContainer, field, (GraphQLSchemaElement)argument);
            Parameters argParams = params.newParams(fieldDefinition, fieldsContainer, nodeParentTree, elementParentTree);
            return this.onArgument((GraphQLArgument)argument, argParams);
        });
    }

    private List<GraphQLFieldDefinition> wireFields(GraphQLFieldsContainer fieldsContainer, NamedNode<?> fieldsContainerNode, Parameters params) {
        return ImmutableKit.map(fieldsContainer.getFieldDefinitions(), fieldDefinition -> {
            List<GraphQLArgument> newArgs;
            List<GraphQLArgument> startingArgs = fieldDefinition.getArguments();
            if (this.isNotTheSameObjects(startingArgs, newArgs = this.wireArguments((GraphQLFieldDefinition)fieldDefinition, fieldsContainer, fieldsContainerNode, params, (GraphQLFieldDefinition)fieldDefinition))) {
                fieldDefinition = fieldDefinition.transform(builder -> builder.clearArguments().arguments(newArgs));
            }
            NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(fieldsContainerNode, fieldDefinition.getDefinition());
            GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(fieldsContainer, (GraphQLSchemaElement)fieldDefinition);
            Parameters fieldParams = params.newParams((GraphQLFieldDefinition)fieldDefinition, fieldsContainer, nodeParentTree, elementParentTree);
            return this.onField((GraphQLFieldDefinition)fieldDefinition, fieldParams);
        });
    }

    public GraphQLObjectType onObject(GraphQLObjectType objectType, Parameters params) {
        List<GraphQLFieldDefinition> startingFields = objectType.getFieldDefinitions();
        List<GraphQLFieldDefinition> newFields = this.wireFields(objectType, objectType.getDefinition(), params);
        GraphQLObjectType newObjectType = objectType;
        if (this.isNotTheSameObjects(startingFields, newFields)) {
            newObjectType = objectType.transform(builder -> builder.clearFields().fields(newFields));
        }
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(newObjectType.getDefinition());
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(newObjectType);
        Parameters newParams = params.newParams(newObjectType, nodeParentTree, elementParentTree);
        return this.wireDirectives(params, newObjectType, newObjectType.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLObjectType>((GraphQLObjectType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onObject);
    }

    public GraphQLInterfaceType onInterface(GraphQLInterfaceType interfaceType, Parameters params) {
        List<GraphQLFieldDefinition> startingFields = interfaceType.getFieldDefinitions();
        List<GraphQLFieldDefinition> newFields = this.wireFields(interfaceType, interfaceType.getDefinition(), params);
        GraphQLInterfaceType newInterfaceType = interfaceType;
        if (this.isNotTheSameObjects(startingFields, newFields)) {
            newInterfaceType = interfaceType.transform(builder -> builder.clearFields().fields(newFields));
        }
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(newInterfaceType.getDefinition());
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(newInterfaceType);
        Parameters newParams = params.newParams(newInterfaceType, nodeParentTree, elementParentTree);
        return this.wireDirectives(params, newInterfaceType, newInterfaceType.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInterfaceType>((GraphQLInterfaceType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onInterface);
    }

    public GraphQLEnumType onEnum(GraphQLEnumType enumType, Parameters params) {
        List<GraphQLEnumValueDefinition> startingEnumValues = enumType.getValues();
        ImmutableList<GraphQLEnumValueDefinition> newEnumValues = ImmutableKit.map(startingEnumValues, enumValueDefinition -> {
            NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(enumType.getDefinition(), enumValueDefinition.getDefinition());
            GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(enumType, (GraphQLSchemaElement)enumValueDefinition);
            Parameters fieldParams = params.newParams(nodeParentTree, elementParentTree);
            return this.onEnumValue((GraphQLEnumValueDefinition)enumValueDefinition, fieldParams);
        });
        GraphQLEnumType newEnumType = enumType;
        if (this.isNotTheSameObjects(startingEnumValues, newEnumValues)) {
            newEnumType = enumType.transform(builder -> builder.clearValues().values(newEnumValues));
        }
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(newEnumType.getDefinition());
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(newEnumType);
        Parameters newParams = params.newParams(nodeParentTree, elementParentTree);
        return this.wireDirectives(params, newEnumType, newEnumType.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLEnumType>((GraphQLEnumType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onEnum);
    }

    public GraphQLInputObjectType onInputObjectType(GraphQLInputObjectType inputObjectType, Parameters params) {
        List<GraphQLInputObjectField> startingFields = inputObjectType.getFieldDefinitions();
        ImmutableList<GraphQLInputObjectField> newFields = ImmutableKit.map(startingFields, inputField -> {
            NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(inputObjectType.getDefinition(), inputField.getDefinition());
            GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(inputObjectType, (GraphQLSchemaElement)inputField);
            Parameters fieldParams = params.newParams(nodeParentTree, elementParentTree);
            return this.onInputObjectField((GraphQLInputObjectField)inputField, fieldParams);
        });
        GraphQLInputObjectType newInputObjectType = inputObjectType;
        if (this.isNotTheSameObjects(startingFields, newFields)) {
            newInputObjectType = inputObjectType.transform(builder -> builder.clearFields().fields(newFields));
        }
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(newInputObjectType.getDefinition());
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(newInputObjectType);
        Parameters newParams = params.newParams(nodeParentTree, elementParentTree);
        return this.wireDirectives(params, newInputObjectType, newInputObjectType.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInputObjectType>((GraphQLInputObjectType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onInputObjectType);
    }

    public GraphQLUnionType onUnion(GraphQLUnionType element, Parameters params) {
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(element.getDefinition());
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(element);
        Parameters newParams = params.newParams(nodeParentTree, elementParentTree);
        return this.wireDirectives(params, element, element.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLUnionType>((GraphQLUnionType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onUnion);
    }

    public GraphQLScalarType onScalar(GraphQLScalarType element, Parameters params) {
        NodeParentTree<NamedNode<?>> nodeParentTree = this.buildAstTree(element.getDefinition());
        GraphqlElementParentTree elementParentTree = this.buildRuntimeTree(element);
        Parameters newParams = params.newParams(nodeParentTree, elementParentTree);
        return this.wireDirectives(params, element, element.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLScalarType>((GraphQLScalarType)outputElement, directives, registeredDirective, newParams), SchemaDirectiveWiring::onScalar);
    }

    private GraphQLFieldDefinition onField(GraphQLFieldDefinition fieldDefinition, Parameters params) {
        return this.wireDirectives(params, fieldDefinition, fieldDefinition.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLFieldDefinition>((GraphQLFieldDefinition)outputElement, directives, registeredDirective, params), SchemaDirectiveWiring::onField);
    }

    private GraphQLInputObjectField onInputObjectField(GraphQLInputObjectField element, Parameters params) {
        return this.wireDirectives(params, element, element.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInputObjectField>((GraphQLInputObjectField)outputElement, directives, registeredDirective, params), SchemaDirectiveWiring::onInputObjectField);
    }

    private GraphQLEnumValueDefinition onEnumValue(GraphQLEnumValueDefinition enumValueDefinition, Parameters params) {
        return this.wireDirectives(params, enumValueDefinition, enumValueDefinition.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLEnumValueDefinition>((GraphQLEnumValueDefinition)outputElement, directives, registeredDirective, params), SchemaDirectiveWiring::onEnumValue);
    }

    private GraphQLArgument onArgument(GraphQLArgument argument, Parameters params) {
        return this.wireDirectives(params, argument, argument.getDirectives(), (outputElement, directives, registeredDirective) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLArgument>((GraphQLArgument)outputElement, directives, registeredDirective, params), SchemaDirectiveWiring::onArgument);
    }

    private <T extends GraphQLDirectiveContainer> T wireDirectives(Parameters parameters, T element, List<GraphQLDirective> allDirectives, EnvBuilder<T> envBuilder, EnvInvoker<T> invoker) {
        SchemaDirectiveWiringEnvironment<T> env;
        SchemaDirectiveWiring schemaDirectiveWiring;
        RuntimeWiring runtimeWiring = parameters.getRuntimeWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        T outputObject = element;
        Map<String, SchemaDirectiveWiring> mapOfWiring = runtimeWiring.getRegisteredDirectiveWiring();
        for (GraphQLDirective directive : allDirectives) {
            schemaDirectiveWiring = mapOfWiring.get(directive.getName());
            if (schemaDirectiveWiring == null) continue;
            env = envBuilder.apply(outputObject, allDirectives, directive);
            outputObject = this.invokeWiring(outputObject, invoker, schemaDirectiveWiring, env);
        }
        for (SchemaDirectiveWiring directiveWiring : runtimeWiring.getDirectiveWiring()) {
            env = envBuilder.apply(outputObject, allDirectives, null);
            outputObject = this.invokeWiring(outputObject, invoker, directiveWiring, env);
        }
        env = envBuilder.apply(outputObject, allDirectives, null);
        if (wiringFactory.providesSchemaDirectiveWiring(env)) {
            schemaDirectiveWiring = Assert.assertNotNull(wiringFactory.getSchemaDirectiveWiring(env), () -> "Your WiringFactory MUST provide a non null SchemaDirectiveWiring");
            outputObject = this.invokeWiring(outputObject, invoker, schemaDirectiveWiring, env);
        }
        return outputObject;
    }

    private <T extends GraphQLDirectiveContainer> T invokeWiring(T element, EnvInvoker<T> invoker, SchemaDirectiveWiring schemaDirectiveWiring, SchemaDirectiveWiringEnvironment<T> env) {
        T newElement = invoker.apply(schemaDirectiveWiring, env);
        Assert.assertNotNull(newElement, () -> "The SchemaDirectiveWiring MUST return a non null return value for element '" + element.getName() + "'");
        return newElement;
    }

    private <T> boolean isNotTheSameObjects(List<T> starting, List<T> ending) {
        if (starting == ending) {
            return false;
        }
        if (ending.size() != starting.size()) {
            return true;
        }
        for (int i = 0; i < starting.size(); ++i) {
            T endObj;
            T startObj = starting.get(i);
            if (startObj == (endObj = ending.get(i))) continue;
            return true;
        }
        return false;
    }

    static interface EnvInvoker<T extends GraphQLDirectiveContainer> {
        public T apply(SchemaDirectiveWiring var1, SchemaDirectiveWiringEnvironment<T> var2);
    }

    static interface EnvBuilder<T extends GraphQLDirectiveContainer> {
        public SchemaDirectiveWiringEnvironment<T> apply(T var1, List<GraphQLDirective> var2, GraphQLDirective var3);
    }

    static class Parameters {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring runtimeWiring;
        private final NodeParentTree<NamedNode<?>> nodeParentTree;
        private final Map<String, Object> context;
        private final GraphQLCodeRegistry.Builder codeRegistry;
        private final GraphqlElementParentTree elementParentTree;
        private final GraphQLFieldsContainer fieldsContainer;
        private final GraphQLFieldDefinition fieldDefinition;

        Parameters(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, Map<String, Object> context, GraphQLCodeRegistry.Builder codeRegistry) {
            this(typeRegistry, runtimeWiring, context, codeRegistry, null, null, null, null);
        }

        Parameters(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, Map<String, Object> context, GraphQLCodeRegistry.Builder codeRegistry, NodeParentTree<NamedNode<?>> nodeParentTree, GraphqlElementParentTree elementParentTree, GraphQLFieldsContainer fieldsContainer, GraphQLFieldDefinition fieldDefinition) {
            this.typeRegistry = typeRegistry;
            this.runtimeWiring = runtimeWiring;
            this.nodeParentTree = nodeParentTree;
            this.context = context;
            this.codeRegistry = codeRegistry;
            this.elementParentTree = elementParentTree;
            this.fieldsContainer = fieldsContainer;
            this.fieldDefinition = fieldDefinition;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        public RuntimeWiring getRuntimeWiring() {
            return this.runtimeWiring;
        }

        public NodeParentTree<NamedNode<?>> getNodeParentTree() {
            return this.nodeParentTree;
        }

        public GraphqlElementParentTree getElementParentTree() {
            return this.elementParentTree;
        }

        public GraphQLFieldsContainer getFieldsContainer() {
            return this.fieldsContainer;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public GraphQLCodeRegistry.Builder getCodeRegistry() {
            return this.codeRegistry;
        }

        public GraphQLFieldDefinition getFieldsDefinition() {
            return this.fieldDefinition;
        }

        public Parameters newParams(GraphQLFieldsContainer fieldsContainer, NodeParentTree<NamedNode<?>> nodeParentTree, GraphqlElementParentTree elementParentTree) {
            return new Parameters(this.typeRegistry, this.runtimeWiring, this.context, this.codeRegistry, nodeParentTree, elementParentTree, fieldsContainer, this.fieldDefinition);
        }

        public Parameters newParams(GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer, NodeParentTree<NamedNode<?>> nodeParentTree, GraphqlElementParentTree elementParentTree) {
            return new Parameters(this.typeRegistry, this.runtimeWiring, this.context, this.codeRegistry, nodeParentTree, elementParentTree, fieldsContainer, fieldDefinition);
        }

        public Parameters newParams(NodeParentTree<NamedNode<?>> nodeParentTree, GraphqlElementParentTree elementParentTree) {
            return new Parameters(this.typeRegistry, this.runtimeWiring, this.context, this.codeRegistry, nodeParentTree, elementParentTree, this.fieldsContainer, this.fieldDefinition);
        }
    }
}

