/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Internal;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.validation.TraversalContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class ValidationContext {
    private final GraphQLSchema schema;
    private final Document document;
    private final TraversalContext traversalContext;
    private final Map<String, FragmentDefinition> fragmentDefinitionMap = new LinkedHashMap<String, FragmentDefinition>();

    public ValidationContext(GraphQLSchema schema, Document document) {
        this.schema = schema;
        this.document = document;
        this.traversalContext = new TraversalContext(schema);
        this.buildFragmentMap();
    }

    private void buildFragmentMap() {
        for (Definition definition : this.document.getDefinitions()) {
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            this.fragmentDefinitionMap.put(fragmentDefinition.getName(), fragmentDefinition);
        }
    }

    public TraversalContext getTraversalContext() {
        return this.traversalContext;
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    public Document getDocument() {
        return this.document;
    }

    public FragmentDefinition getFragment(String name) {
        return this.fragmentDefinitionMap.get(name);
    }

    public GraphQLCompositeType getParentType() {
        return this.traversalContext.getParentType();
    }

    public GraphQLInputType getInputType() {
        return this.traversalContext.getInputType();
    }

    public GraphQLFieldDefinition getFieldDef() {
        return this.traversalContext.getFieldDef();
    }

    public GraphQLDirective getDirective() {
        return this.traversalContext.getDirective();
    }

    public GraphQLArgument getArgument() {
        return this.traversalContext.getArgument();
    }

    public GraphQLOutputType getOutputType() {
        return this.traversalContext.getOutputType();
    }

    public List<String> getQueryPath() {
        return this.traversalContext.getQueryPath();
    }

    public String toString() {
        return "ValidationContext{" + this.getQueryPath() + "}";
    }
}

