/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.activation.dialog.OrgSelectionDialog;
import com.kms.katalon.activation.dialog.WarningLicenseDialog;
import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.InputValidator;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.license.models.AuthenticationCredential;
import com.kms.katalon.license.models.AuthenticationInfo;
import com.kms.katalon.license.models.License;
import com.kms.katalon.license.models.LicenseResource;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LicenseServerDialog
extends BaseModernDialog {
    private static final Color INPUT_BACKGROUND_COLOR = ColorUtil.getColor((String)"#FFFFFF");
    private static final String MACHINE_ID = MachineUtil.getMachineId();
    private static final LoginMethod LOGIN_METHOD = LoginMethod.CREDENTIAL;
    private String server;
    private InputValidator validator;
    private TextField usernameInput;
    private TextField passwordInput;
    private Link statusLabel;
    private Canvas signInButton;
    private Set<Control> blockedUIControls = new HashSet<Control>();
    private int retryCount;
    private LicenseResource licenseResource;
    private License license;
    private List<AnalyticsOrganization> organizations;

    public LicenseServerDialog(Shell parentShell) {
        super(parentShell);
        this.server = this.getAdminServer();
    }

    private String getAdminServer() {
        return StringUtils.trimToEmpty((String)ApplicationInfo.getAppProperty((String)"testOps.adminServerUrl"));
    }

    @Override
    protected Point getInitialSize() {
        return new Point(-1, -1);
    }

    @Override
    protected void createContent(Composite container) {
        ComponentEventUtil.onSubmit((Control)container, event -> {
            if (!this.signInButton.isEnabled()) {
                return;
            }
            this.signIn();
        });
        this.createHeaderContent(container);
        this.createLoginInfoContent(container);
        this.createBottomContent(container);
    }

    private void createHeaderContent(Composite container) {
        Composite header = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).marginBottom(ComponentUtil.applyZoom((int)20)).fillHorizontal().marginTop(ComponentUtil.applyZoom((int)20)).build();
        ComponentBuilder.label((Composite)header).text(MessageConstants.LOG_IN_WITH_LICENSE_SERVER).fontSize(18).bold().fillHorizontal().build();
        Composite learnMoreWrapper = (Composite)ComponentBuilder.gridContainer((Composite)header).right().build();
        ComponentBuilder.label((Composite)learnMoreWrapper, (int)4).linkButton().text("Learn more ").fontSize(10).bottom().textRight().fillHorizontal().onClick(event -> ComponentUtil.triggerLink((String)DocumentationMessageConstants.KATALON_ONPREMISE)).build();
    }

    private void createLoginInfoContent(Composite container) {
        ComponentBuilder.textField((Composite)container).placeholder(MessageConstants.LICENSE_SERVER_ADDRESS).text(this.server).background(INPUT_BACKGROUND_COLOR).fillHorizontal().forceFocus().onChange(event -> {
            this.server = ((TextField)event.widget).getText();
        }).addTo(this.blockedUIControls).build();
        this.validator = new InputValidator();
        this.validator.onValidation((validated, errors) -> {
            if (ControlUtil.isDisposed((Widget)this.signInButton)) {
                return;
            }
            ComponentUtil.setEnabledButton((Control)this.signInButton, (boolean)validated);
        });
        this.usernameInput = (TextField)ComponentBuilder.textField((Composite)container).placeholder(MessageConstants.PLACEHOLDER_EMAIL_ADDRESS).background(INPUT_BACKGROUND_COLOR).validateEmail(this.validator).fillHorizontal().addTo(this.blockedUIControls).build();
        this.passwordInput = (TextField)ComponentBuilder.textField((Composite)container, (int)16384).placeholder(MessageConstants.LBL_PASSWORD).background(INPUT_BACKGROUND_COLOR).validatePassword(this.validator).fillHorizontal().addTo(this.blockedUIControls).build();
        this.statusLabel = (Link)ComponentBuilder.link((Composite)container).color(ColorUtil.getTextErrorColor()).fontSize(10).fillHorizontal().hide().build();
    }

    private void createBottomContent(Composite container) {
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().marginTop(ComponentUtil.applyZoom((int)10)).marginBottom(ComponentUtil.applyZoom((int)5)).gridSpacing(this.applyZoom(15)).build();
        this.signInButton = (Canvas)ComponentBuilder.canvas((Composite)buttonBar).text(MessageConstants.Account_LOG_IN).submitButton().bold().fontSize(14).primaryButton3().onClick(event -> UISynchronizeService.asyncExec(() -> Trackings.trackLoginDialogAction((String)"sign-in"))).disable().autoHeight(45).fillHorizontal().addTo(this.blockedUIControls).build();
        Composite cancelButtonWrapper = (Composite)ComponentBuilder.gridContainer((Composite)buttonBar).center().build();
        ComponentBuilder.label((Composite)cancelButtonWrapper, (int)4).text("Cancel ").linkButton().textCenter().fontSize(10).fillHorizontal().onClick(event -> this.cancelPressed()).marginBottom(ComponentUtil.applyZoom((int)10)).build();
    }

    private String getServer() {
        return StringUtils.defaultString((String)this.server);
    }

    private String getUsername() {
        return StringUtils.trim((String)this.usernameInput.getText());
    }

    private String getPassword() {
        return this.passwordInput.getText();
    }

    private void signIn() {
        String serverURL = this.getServer();
        TestOpsService.getInstance().setAdminServer(serverURL);
        String username = this.getUsername();
        String password = this.getPassword();
        this.retryCount = 0;
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> {
                this.blockUI();
                this.setMessage(MessageConstants.ActivationDialogV2_MSG_LOGIN);
            });
            boolean isServerError = false;
            StringBuilder errorMessage = new StringBuilder();
            StringBuilder testConnectionStatusCode = new StringBuilder();
            do {
                try {
                    String statusCode;
                    int statusCodeInt;
                    if (this.retryCount > 0) {
                        long waitTime = (long)Math.pow(2.0, this.retryCount - 1);
                        TimeUnit.SECONDS.sleep(waitTime);
                        isServerError = false;
                        errorMessage.setLength(0);
                        testConnectionStatusCode.setLength(0);
                    }
                    boolean testConnection = KatalonApplicationActivator.getFeatureActivator().testConnection(serverURL, testConnectionStatusCode);
                    if (StringUtils.isNotEmpty((CharSequence)testConnectionStatusCode) && 500 <= (statusCodeInt = Integer.parseInt(statusCode = testConnectionStatusCode.toString())) && statusCodeInt <= 599) {
                        isServerError = true;
                        errorMessage.append(MessageConstants.ActivationDialogV2_MSG_TESTOP_UNAVAILABLE);
                        ActivationInfoCollector.sendTrackingForActivate((String)username, (String)MACHINE_ID, (boolean)false, (StringBuilder)errorMessage, (boolean)false, (Integer)this.retryCount, (LoginMethod)LOGIN_METHOD);
                        int retryingWaitTimeInfo = (int)Math.pow(2.0, this.retryCount);
                        ++this.retryCount;
                        if (this.retryCount <= 3) {
                            UISynchronizeService.syncExec(() -> {
                                this.blockUI();
                                this.setErrorMessage(MessageFormat.format(MessageConstants.ActivationDialogV2_MSG_RETRYING, retryingWaitTimeInfo));
                            });
                        }
                    }
                    if (!testConnection && !isServerError) {
                        UISynchronizeService.syncExec(() -> {
                            this.setErrorMessage(MessageConstants.ActivationDialogV2_MSG_CANNOT_CONNECT_TESTOPS);
                            this.blockUI(false);
                        });
                        return;
                    }
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                }
            } while (isServerError && this.retryCount <= 3);
            if (isServerError || this.retryCount > 3) {
                UISynchronizeService.syncExec(() -> {
                    this.blockUI(false);
                    this.setErrorMessage(MessageConstants.ActivationDialogV2_MSG_SERVER_ERROR);
                });
            } else {
                TestOpsMessageError testOpsErrorMessage = new TestOpsMessageError();
                LogUtil.logInfo((String)MessageConstants.ActivationDialogV2_LOG_ACTIVATING);
                AuthenticationCredential katOneToken = new AuthenticationCredential(username, password, serverURL);
                this.licenseResource = ActivationInfoCollector.activate((AuthenticationInfo)katOneToken, null, (String)MACHINE_ID, (TestOpsMessageError)testOpsErrorMessage);
                try {
                    if (Objects.nonNull(this.licenseResource)) {
                        this.license = this.licenseResource.getLicense();
                        if (Objects.nonNull(this.license)) {
                            if (ApplicationInfo.isPlatformStudio()) {
                                ApplicationInfo.setTestOpsServer((String)this.license.getTestopsUrl());
                            }
                            LogUtil.logInfo((String)MessageConstants.ActivationDialogV2_LOG_FETCH_ORG);
                            Long orgId = this.license.getOrganizationId();
                            if (Objects.nonNull(orgId)) {
                                String org = ActivationInfoCollector.getOrganization((long)orgId);
                                LogUtil.logInfo((String)MessageConstants.ActivationDialogV2_LOG_SAVING_ORG);
                                this.markActivated(org);
                            } else {
                                this.checkOrganizationAndSave();
                            }
                            ApplicationInfo.setLoginMethod((LoginMethod)LOGIN_METHOD);
                            ActivationInfoCollector.sendTrackingToKatalonWebsiteForActivatedSuccess((String)username);
                        } else {
                            LogUtil.logError((String)MessageFormat.format(MessageConstants.ActivationDialogV2_LOG_ERROR_GET_LICENSE, testOpsErrorMessage.getMessage()));
                            UISynchronizeService.syncExec(() -> {
                                this.blockUI(false);
                                this.setErrorMessage(testOpsErrorMessage.getMessage());
                            });
                            ActivationInfoCollector.sendTrackingForActivate((String)username, (String)MACHINE_ID, (boolean)false, (StringBuilder)new StringBuilder(testOpsErrorMessage.getMessage()), (boolean)false, (Integer)this.retryCount, (LoginMethod)LOGIN_METHOD);
                        }
                    } else {
                        LogUtil.logError((String)MessageFormat.format(MessageConstants.ActivationDialogV2_LOG_ERROR_CREDENTIALS, testOpsErrorMessage.getMessage()));
                        UISynchronizeService.syncExec(() -> {
                            this.blockUI(false);
                            this.setErrorMessage(testOpsErrorMessage.getMessage());
                        });
                        ActivationInfoCollector.sendTrackingForActivate((String)username, (String)MACHINE_ID, (boolean)false, (StringBuilder)new StringBuilder(testOpsErrorMessage.getMessage()), (boolean)false, (Integer)this.retryCount, (LoginMethod)LOGIN_METHOD);
                    }
                }
                catch (Exception error) {
                    LogUtil.logError((Throwable)error);
                    UISynchronizeService.syncExec(() -> {
                        this.setErrorMessage(MessageConstants.ActivationDialogV2_LBL_ERROR_ORGANIZATION);
                        this.blockUI(false);
                    });
                    ActivationInfoCollector.sendTrackingForActivate((String)username, (String)MACHINE_ID, (boolean)false, (StringBuilder)new StringBuilder().append(error), (boolean)false, (Integer)this.retryCount, (LoginMethod)LOGIN_METHOD);
                }
            }
        });
    }

    private void blockUI() {
        this.blockUI(true);
    }

    private void blockUI(boolean blocked) {
        if (this.signInButton.isDisposed()) {
            return;
        }
        boolean enabled = !blocked;
        this.blockedUIControls.forEach(controlI -> {
            if (controlI instanceof Canvas) {
                ComponentUtil.setEnabledButton((Control)controlI, (boolean)enabled);
            } else {
                controlI.setEnabled(enabled);
            }
        });
        ComponentUtil.setEnabledButton((Control)this.signInButton, (enabled && this.validator.isValidated() ? 1 : 0) != 0);
    }

    private void setMessage(String message) {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.statusLabel);
        ComponentUtil.showSuccess((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.getShell().pack();
    }

    private void setErrorMessage(String message) {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.statusLabel);
        ComponentUtil.showError((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.getShell().pack();
    }

    private void checkOrganizationAndSave() {
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setMessage(MessageConstants.ActivationDialogV2_MSG_GETTING_ORGANIZATION));
            try {
                LogUtil.logInfo((String)"Fetching organizations using token...");
                this.organizations = TestOpsService.getInstance().getOrganizations();
                LogUtil.logInfo((String)(String.valueOf(this.organizations.size()) + " organization(s) fetched"));
                switch (this.organizations.size()) {
                    case 0: {
                        AnalyticsOrganization organizationDefault = TestOpsService.getInstance().createDefaultOrganization();
                        this.organizations.add(organizationDefault);
                        this.markActivated(this.organizations.get(0));
                        break;
                    }
                    case 1: {
                        this.markActivated(this.organizations.get(0));
                        break;
                    }
                    default: {
                        UISynchronizeService.syncExec(() -> {
                            this.clearMessage();
                            this.getShell().setVisible(false);
                            OrgSelectionDialog orgSelectionDialog = new OrgSelectionDialog(this.getParentShell(), this.getOrganizationNames(), this.getDefaultOrganizationIndex());
                            if (orgSelectionDialog.open() == 0) {
                                AnalyticsOrganization selectedOrg = this.organizations.get(orgSelectionDialog.getSelectedOrgIndex());
                                this.markActivated(selectedOrg);
                            } else {
                                this.getShell().setVisible(true);
                                this.getShell().forceActive();
                                this.blockUI(false);
                            }
                        });
                        break;
                    }
                }
            }
            catch (Exception e) {
                ActivationInfoCollector.sendTrackingForActivate((String)this.getUsername(), (String)MACHINE_ID, (boolean)false, (StringBuilder)new StringBuilder().append(e), (boolean)false, (Integer)this.retryCount, (LoginMethod)LOGIN_METHOD);
                LogUtil.logError((Throwable)e);
                UISynchronizeService.syncExec(() -> {
                    this.clearMessage();
                    MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), MessageConstants.ActivationDialogV2_LBL_ERROR, null, MessageConstants.ActivationDialogV2_LBL_ERROR_ORGANIZATION, 1, new String[]{"OK"}, 0);
                    if (dialog.open() == 0) {
                        this.blockUI(false);
                    }
                });
            }
        });
    }

    private void clearMessage() {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.hide((Control)this.statusLabel);
        ComponentUtil.setText((Widget)this.statusLabel, (String)"");
        this.getShell().pack();
    }

    private List<String> getOrganizationNames() {
        return this.organizations.stream().map(AnalyticsOrganization::getName).collect(Collectors.toList());
    }

    private int getDefaultOrganizationIndex() {
        int i = 0;
        while (i < this.organizations.size()) {
            AnalyticsOrganization organization = this.organizations.get(i);
            if (StringUtils.equals((CharSequence)organization.getRole(), (CharSequence)"USER")) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void markActivated(AnalyticsOrganization organization) {
        this.markActivated(JsonUtil.toJson((Object)organization));
    }

    private void markActivated(String orgAsString) {
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setMessage(MessageConstants.ActivationDialogV2_MSG_GETTING_FEATURE));
            try {
                ApplicationInfo.setAdminServer((String)this.getServer());
                ActivationInfoCollector.markActivated((AuthenticationInfo)TestOpsService.getInstance().getCombinedToken(), (String)orgAsString, (License)this.license);
                UISynchronizeService.syncExec(() -> this.okPressed());
                String message = this.licenseResource.getMessage();
                StringBuilder errorMessage = new StringBuilder();
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    errorMessage.append(message);
                    UISynchronizeService.syncExec(() -> {
                        WarningLicenseDialog warningLicenseDialog = new WarningLicenseDialog(Display.getCurrent().getActiveShell(), message);
                        warningLicenseDialog.open();
                    });
                }
                ActivationInfoCollector.sendTrackingForActivate((String)ApplicationContext.getInstance().getUserId(), (String)MACHINE_ID, (boolean)true, (StringBuilder)errorMessage, (boolean)false, (Integer)this.retryCount, (LoginMethod)LOGIN_METHOD);
            }
            catch (Exception e) {
                UISynchronizeService.syncExec(() -> this.blockUI(false));
                LogUtil.logError((Throwable)e, (String)ApplicationMessageConstants.ACTIVATION_COLLECT_FAIL_MESSAGE);
                ActivationInfoCollector.sendTrackingForActivate((String)ApplicationContext.getInstance().getUserId(), (String)MACHINE_ID, (boolean)false, (StringBuilder)new StringBuilder().append(e), (boolean)false, (Integer)this.retryCount, (LoginMethod)LOGIN_METHOD);
            }
        });
    }
}

