/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.composer.components.controls.FileInput;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class OfflineActivationDialog
extends BaseModernDialog {
    public static final String[] filterExts = new String[]{"*.lic;*.LIC", "*.*"};
    public static final String[] filterNames = new String[]{"License Files (*.lic;*.LIC)", "All Files (*.*)"};
    private Canvas activateButton;
    private FileInput licenseFileInput;
    private Label statusLabel;

    public OfflineActivationDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(-1, -1);
    }

    @Override
    protected void createContent(Composite container) {
        Composite header = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).marginBottom(ComponentUtil.applyZoom((int)20)).fillHorizontal().build();
        ComponentBuilder.label((Composite)header).text("Offline activation").fontSize(18).bold().fillHorizontal().build();
        Composite linkWrapper = (Composite)ComponentBuilder.gridContainer((Composite)header).right().build();
        ComponentBuilder.label((Composite)linkWrapper, (int)4).linkButton().text("Learn more ").fontSize(10).bottom().textRight().fillHorizontal().onClick(event -> ComponentUtil.triggerLink((String)DocumentationMessageConstants.OFFLINE_ACTIVATION)).build();
        Composite body = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        String machineId = MachineUtil.getMachineId();
        Composite machineIdContainer = (Composite)ComponentBuilder.gridContainer((Composite)body, (int)3).fillHorizontal().build();
        ComponentBuilder.label((Composite)machineIdContainer).text("\u2022 Machine ID: ").build();
        ComponentBuilder.label((Composite)machineIdContainer).text(machineId).bold().build();
        ComponentBuilder.iconButton((Composite)machineIdContainer, (String)this.getImage()).onClick(event -> ComponentDataUtil.copyToClipboard((String)machineId)).build();
        ComponentBuilder.label((Composite)body).text("\u2022 License file:").fillHorizontal().build();
        this.licenseFileInput = (FileInput)ComponentBuilder.fileInput((Composite)body).marginLeft(this.applyZoom(10)).fillHorizontal().onChange(event -> {
            boolean isValidInput = StringUtils.isNotBlank((CharSequence)this.licenseFileInput.getText());
            ComponentUtil.setEnabledButton((Control)this.activateButton, (boolean)isValidInput);
            this.setProgressMessage("", false);
        }).build();
        this.licenseFileInput.setDialogTitle(MessageConstants.DIALOG_SELECT_LICENSE).setFilterPath(GlobalStringConstants.LICENSE_FOLDER).setFilterExtensions(filterExts).setFilterNames(filterNames);
        this.statusLabel = (Label)ComponentBuilder.label((Composite)body).fillHorizontal().hide().build();
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().marginTop(ComponentUtil.applyZoom((int)10)).marginBottom(ComponentUtil.applyZoom((int)5)).gridSpacing(this.applyZoom(15)).build();
        Composite licenseSection = (Composite)ComponentBuilder.gridContainer((Composite)buttonBar, (int)2).gridSpacing(ComponentUtil.applyZoom((int)(SystemUtils.IS_OS_MAC ? -3 : 2))).center().build();
        ComponentBuilder.label((Composite)licenseSection).text(MessageConstants.ActivationDialogV2_LBL_AGREE_TERM_V1).fontSize(12).color(ColorUtil.themeColor((String)"#919299", (String)"#FFFFFF")).textCenter().center().build();
        ComponentBuilder.label((Composite)licenseSection, (int)4).text(MessageConstants.ActivationDialogV2_LBL_AGREE_TERM_V2).marginTop(ComponentUtil.applyZoom((int)(SystemUtils.IS_OS_MAC ? 3 : 1))).linkButton().color(ColorUtil.themeColor((String)"#919299", (String)"#FFFFFF")).fontSize(12).onClick(event -> ComponentUtil.triggerLink((String)"https://katalon.com/terms#license-agreement")).center().build();
        this.activateButton = (Canvas)ComponentBuilder.canvas((Composite)buttonBar).text("Activate").bold().fontSize(14).primaryButton3().disable().onClick(event -> {
            this.activateButton.setEnabled(false);
            this.setProgressMessage(MessageConstants.ActivationDialogV2_MSG_ACTIVATING, false);
            StringBuilder errorMessage = new StringBuilder();
            String licenseFilePath = this.licenseFileInput.getText();
            try {
                String activationCode = FileUtils.readFileToString((File)new File(licenseFilePath), (Charset)Charset.forName("UTF-8"));
                StringBuilder messageTestingLicense = new StringBuilder();
                if (ActivationInfoCollector.checkTestingLicense((String)activationCode, (StringBuilder)messageTestingLicense)) {
                    String message = messageTestingLicense.toString();
                    if (ApplicationMessageConstants.TESTING_LICENSE_MACHINE_ID_CORRECT.equals(message)) {
                        this.setProgressMessage(message, false);
                    } else {
                        this.setProgressMessage(message, true);
                    }
                    this.activateButton.setEnabled(true);
                } else {
                    boolean result = ActivationInfoCollector.activateOffline((String)activationCode, (StringBuilder)errorMessage, (RunningMode)ApplicationRunningMode.get());
                    if (result) {
                        this.setReturnCode(0);
                        this.close();
                    } else {
                        this.setProgressMessage(errorMessage.toString(), true);
                        this.activateButton.setEnabled(true);
                    }
                }
                ApplicationInfo.setLoginMethod((LoginMethod)LoginMethod.OFFLINCE_LICENSE);
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
                this.setProgressMessage(ex.getMessage(), true);
            }
        }).autoHeight(45).fillHorizontal().build();
        Composite backButtonWrapper = (Composite)ComponentBuilder.gridContainer((Composite)buttonBar).center().build();
        ComponentBuilder.label((Composite)backButtonWrapper, (int)4).text("Back to Sign in ").linkButton().textCenter().fontSize(10).fillHorizontal().onClick(event -> this.handleShellCloseEvent()).build();
    }

    private void setProgressMessage(String message, boolean isError) {
        ComponentUtil.setVisible((Control)this.statusLabel, (boolean)StringUtils.isNotBlank((CharSequence)message));
        if (isError) {
            ComponentUtil.showError((Control)this.statusLabel, (String)message);
        } else {
            ComponentUtil.showSuccess((Control)this.statusLabel, (String)message);
        }
        this.statusLabel.getShell().pack();
    }

    private String getImage() {
        return ColorUtil.isDarkTheme() ? "copy_white_32.png" : "copy_32.png";
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    @Override
    protected void handleShellCloseEvent() {
        this.close();
    }
}

