/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.addons;

import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.preference.TourStatusPreference;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.handlers.OpenQuickStartPageHandler;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.helpers.PartHelper;
import com.kms.katalon.composer.preferences.TutorialPreferenceStore;
import com.kms.katalon.composer.quickstart.ExecuteFirstTestSuccessfullyDialog;
import com.kms.katalon.composer.quickstart.ExecuteFirstTestUnsuccessfullyDialog;
import com.kms.katalon.composer.quickstart.QuickCreateFirstWebUITestCase;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tutorial.Tutorial;
import com.kms.katalon.composer.tutorial.TutorialCollection;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.util.TourUtil;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Display;

public class QuickStartController {
    public static EnumMap<ProjectType, QuickStartTourType> QUICK_START_TYPE_MAP = new EnumMap(ProjectType.class);
    @Inject
    IEventBroker eventBroker;

    static {
        QUICK_START_TYPE_MAP.put(ProjectType.WEBUI, QuickStartTourType.WEB_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.WEBSERVICE, QuickStartTourType.API_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.MOBILE, QuickStartTourType.MOBILE_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.DESKTOP, QuickStartTourType.DESKTOP_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.GENERIC, QuickStartTourType.GENERIC_TESTING);
    }

    public static QuickStartTourType getCurProjectTourType() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project != null) {
            ProjectType projectType = project.getType();
            return QUICK_START_TYPE_MAP.get(projectType);
        }
        return QUICK_START_TYPE_MAP.get(ProjectType.WEBUI);
    }

    public static QuickStartTourType getProjectTourType(QuickStartProjectType quickStartProjectType) {
        switch (quickStartProjectType) {
            case WEBUI: {
                return QuickStartTourType.WEB_TESTING;
            }
            case API: {
                return QuickStartTourType.API_TESTING;
            }
            case MOBILE: {
                return QuickStartTourType.MOBILE_TESTING;
            }
            case DESKTOP: {
                return QuickStartTourType.DESKTOP_TESTING;
            }
            case BDD: {
                return QuickStartTourType.BDD_TESTING;
            }
        }
        return QuickStartTourType.WEB_TESTING;
    }

    public static QuickStartTourType getCurrentTourTypeFromQuickStartPart() {
        String quickStartPartId = "com.kms.katalon.part.quickStart";
        MPart quickStartPart = PartHelper.findPart(quickStartPartId);
        if (quickStartPart == null || StringUtils.isEmpty((CharSequence)quickStartPart.getContainerData())) {
            return QuickStartController.getCurProjectTourType();
        }
        QuickStartTourType testingType = QuickStartTourType.valueOf(quickStartPart.getContainerData());
        return testingType;
    }

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe("ACTIVATION/CHECKED", event -> {});
        this.eventBroker.subscribe("ACTIVATION/DEACTIVATED", event -> {});
        this.eventBroker.subscribe("PROJECT/NEW_PROJECT_OPENED", event -> this.handleNewProjectOpened());
        this.eventBroker.subscribe("ANALYTIC/AUTO_ENABLE_INTEGRATION", event -> this.handleAutoEnableTestopsIntegration());
        this.eventBroker.subscribe("PROJECT/OPENED", event -> this.handleProjectOpened());
        this.eventBroker.subscribe("PROJECT/CLOSED", event -> this.handleProjectClosed());
        this.eventBroker.subscribe("RECORDER/DONE_FIRST_RECORD", event -> this.handleFirstRecordDone());
        this.eventBroker.subscribe("FIRST_TEST_CASE_CREATED", event -> this.handleFirstTestCaseCreated());
        this.eventBroker.subscribe("EXECUTE/EXECUTE_TEST_CASE_COMPLETED", event -> {});
    }

    private void handleAutoEnableTestopsIntegration() {
        if (ActivationInfoCollector.isLicenseOffline()) {
            return;
        }
        KatalonApplicationActivator.getTestOpsConfiguration().autoTestOpsIntegration(null);
    }

    private void handleNewProjectOpened() {
        TourStatusPreference pref = new TourStatusPreference();
        if (!pref.isInTour()) {
            this.enableTestOpsIntegration();
        }
    }

    private void handleProjectOpened() {
        UserProfile curUser = UserProfileHelper.getCurrentProfile();
        QuickStartProjectType quickStartProjectType = curUser.getPreferredTestingType();
        if (TourUtil.isUsingBDDSampleProject()) {
            quickStartProjectType = QuickStartProjectType.BDD;
        }
        if (curUser.isOldUser()) {
            this.handleProjectOpenedForOldUsers();
        } else {
            this.handleProjectOpenedForNewUsers(quickStartProjectType);
        }
        curUser = UserProfileHelper.getCurrentProfile();
        curUser.setDoneCreateFirstProject(true);
        UserProfileHelper.saveProfile((UserProfile)curUser);
        TourUtil.setIsUsingBDDSampleProject(false);
    }

    private void handleProjectOpenedForOldUsers() {
    }

    private void handleProjectOpenedForNewUsers(QuickStartProjectType quickStartProjectType) {
        switch (quickStartProjectType) {
            case WEBUI: 
            case API: 
            case BDD: {
                this.handleFirstProjectOpenedWithNewKatalonTour(quickStartProjectType);
                break;
            }
            default: {
                this.handleFirstOtherProjectTypeOpened();
            }
        }
    }

    private void handleFirstProjectOpenedWithNewKatalonTour(QuickStartProjectType quickStartProjectType) {
        boolean hasCompletedAllTours;
        UserProfile curUser = UserProfileHelper.getCurrentProfile();
        QuickStartTourType quickStartType = QuickStartController.getProjectTourType(quickStartProjectType);
        if (!curUser.isDoneQuickStartOverview()) {
            if (!curUser.hasCompletedTour(quickStartType.name())) {
                if (quickStartType != QuickStartTourType.BDD_TESTING) {
                    new OpenQuickStartOverviewHandler().execute(quickStartType, null, quickStartType);
                } else {
                    new OpenQuickStartOverviewHandler().execute(quickStartType, QuickStartTourType.BDD_TESTING_FEATURE_FILE, quickStartType);
                }
            }
            curUser.setDoneQuickStartOverview(true);
            UserProfileHelper.saveProfile((UserProfile)curUser);
        }
        boolean bl = hasCompletedAllTours = curUser.hasCompletedTour(quickStartType.name()) && curUser.hasCompletedTour(QuickStartTourType.TEST_PLANNING.name());
        if (!hasCompletedAllTours) {
            if (curUser.isDoneFirstTimeUseSurvey()) {
                new OpenQuickStartPageHandler().execute(quickStartProjectType);
            } else {
                curUser.setDoneFirstTimeUseSurvey(true);
                UserProfileHelper.saveProfile((UserProfile)curUser);
                new OpenQuickStartPageHandler().execute(quickStartProjectType);
            }
        }
    }

    private void quickCreateFirstWebUITestCase() {
        TimeUtil.setTimeout(() -> {
            UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
            if (!currentProfile.isNewUser() || currentProfile.isDoneCreateFirstTestCase() || !currentProfile.isPreferWebUI()) {
                return;
            }
            UISynchronizeService.syncExec(() -> {
                QuickCreateFirstWebUITestCase quickCreateFirstTestCaseDialog = new QuickCreateFirstWebUITestCase(ShellManager.getMainShell());
                quickCreateFirstTestCaseDialog.open();
                currentProfile.setDoneCreateFirstTestCase(true);
                currentProfile.setPreferredBrowser(quickCreateFirstTestCaseDialog.getPreferredBrowser());
                currentProfile.setPreferredSite(quickCreateFirstTestCaseDialog.getPreferredSite());
                UserProfileHelper.saveProfile((UserProfile)currentProfile);
                EventBrokerSingleton.getInstance().getEventBroker().send("KATALON/RECORD", null);
            });
        }, (long)3000L);
    }

    private void handleFirstOtherProjectTypeOpened() {
        ProjectType projectType = this.getProjectType();
        UserProfile curUser = UserProfileHelper.getCurrentProfile();
        if (!curUser.isDoneCreateFirstProject()) {
            this.enableTestOpsIntegration();
        }
        if (this.hasCompletedAllTutorials(curUser.getEmail(), projectType)) {
            return;
        }
        PartHelper.hidePart(KatalonPartHelper.getStartPage());
        KatalonPartHelper.activateTutorialsPart(false);
    }

    private void handleProjectClosed() {
        PartHelper.hidePart(KatalonPartHelper.getTutorialsPart());
        PartHelper.hidePart(KatalonPartHelper.getQuickStartPart());
    }

    private void handleFirstRecordDone() {
    }

    private void handleFirstTestCaseCreated() {
    }

    private void handleRunTestCaseJobCompleted(ILauncherResult result) {
        if (result == null) {
            return;
        }
        ProjectEntity curProject = ProjectController.getInstance().getCurrentProject();
        ProjectType projectType = this.getProjectType();
        UserProfile curUser = UserProfileHelper.getCurrentProfile();
        if (curProject == null || projectType != ProjectType.WEBUI || curUser.isOldUser() || !curUser.isPreferWebUI() || curUser.isDoneRunFirstTestCasePass() || curUser.isDoneRunFirstTestCaseFail()) {
            return;
        }
        curUser.setDoneRunFirstTestCase(true);
        UserProfileHelper.saveProfile((UserProfile)curUser);
        UISynchronizeService.syncExec(() -> {
            if (result.getReturnCode() == 0) {
                if (curUser.isDoneRunFirstTestCasePass()) {
                    return;
                }
                curUser.setDoneRunFirstTestCasePass(true);
                UserProfileHelper.saveProfile((UserProfile)curUser);
                ExecuteFirstTestSuccessfullyDialog congratulationDialog = new ExecuteFirstTestSuccessfullyDialog(Display.getCurrent().getActiveShell());
                congratulationDialog.open();
                this.markTutorialsAsRead(curUser.getEmail(), projectType, 2);
            } else {
                if (curUser.isDoneRunFirstTestCaseFail()) {
                    return;
                }
                curUser.setDoneRunFirstTestCaseFail(true);
                UserProfileHelper.saveProfile((UserProfile)curUser);
                ExecuteFirstTestUnsuccessfullyDialog troubleshotDialog = new ExecuteFirstTestUnsuccessfullyDialog(Display.getCurrent().getActiveShell());
                troubleshotDialog.open();
                this.markTutorialsAsRead(curUser.getEmail(), projectType, 1);
            }
            KatalonPartHelper.activateTutorialsPart();
        });
    }

    private ProjectType getProjectType() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            return null;
        }
        ProjectType projectType = project.getType();
        return projectType;
    }

    private void markTutorialsAsRead(String userEmail, ProjectType projectType, int numSkip) {
        TutorialCollection tutorialCollection = TutorialCollection.syncWithRemote(userEmail);
        List<Tutorial> tutorials = tutorialCollection.getTutorialsByProjectType(projectType);
        int i = 0;
        while (i < numSkip && i < tutorials.size()) {
            tutorials.get(i).setRead(true);
            ++i;
        }
        tutorialCollection.setTutorialsByProjectType(tutorials, projectType);
        try {
            TutorialPreferenceStore.saveTutorialCollection(tutorialCollection);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean hasCompletedAllTutorials(String user, ProjectType projectType) {
        TutorialCollection tutorialCollection = TutorialCollection.syncWithRemote(user);
        if (tutorialCollection != null) {
            return tutorialCollection.isCompleted(projectType);
        }
        return true;
    }

    private void enableTestOpsIntegration() {
        if (!ApplicationInfo.isPlatformStudio()) {
            KatalonApplicationActivator.getTestOpsConfiguration().testOpsQuickIntergration(null);
        }
    }
}

