/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.helpers.PartHelper;
import com.kms.katalon.composer.parts.WelcomePart2;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.StringConstants;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class OpenWelcomePageHandler {
    private static final String WELCOME_PART_URI = PartHelper.getURI(WelcomePart2.class);
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;

    @Execute
    public void execute() {
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        if (stack == null) {
            return;
        }
        String partId = this.getPartId();
        MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
        if (mPart == null) {
            mPart = (MPart)this.modelService.createModelElement(MPart.class);
            mPart.setElementId(partId);
            mPart.setLabel(StringConstants.PA_WELCOME);
            mPart.setIconURI(this.getIconURI());
            mPart.setContributionURI(this.getContributionURI());
            mPart.setCloseable(true);
            stack.getChildren().add(mPart);
        }
        this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
        stack.setSelectedElement((MUIElement)mPart);
    }

    @Inject
    @Optional
    public void execute(@UIEventTopic(value="KATALON/HELP") Object eventData) {
        this.execute();
    }

    private String getPartId() {
        return "com.kms.katalon.part.welcome";
    }

    private String getIconURI() {
        return ImageConstants.URI_IMG_WELCOME;
    }

    private String getContributionURI() {
        return WELCOME_PART_URI;
    }
}

