/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.katalon.platform.api.Plugin;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.handlers.PreferenceDialog;
import com.kms.katalon.composer.handlers.PreferencePageViewerComparator;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.helper.DecompilerPreferencesHelper;
import com.kms.katalon.preferences.internal.PreferencesRegistry;
import com.kms.katalon.tracking.service.Trackings;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.IEditorDescriptor;

public class PreferenceHandler
extends AbstractHandler {
    public static final String DEFAULT_PREFERENCE_PAGE_ID = "com.kms.katalon.composer.preferences.GeneralPreferencePage";
    private static final String[] UNNECESSARY_PREF_NODES = new String[0];
    private static final String KOBITON_PREF_PATH = "com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.integration.kobiton.preferences";
    private static final String KOBITON_PLUGIN_ID = "com.katalon.katalon-studio-kobiton";

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        PreferenceHandler.doExecute();
    }

    public static void doExecute() {
        PreferenceHandler.doExecute(null);
    }

    public static int doExecute(String initPreferencePageId) {
        PreferenceManager applicationPref = ((PreferencesRegistry)ContextInjectionFactory.make(PreferencesRegistry.class, (IEclipseContext)PreferenceHandler.getWorkbenchContext())).getPreferenceManager("com.kms.katalon.preferences.PreferencePages", ApplicationInfo.isPlatformStudio());
        IPreferenceNode[] applicationNodes = applicationPref.getRootSubNodes();
        PreferenceManager workbenchPref = PreferenceHandler.getActiveWorkbench().getPreferenceManager();
        PreferenceHandler.removeUnnecessaryNodes(workbenchPref);
        PreferenceHandler.addApplicationNodesToWorkbenchPreferenceManger(workbenchPref, applicationNodes);
        PreferenceHandler.hideKobitonPreferencePageIfKobitonPluginNotInstalled(workbenchPref);
        int result = PreferenceHandler.openPreferenceDialog(workbenchPref, initPreferencePageId);
        PreferenceHandler.trackClassFileEditorChanged();
        PreferenceHandler.removeApplicationNodesFromWorkbenchPreferenceManager(workbenchPref, applicationNodes);
        return result;
    }

    private static void hideKobitonPreferencePageIfKobitonPluginNotInstalled(PreferenceManager workbenchPref) {
        Plugin plugin = ApplicationManager.getInstance().getPluginManager().getPlugin(KOBITON_PLUGIN_ID);
        if (plugin == null) {
            workbenchPref.remove(KOBITON_PREF_PATH);
        }
    }

    @Inject
    @Optional
    public void execute(@UIEventTopic(value="KATALON/PREFERENCES") Object eventData) {
        if (eventData instanceof String) {
            PreferenceHandler.doExecute((String)eventData);
        } else {
            PreferenceHandler.doExecute();
        }
    }

    private static void removeUnnecessaryNodes(PreferenceManager workbenchPref) {
        String[] stringArray = UNNECESSARY_PREF_NODES;
        int n = UNNECESSARY_PREF_NODES.length;
        int n2 = 0;
        while (n2 < n) {
            String unnecessaryPreferenceId = stringArray[n2];
            workbenchPref.remove(unnecessaryPreferenceId);
            ++n2;
        }
    }

    private static void addApplicationNodesToWorkbenchPreferenceManger(PreferenceManager workbenchPref, IPreferenceNode[] applicationNodes) {
        IPreferenceNode[] iPreferenceNodeArray = applicationNodes;
        int n = applicationNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode subRoot = iPreferenceNodeArray[n2];
            if (workbenchPref.find(subRoot.getId()) == null) {
                workbenchPref.addToRoot(subRoot);
            }
            ++n2;
        }
    }

    private static void removeApplicationNodesFromWorkbenchPreferenceManager(PreferenceManager workbenchPref, IPreferenceNode[] applicationNodes) {
        IPreferenceNode[] iPreferenceNodeArray = applicationNodes;
        int n = applicationNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode subRoot = iPreferenceNodeArray[n2];
            workbenchPref.remove(subRoot);
            ++n2;
        }
    }

    private static int openPreferenceDialog(PreferenceManager workbenchPref, String initPreferencePagePath) {
        IPreferenceNode preference;
        PreferenceDialog dialog = new PreferenceDialog(PreferenceHandler.getActiveWorkbenchWindow().getShell(), workbenchPref);
        dialog.create();
        TreeViewer dialogTreeViewer = dialog.getTreeViewer();
        dialogTreeViewer.setComparator((ViewerComparator)new PreferencePageViewerComparator());
        dialog.setMinimumPageSize(500, 500);
        if (DEFAULT_PREFERENCE_PAGE_ID.equals(dialog.getSelectedNodePreference())) {
            dialogTreeViewer.expandToLevel((Object)dialog.getPreferenceManager().find(DEFAULT_PREFERENCE_PAGE_ID), 1);
        }
        if (StringUtils.isNotEmpty((CharSequence)initPreferencePagePath) && (preference = dialog.getPreferenceManager().find(initPreferencePagePath)) != null) {
            dialogTreeViewer.setSelection((ISelection)new StructuredSelection((Object)preference));
        }
        return dialog.open();
    }

    private static void trackClassFileEditorChanged() {
        if (!FeatureServiceConsumer.getServiceInstance().canUse(KSEFeature.DECOMPILE_CLASS_FILE)) {
            DecompilerPreferencesHelper.checkDefaultClassEditor();
        } else if (DecompilerPreferencesHelper.checkEditorAssociations()) {
            IEditorDescriptor classEditor = DecompilerPreferencesHelper.getCurrentClassEditor();
            IEditorDescriptor classNoSourceEditor = DecompilerPreferencesHelper.getCurrentClassNoSourceEditor();
            String classEditorId = classEditor != null ? classEditor.getId() : "";
            String classNoSourceEditorId = classNoSourceEditor != null ? classNoSourceEditor.getId() : "";
            Trackings.trackClassFileEditorChanged((String)classEditorId, (String)classNoSourceEditorId);
        }
    }
}

