/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.ProjectPreferenceConstants;
import com.kms.katalon.composer.project.handlers.CloseProjectHandler;
import com.kms.katalon.composer.validation.mechanism.ValidationMechanism;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class QuitHandler
extends AbstractHandler {
    public boolean canExecute() {
        return true;
    }

    public void execute() {
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        return this.openConfirmMessageDialog();
    }

    @Execute
    public boolean openConfirmMessageDialog() {
        ScopedPreferenceStore prefs = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
        IWorkbench workbench = QuitHandler.getActiveWorkbench();
        MessageDialogWithToggle confirm = MessageDialogWithToggle.open((int)5, (Shell)workbench.getDisplay().getActiveShell(), (String)StringConstants.HAND_QUIT_DIA_TITLE, (String)StringConstants.HAND_QUIT_DIA_MSG, (String)StringConstants.HAND_QUIT_DIA_MSG_AUTO_RESTORE_SESSION, (boolean)prefs.getBoolean("general.autoRestorePreviousSession"), (IPreferenceStore)prefs, (String)"general.autoRestorePreviousSession", (int)0);
        if (confirm.getReturnCode() != 0) {
            return false;
        }
        try {
            ValidationMechanism.getInstance().closeValidationMechanism();
        }
        catch (Exception e1) {
            LoggerSingleton.logError((Throwable)e1);
        }
        EventBrokerSingleton.getInstance().getEventBroker().send("WORKSPACE/CLOSE", null);
        if (this.getPartService() != null && this.getPartService().saveAll(true)) {
            prefs.setValue("general.autoRestorePreviousSession", confirm.getToggleState());
            try {
                ((IPersistentPreferenceStore)prefs).save();
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            QuitHandler.saveLastestOpenedProject();
            this.eventBroker.send("PROJECT/CLOSE", null);
            return workbench.close();
        }
        return workbench.close();
    }

    private static void saveLastestOpenedProject() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        String projectLoc = project != null ? project.getId() : "";
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(CloseProjectHandler.class);
        store.setValue(ProjectPreferenceConstants.LATEST_OPENED_PROJECT, projectLoc);
        try {
            ((IPersistentPreferenceStore)store).save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

