/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.toolbar.PerspectiveSwitcher;
import com.kms.katalon.services.PerspectiveRestoreService;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.ToolItem;

public class ResetPerspectiveHandler
extends AbstractHandler {
    private static final String COMPATIBILITY_EDITOR_ID = "org.eclipse.e4.ui.compatibility.editor";
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    private MWindow window;
    private PerspectiveSwitcher switcher;

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.window = (MWindow)this.application.getChildren().get(0);
        MPerspective perspective = this.modelService.getActivePerspective(this.window);
        if (perspective == null) {
            return;
        }
        MToolControl toolControl = (MToolControl)this.modelService.find("com.kms.katalon.composer.toolbar.switcher", (MUIElement)this.application);
        this.switcher = (PerspectiveSwitcher)toolControl.getObject();
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.switcher.find("com.kms.katalon.composer.perspectiveStack", (MUIElement)this.window);
        IEclipseContext appContext = this.application.getContext();
        PerspectiveRestoreService restoreService = (PerspectiveRestoreService)appContext.get(PerspectiveRestoreService.class);
        if (perspective == null || perspectiveStack == null || restoreService == null) {
            return;
        }
        MPerspective cleanPerspective = restoreService.reloadPerspective(perspective.getElementId(), this.window);
        if (cleanPerspective == null || !perspective.equals(perspectiveStack.getSelectedElement())) {
            return;
        }
        IEclipseContext context = this.window.getContext();
        if (context == null) {
            context = appContext;
        }
        EPartService partService = (EPartService)context.get(EPartService.class);
        Collection parts = partService.getParts();
        MPartStack composerPartStack = (MPartStack)this.switcher.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        MPlaceholder area = (MPlaceholder)this.switcher.find("org.eclipse.ui.editorss", (MUIElement)this.application);
        List composerPartStackChildren = composerPartStack.getChildren();
        MPart firstVisibleTab = null;
        for (MPart p : parts) {
            String elementId = p.getElementId();
            if ((!elementId.startsWith("com.kms.katalon.composer.content.") || !elementId.endsWith(")")) && !COMPATIBILITY_EDITOR_ID.equals(elementId) || this.modelService.find(elementId, (MUIElement)area) != null) continue;
            composerPartStackChildren.add(p);
            if (!p.isVisible() || firstVisibleTab != null) continue;
            firstVisibleTab = p;
        }
        if (firstVisibleTab != null) {
            composerPartStack.setSelectedElement(firstVisibleTab);
        }
        MPart eventLogPart = partService.findPart("com.kms.katalon.part.eventLog");
        if ("com.kms.katalon.composer.perspective.keyword".equals(perspective.getElementId())) {
            MPart requestHistoryPart = partService.findPart("com.kms.katalon.composer.webservice.part.requestHistory");
            cleanPerspective.setToBeRendered(true);
            List perspectives = perspectiveStack.getChildren();
            int pIndex = perspectives.indexOf(perspective);
            perspectives.remove(pIndex);
            perspectives.add(pIndex, cleanPerspective);
            MPlaceholder expressionsPlaceholder = (MPlaceholder)this.switcher.find("com.kms.katalon.placeholder.eventLog", (MUIElement)cleanPerspective);
            if (eventLogPart != null) {
                expressionsPlaceholder.setRef((MUIElement)eventLogPart);
            }
            perspectiveStack.setSelectedElement((MUIElement)cleanPerspective);
            this.updatePerspectiveToolbar(pIndex, cleanPerspective);
            partService.switchPerspective(cleanPerspective);
            this.reselectParts(cleanPerspective, partService);
            MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.partstack.explorer", (MUIElement)this.application);
            if (requestHistoryPart != null) {
                stack.getChildren().add(requestHistoryPart);
            }
            this.eventBroker.post("EXPLORER/RELOAD_DATA", (Object)false);
            return;
        }
        if ("org.eclipse.debug.ui.DebugPerspective".equals(perspective.getElementId())) {
            this.switcher.reopenPartsIfClosed(perspective);
            this.relocatePartsBackIntoPosition(perspective);
        }
    }

    private void updatePerspectiveToolbar(int pIndex, MPerspective perspective) {
        ToolItem perspectiveItem = this.switcher.getToolbar().getItem(pIndex);
        perspectiveItem.setData((Object)perspective);
        perspectiveItem.setSelection(true);
    }

    private void reselectParts(MPerspective perspective, EPartService ps) {
        this.selectAndActivateChildPart(perspective, ps, "com.kms.katalon.partstack.left.outline", 0);
        this.selectAndActivateChildPart(perspective, ps, "com.kms.katalon.partstack.outline", 0);
        this.selectAndActivateChildPart(perspective, ps, "com.kms.katalon.composer.partstack.explorer", 0);
    }

    private void relocatePartsBackIntoPosition(MPerspective perspective) {
        MPartStack topLeftPartStack = (MPartStack)this.switcher.find("com.kms.katalon.partstack.debug.top.left", (MUIElement)perspective);
        MPlaceholder debugPlaceholder = (MPlaceholder)this.switcher.find("com.kms.katalon.placeholder.debug.top.debug", (MUIElement)perspective);
        this.relocatePartPlaceholder(topLeftPartStack, debugPlaceholder, -1);
        MPartStack topRightPartStack = (MPartStack)this.switcher.find("com.kms.katalon.partstack.debug.top.right", (MUIElement)perspective);
        MPlaceholder variablePlaceholder = (MPlaceholder)this.switcher.find("com.kms.katalon.placeholder.debug.top.variable", (MUIElement)perspective);
        this.relocatePartPlaceholder(topRightPartStack, variablePlaceholder, 0);
        MPlaceholder breakpointsPlaceholder = (MPlaceholder)this.switcher.find("com.kms.katalon.placeholder.debug.top.breakpoints", (MUIElement)perspective);
        this.relocatePartPlaceholder(topRightPartStack, breakpointsPlaceholder, 1);
        MPlaceholder expressionsPlaceholder = (MPlaceholder)this.switcher.find("com.kms.katalon.placeholder.debug.top.expressions", (MUIElement)perspective);
        this.relocatePartPlaceholder(topRightPartStack, expressionsPlaceholder, 2);
        MPartStack consolePartStack = (MPartStack)this.switcher.find("com.kms.katalon.partstack.console", (MUIElement)perspective);
        MPlaceholder consolePlaceholder = (MPlaceholder)this.switcher.find("org.eclipse.ui.console.ConsoleView", (MUIElement)perspective);
        this.relocatePartPlaceholder(consolePartStack, consolePlaceholder, -1);
    }

    private void relocatePartPlaceholder(MPartStack parentPartStack, MPlaceholder childPlaceholder, int childIndex) {
        if (childPlaceholder.getParent().equals(parentPartStack)) {
            return;
        }
        List children = parentPartStack.getChildren();
        if (childIndex == -1) {
            children.add(childPlaceholder);
            return;
        }
        children.add(childIndex, childPlaceholder);
    }

    private void selectAndActivateChildPart(MPerspective perspective, EPartService partService, String partStackId, int selectIndex) {
        MPartStack partStack = (MPartStack)this.switcher.find(partStackId, (MUIElement)perspective);
        if (partStack == null) {
            return;
        }
        List leftOutlineChildren = partStack.getChildren();
        if (leftOutlineChildren.isEmpty()) {
            return;
        }
        MStackElement part = (MStackElement)leftOutlineChildren.get(selectIndex);
        partStack.setSelectedElement((MUIElement)part);
        partService.activate((MPart)part);
    }
}

