/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.entity.project.ProjectEntity;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SaveHandler
extends AbstractHandler {
    public boolean canExecute() {
        MPart part = this.getPartService().getActivePart();
        if (this.getCompositeParentPart(part) != null) {
            return true;
        }
        if (part != null) {
            return part.isDirty();
        }
        return false;
    }

    private SavableCompositePart getCompositeParentPart(MPart part) {
        SavableCompositePart parentCompositePart = null;
        for (MPart dirtyPart : this.getPartService().getDirtyParts()) {
            SavableCompositePart compositePart;
            if (!(dirtyPart.getObject() instanceof SavableCompositePart) || (compositePart = (SavableCompositePart)dirtyPart.getObject()).getChildParts() == null || !compositePart.getChildParts().contains(part)) continue;
            return compositePart;
        }
        return parentCompositePart;
    }

    public void execute() {
        KSEFeatureAccessHandler.setDisplayed((boolean)false);
        MPart part = this.getPartService().getActivePart();
        try {
            SavableCompositePart parentCompositePart = this.getCompositeParentPart(part);
            if (parentCompositePart != null) {
                if (parentCompositePart.getChildParts().contains(part)) {
                    parentCompositePart.save();
                }
            } else if (GroovyEditorUtil.isGroovyEditorPart((MPart)part)) {
                GroovyEditorUtil.saveEditor((MPart)part);
                this.eventBroker.post("EDITORS_SAVED", (Object)part);
            } else {
                this.getPartService().savePart(part, false);
            }
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            project.setModifiedVersion(ApplicationInfo.versionNo());
            project.setModifiedEdition(ApplicationEdition.get());
            ProjectController.getInstance().updateProject(project);
            KSEFeatureAccessHandler.setDisplayed((boolean)false);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_SAVE_DIA_MSG);
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

