/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.helpers;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.core.event.EventEmitter;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.license.models.AuthenticationToken;
import com.kms.katalon.license.models.CombinedAuthenticationToken;
import com.kms.katalon.logging.LogUtil;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class SSOController {
    private static final String SSO_SERVER_PROPERTY_NAME = "ssoServerUrl";
    private static final String DEFAULT_SSO_SERVER = "https://login.katalon.com";
    private String ssoServer = "";
    private String realm = "katalon";
    private String clientId = "katalon-studio";
    private String loginRedirectUri = "";
    private String codeChallenge = "";
    private String codeVerifier = "";
    private EventEmitter emitter = new EventEmitter();
    private static SSOController instance;

    public List<SocialButton> resolveRawSocialButtons(String rawButtons, String universalLoginUrl) {
        List buttons = JsonUtil.fromJsonArray((String)rawButtons, SocialButton[].class);
        buttons.forEach(buttonI -> {
            buttonI.uri = this.getFinalSocialLoginUri(buttonI.idpId, universalLoginUrl);
        });
        return buttons;
    }

    public String getFinalSocialLoginUri(String idpId, String universalLoginUrl) {
        if (StringUtils.isBlank((CharSequence)idpId)) {
            return universalLoginUrl;
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(universalLoginUrl);
            uriBuilder.addParameter("kc_idp_hint", idpId);
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException error) {
            LogUtil.logError((Throwable)error);
            return universalLoginUrl;
        }
    }

    public String getSSOServer() {
        return (String)Strings.firstNonBlank((CharSequence[])new String[]{System.getProperty(SSO_SERVER_PROPERTY_NAME), this.ssoServer, DEFAULT_SSO_SERVER});
    }

    public SSOController setSSOServer(String authServer) {
        this.ssoServer = authServer;
        return this;
    }

    public String getRealm() {
        return this.realm;
    }

    public SSOController setRealm(String realm) {
        this.realm = realm;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public SSOController setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getRedirectUri() {
        return this.loginRedirectUri;
    }

    public SSOController setRedirectServer(String server) {
        try {
            URIBuilder redirectUri = new URIBuilder(server);
            redirectUri.setPath("/auth");
            this.loginRedirectUri = redirectUri.build().toString();
        }
        catch (URISyntaxException error) {
            LogUtil.logError((Throwable)error);
        }
        return this;
    }

    public SSOController setRedirectUri(String redirectUri) {
        this.loginRedirectUri = redirectUri;
        return this;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void onTokenGrabbed(TokenGrabbedListener listener) {
        this.emitter.on((Enum)SSOEventType.TOKEN_GRABBED, (EventEmitter.CustomEventListener)listener);
    }

    public void offTokenGrabbed(TokenGrabbedListener listener) {
        this.emitter.off((Enum)SSOEventType.TOKEN_GRABBED, (EventEmitter.CustomEventListener)listener);
    }

    public void notifyTokenGrabbed(String token) {
        this.emitter.emit((Enum)SSOEventType.TOKEN_GRABBED, (Object)token);
    }

    public void onCodeGrabbed(CodeGrabbedListener listener) {
        this.emitter.on((Enum)SSOEventType.CODE_GRABBED, (EventEmitter.CustomEventListener)listener);
    }

    public void offCodeGrabbed(CodeGrabbedListener listener) {
        this.emitter.off((Enum)SSOEventType.CODE_GRABBED, (EventEmitter.CustomEventListener)listener);
    }

    public void notifyCodeGrabbed(String code) {
        this.emitter.emit((Enum)SSOEventType.CODE_GRABBED, (Object)code);
    }

    public void onTokenError(TokenErrorListener listener) {
        this.emitter.on((Enum)SSOEventType.TOKEN_ERROR, (EventEmitter.CustomEventListener)listener);
    }

    public void offTokenError(TokenErrorListener listener) {
        this.emitter.off((Enum)SSOEventType.TOKEN_ERROR, (EventEmitter.CustomEventListener)listener);
    }

    public void notifyTokenError(Exception code) {
        this.emitter.emit((Enum)SSOEventType.TOKEN_ERROR, (Object)code);
    }

    public static SSOController getInstance() {
        if (instance == null) {
            instance = new SSOController();
        }
        return instance;
    }

    public void rollbackFailedSSOLogin() throws AnalyticsApiException {
        TestOpsService.getInstance().revokeAndClearAllTokens();
    }

    public String grabTokens(String code) throws AnalyticsApiException, URISyntaxException {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new AnalyticsApiException("Invalid authentication code");
        }
        URIBuilder uriBuilder = new URIBuilder(this.getSSOServer());
        uriBuilder.setPathSegments(new String[]{"realms", this.realm, "protocol", "openid-connect", "token"});
        TestOpsService testOpsService = TestOpsService.getInstance();
        testOpsService.grabKatOneToken(uriBuilder.build().toString(), code, this.codeVerifier, this.clientId, this.loginRedirectUri);
        testOpsService.grabAdminToken(testOpsService.getKatOneToken());
        ApplicationInfo.setAuthenticationInfo((CombinedAuthenticationToken)testOpsService.getCombinedToken());
        AuthenticationToken adminToken = testOpsService.getAdminToken();
        return adminToken.getAccessToken();
    }

    public String safeGenerateRegistrationUrl() {
        try {
            return this.generateRegistrationUrl();
        }
        catch (UnsupportedEncodingException | URISyntaxException | NoSuchAlgorithmException error) {
            LogUtil.logError((Throwable)error);
            return null;
        }
    }

    public String generateRegistrationUrl() throws UnsupportedEncodingException, NoSuchAlgorithmException, URISyntaxException {
        if (StringUtils.isBlank((CharSequence)this.codeChallenge)) {
            this.generateCode();
        }
        URIBuilder uriBuilder = new URIBuilder(this.getSSOServer());
        uriBuilder.setPathSegments(new String[]{"realms", this.realm, "login-actions", "registration"});
        uriBuilder.addParameter("client_id", this.clientId);
        uriBuilder.addParameter("redirect_uri", this.loginRedirectUri);
        uriBuilder.addParameter("response_type", "code");
        uriBuilder.addParameter("scope", "openid");
        uriBuilder.addParameter("code_challenge", this.codeChallenge);
        uriBuilder.addParameter("code_challenge_method", "S256");
        return uriBuilder.build().toString();
    }

    public String safeGenerateLoginUrl() {
        try {
            return this.generateLoginUrl();
        }
        catch (UnsupportedEncodingException | URISyntaxException | NoSuchAlgorithmException error) {
            LogUtil.logError((Throwable)error);
            return "";
        }
    }

    public String generateLoginUrl() throws UnsupportedEncodingException, NoSuchAlgorithmException, URISyntaxException {
        this.generateCode();
        URIBuilder uriBuilder = new URIBuilder(this.getSSOServer());
        uriBuilder.setPathSegments(new String[]{"realms", this.realm, "protocol", "openid-connect", "auth"});
        uriBuilder.addParameter("client_id", this.clientId);
        uriBuilder.addParameter("redirect_uri", this.loginRedirectUri);
        uriBuilder.addParameter("response_type", "code");
        uriBuilder.addParameter("scope", "openid");
        uriBuilder.addParameter("code_challenge", this.codeChallenge);
        uriBuilder.addParameter("code_challenge_method", "S256");
        return uriBuilder.build().toString();
    }

    protected void generateCode() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        this.codeVerifier = this.generateCodeVerifier();
        this.codeChallenge = this.generateCodeChallange(this.codeVerifier);
    }

    protected String generateCodeVerifier() throws UnsupportedEncodingException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] codeVerifier = new byte[32];
        secureRandom.nextBytes(codeVerifier);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(codeVerifier);
    }

    protected String generateCodeChallange(String codeVerifier) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] bytes = codeVerifier.getBytes("US-ASCII");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(bytes, 0, bytes.length);
        byte[] digest = messageDigest.digest();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }

    public static interface CodeGrabbedListener
    extends EventEmitter.CustomEventListener<String> {
        public void call(String var1);
    }

    private static enum SSOEventType {
        CODE_GRABBED,
        TOKEN_GRABBED,
        TOKEN_ERROR;

    }

    public static interface ServerChangeListener
    extends EventEmitter.CustomEventListener<String> {
        public void call(String var1);
    }

    public class SocialButton {
        public String name;
        public String image;
        public String uri;
        public String idpId;
    }

    public static interface TokenErrorListener
    extends EventEmitter.CustomEventListener<Exception> {
        public void call(Exception var1);
    }

    public static interface TokenGrabbedListener
    extends EventEmitter.CustomEventListener<String> {
        public void call(String var1);
    }
}

