/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import java.text.MessageFormat;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class WelcomeLeftPart
extends Composite {
    private static final String RELEASE_NOTES_URL = MessageConstants.RELEASE_NOTES_URL;
    private static final Cursor CURSOR_HAND = Display.getDefault().getSystemCursor(21);
    private static final int MIN_WIDTH = 300;
    private static final Color BACKGROUND_COLOR = ColorUtil.getColor((String)"#70746F");
    private static final Color PLUGIN_STORE_ITEM_BACKGROUND_COLOR = ColorUtil.getColor((String)"#FFD966");
    private Composite headerComposite;
    private Label lblVersion;
    private Composite licenseComposite;
    private Composite tutComposite;
    private Composite helpCenterComposite;
    private Composite pluginComposite;
    private Composite forumComposite;
    private Composite chatroomComposite;
    private Composite feedbackComposite;
    private Composite supportportalComposite;

    public WelcomeLeftPart(Composite parent, int style) {
        super(parent, style);
        this.setBackground(BACKGROUND_COLOR);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.createBrandingControls();
        this.createQuickHelpMenu();
    }

    private void createBrandingControls() {
        Composite upperComposite = new Composite((Composite)this, 0);
        upperComposite.setLayout((Layout)new GridLayout());
        GridData gd_upperComposite = new GridData(4, 0x1000000, true, false);
        gd_upperComposite.minimumWidth = 300;
        upperComposite.setLayoutData((Object)gd_upperComposite);
        this.headerComposite = new Composite(upperComposite, 0);
        this.headerComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        RowLayout rlHeaderComposite = new RowLayout(512);
        rlHeaderComposite.spacing = 20;
        rlHeaderComposite.marginHeight = 40;
        rlHeaderComposite.center = true;
        this.headerComposite.setLayout((Layout)rlHeaderComposite);
        this.headerComposite.setBackground(BACKGROUND_COLOR);
        Label lblLogo = new Label(this.headerComposite, 0);
        lblLogo.setAlignment(0x1000000);
        lblLogo.setImage(ImageConstants.IMG_BRANDING);
        this.lblVersion = new Label(this.headerComposite, 0);
        ControlUtils.setFontSize((Control)this.lblVersion, (int)14);
        this.lblVersion.setText(MessageFormat.format(MessageConstants.PA_LBL_KATALON_VERSION, ApplicationInfo.versionNo()));
        this.lblVersion.setForeground(ColorUtil.getTextWhiteColor());
        Link lblReleaseNote = new Link(this.headerComposite, 0);
        ControlUtils.setFontStyle((Control)lblReleaseNote, (int)2, (int)12);
        lblReleaseNote.setText(RELEASE_NOTES_URL);
        lblReleaseNote.setLinkForeground(ColorUtil.getColor((String)"#4DE1FF"));
        lblReleaseNote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
        Composite outsideLicenseComposite = new Composite(this.headerComposite, 0);
        outsideLicenseComposite.setLayout((Layout)new GridLayout());
        outsideLicenseComposite.setLayoutData((Object)new RowData());
        this.licenseComposite = this.addMenuItem(outsideLicenseComposite, ImageConstants.IMG_KATALON_SUBSCRIPTION_24, MessageConstants.PA_LBL_LICENSE, MessageConstants.PA_URL_LICENSE, null, ColorUtil.getTextWhiteColor());
    }

    private void createQuickHelpMenu() {
        Composite lowerComposite = new Composite((Composite)this, 0);
        GridLayout glLowerComposite = new GridLayout(2, true);
        glLowerComposite.marginHeight = 0;
        glLowerComposite.marginWidth = 0;
        lowerComposite.setLayout((Layout)glLowerComposite);
        GridData gdLowerComposite = new GridData(4, 4, true, true);
        gdLowerComposite.minimumWidth = 300;
        lowerComposite.setLayoutData((Object)gdLowerComposite);
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        String feedbackUrl = MessageFormat.format(StringConstants.PA_LBL_FEEDBACK_URL, userProfile.getEmail());
        this.tutComposite = this.addMenuItem(lowerComposite, ImageConstants.IMG_TUTORIAL, MessageConstants.PA_LBL_TUTORIALS, MessageConstants.PA_LBL_TUTORIALS_URL, null, ColorUtil.getTextWhiteColor());
        this.helpCenterComposite = this.addMenuItem(lowerComposite, ImageConstants.IMG_HELP_CENTER, StringConstants.PA_LBL_HELP_CENTER, StringConstants.PA_LBL_HELP_CENTER_URL, null, ColorUtil.getTextWhiteColor());
        this.pluginComposite = this.addMenuItem(lowerComposite, ImageConstants.IMG_KATALON_STORE, StringConstants.PA_LBL_PLUGIN_STORE, StringConstants.PA_LBL_PLUGIN_STORE_URL, null, ColorUtil.getTextWhiteColor());
        this.forumComposite = this.addMenuItem(lowerComposite, ImageConstants.KATALON_FORUM_24, StringConstants.PA_LBL_FORUM, StringConstants.PA_LBL_FORUM_URL, null, ColorUtil.getTextWhiteColor());
        this.chatroomComposite = this.addMenuItem(lowerComposite, ImageConstants.KATALON_CHAT_24, StringConstants.PA_LBL_CHATROOM, StringConstants.PA_LBL_CHATROOM_URL, null, ColorUtil.getTextWhiteColor());
        this.feedbackComposite = this.addMenuItem(lowerComposite, ImageConstants.KATALON_FEEDBACK_24, StringConstants.PA_LBL_FEEDBACK, feedbackUrl, null, ColorUtil.getTextWhiteColor());
        this.supportportalComposite = this.addMenuItem(lowerComposite, ImageConstants.KATALON_SUPPORT_PORTAL_24, StringConstants.PA_LBL_SUPPORT_PORTAL, StringConstants.PA_LBL_SUPPORT_PORTAL_URL, null, ColorUtil.getTextWhiteColor());
    }

    private Composite addMenuItem(Composite parent, Image icon, String label, final String url, Color backgroundColor, Color foregroundColor) {
        Composite holder = new Composite(parent, 0);
        GridData gdHolder = new GridData(4, 4, true, false);
        holder.setLayoutData((Object)gdHolder);
        if (backgroundColor != null) {
            holder.setBackground(backgroundColor);
        }
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 20;
        gl.marginHeight = 10;
        holder.setLayout((Layout)gl);
        holder.setCursor(CURSOR_HAND);
        Label menuImage = new Label(holder, 0);
        GridData layoutData = new GridData(16384, 0x1000000, false, true);
        menuImage.setLayoutData((Object)layoutData);
        menuImage.setImage(icon);
        Label menuItem = new Label(holder, 0);
        menuItem.setAlignment(0x1000000);
        menuItem.setText(label);
        menuItem.setCursor(CURSOR_HAND);
        if (menuItem != null) {
            menuItem.setForeground(foregroundColor);
        }
        ControlUtils.setFontSize((Control)menuItem, (int)12);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                WelcomeLeftPart.this.openURL(url);
            }
        };
        menuItem.addMouseListener((MouseListener)mouseAdapter);
        menuImage.addMouseListener((MouseListener)mouseAdapter);
        holder.addMouseListener((MouseListener)mouseAdapter);
        return holder;
    }

    private void openURL(String url) {
        Program.launch((String)url);
    }

    protected void checkSubclass() {
    }

    public void updateColor() {
        this.setBackground(BACKGROUND_COLOR);
        this.headerComposite.setBackground(BACKGROUND_COLOR);
        this.lblVersion.setForeground(ColorUtil.getTextWhiteColor());
        ControlUtils.recursivelySetColor((Control)this.licenseComposite, (Color)ColorUtil.getTextWhiteColor(), null);
        ControlUtils.recursivelySetColor((Control)this.helpCenterComposite, (Color)ColorUtil.getTextWhiteColor(), null);
        ControlUtils.recursivelySetColor((Control)this.tutComposite, (Color)ColorUtil.getTextWhiteColor(), null);
        ControlUtils.recursivelySetColor((Control)this.pluginComposite, (Color)ColorUtil.getTextBlackColor(), null);
        ControlUtils.recursivelySetColor((Control)this.forumComposite, (Color)ColorUtil.getTextBlackColor(), null);
        ControlUtils.recursivelySetColor((Control)this.chatroomComposite, (Color)ColorUtil.getTextBlackColor(), null);
        ControlUtils.recursivelySetColor((Control)this.feedbackComposite, (Color)ColorUtil.getTextBlackColor(), null);
    }
}

