/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.composer.components.impl.control.ScrollableComposite;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.parts.WelcomeLeftPart;
import com.kms.katalon.composer.parts.WelcomeRightPart;
import com.kms.katalon.constants.StringConstants;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WelcomePart {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    private MPart part;
    private Composite mainComposite;
    private WelcomeRightPart startPageContent;
    private WelcomeLeftPart leftComposite;

    @PostConstruct
    public void initialize(Composite parent, MPart part) {
        this.part = part;
        this.createControls(parent);
        this.registerEventListeners();
        this.eventBroker.subscribe("org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged", new EventHandler(){

            public void handleEvent(Event event) {
                WelcomePart.this.leftComposite.updateColor();
            }
        });
    }

    private void showThisPart() {
        IPreferenceStore prefStore = PlatformUI.getPreferenceStore();
        if (!prefStore.contains("general.showHelpAtStartUp")) {
            prefStore.setDefault("general.showHelpAtStartUp", true);
        }
        if (!prefStore.getBoolean("general.showHelpAtStartUp")) {
            this.partService.hidePart(this.part);
        }
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("PROJECT/OPENED", new EventHandler(){

            public void handleEvent(Event event) {
                WelcomePart.this.showThisPart();
            }
        });
    }

    private void createControls(Composite parent) {
        FillLayout parentLayout = new FillLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parent.setLayout((Layout)parentLayout);
        final ScrollableComposite container = new ScrollableComposite(parent, 768);
        this.mainComposite = new Composite((Composite)container, 0);
        this.mainComposite.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.mainComposite.setBackgroundMode(2);
        GridLayout mainGridLayout = new GridLayout(2, false);
        mainGridLayout.verticalSpacing = 0;
        mainGridLayout.horizontalSpacing = 0;
        mainGridLayout.marginWidth = 0;
        mainGridLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)mainGridLayout);
        this.mainComposite.addListener(9, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                Point size = WelcomePart.this.mainComposite.computeSize(-1, -1);
                if (container.getMinHeight() < size.y) {
                    container.setMinHeight(size.y);
                }
            }
        });
        container.setContent((Control)this.mainComposite);
        container.setMinSize(new Point(900, 1300));
        container.setExpandHorizontal(true);
        container.setExpandVertical(true);
        this.leftComposite = new WelcomeLeftPart(this.mainComposite, 0);
        this.leftComposite.setLayoutData(new GridData(16384, 4, false, true));
        Composite rightComposite = new Composite(this.mainComposite, 0);
        GridLayout glRightComposite = new GridLayout(3, false);
        glRightComposite.marginHeight = 0;
        glRightComposite.marginWidth = 0;
        glRightComposite.marginTop = 40;
        glRightComposite.horizontalSpacing = 0;
        glRightComposite.verticalSpacing = 0;
        rightComposite.setLayout((Layout)glRightComposite);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addSpacer(rightComposite);
        this.startPageContent = new WelcomeRightPart(rightComposite, 0, StringConstants.PA_WELCOME_RIGHT_PART_LINK);
        GridData gdStartPageContent = new GridData(4, 4, true, true);
        gdStartPageContent.minimumWidth = 600;
        this.startPageContent.setLayoutData(gdStartPageContent);
        this.addSpacer(rightComposite);
    }

    private void addSpacer(Composite rightComposite) {
        Label spacer = new Label(rightComposite, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    @Focus
    public void setFocus() {
        if (this.mainComposite != null) {
            this.mainComposite.forceFocus();
        }
    }

    @PreDestroy
    public void onPartClosed() {
        if (this.startPageContent != null) {
            this.startPageContent.onPartClosed();
        }
    }
}

