/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.StyleUtil;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.license.models.LicenseType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class WelcomeTopPart
extends Composite {
    private static final Color BLUE = ColorUtil.getColor((String)"#0233F0");
    private static final Color ROYAL_BLUE = ColorUtil.getColor((String)"#2452f2");
    private static final Color OLIVE_DRAB = ColorUtil.getColor((String)"#53b10c");
    private static final Color DARK_ORANGE = ColorUtil.getColor((String)"#ff9014");
    private static final String HELP_CENTER_URL = "https://www.katalon.com/help-center";
    private static final String STORE_URL = "https://store.katalon.com";
    private static final String TUTORIAL_URL = "https://docs.katalon.com/katalon-studio/docs/overview.html";
    private static final String PRICING_URL = "https://www.katalon.com/pricing";
    private static final String SIGNUP_URL = "https://www.katalon.com/sign-up";
    private static LicenseType licenseType;
    private Image logo;
    private String welcomeMessage;
    private String licenseInformation;
    private String callToAction;
    private String ctaUrl = "https://www.katalon.com/pricing";
    private Color txtColor = ColorUtil.getTextWhiteColor();
    private Composite middleComposite;
    private GridData middleGd;
    private boolean isTrialExpired;

    public WelcomeTopPart(final Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 15;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = 1000;
        layoutData.heightHint = 117;
        this.setLayoutData(layoutData);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StyleUtil.setupGC((GC)e.gc);
                e.gc.setBackground(BLUE);
                e.gc.fillRoundRectangle(0, 0, parent.getBounds().width - 32, 117, 35, 35);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (parent.getBounds().width < 900) {
                    WelcomeTopPart.this.middleComposite.setVisible(false);
                    WelcomeTopPart.this.middleGd.exclude = true;
                } else {
                    WelcomeTopPart.this.middleComposite.setVisible(true);
                    WelcomeTopPart.this.middleGd.exclude = false;
                }
            }
        });
        licenseType = ActivationInfoCollector.getLicenseType();
        this.computeValuesBasedOnLicenseType();
        this.createWelcomeComposite();
        this.createMiddleComposite();
        if (licenseType != LicenseType.ENTERPRISE) {
            this.createCtaComposite();
        }
    }

    private void computeValuesBasedOnLicenseType() {
        switch (licenseType) {
            case ENTERPRISE: {
                this.welcomeMessage = StringConstants.WelcomeTopPart_KSE_WELCOME_MSG;
                this.logo = ImageConstants.IMG_BRANDING_KSE;
                this.licenseInformation = StringConstants.WelcomeTopPart_KSE_INFO;
                break;
            }
            case FREE: {
                this.welcomeMessage = StringConstants.WelcomeTopPart_KS_WELCOME_MSG;
                this.logo = ImageConstants.IMG_BRANDING_KS;
                String d = this.getExpirationDate();
                if (d != null) {
                    this.isTrialExpired = true;
                    this.licenseInformation = MessageFormat.format(StringConstants.WelcomeTopPart_FREE_BUSINESS_INFO, d);
                    this.callToAction = StringConstants.WelcomeTopPart_FREE_BUSINESS_CTA;
                    this.txtColor = DARK_ORANGE;
                    break;
                }
                this.licenseInformation = StringConstants.WelcomeTopPart_FREE_PERSONAL_INFO;
                this.callToAction = StringConstants.WelcomeTopPart_FREE_PERSONAL_CTA;
                this.ctaUrl = SIGNUP_URL;
                break;
            }
            case TRIAL: {
                this.welcomeMessage = StringConstants.WelcomeTopPart_KSE_WELCOME_MSG;
                this.logo = ImageConstants.IMG_BRANDING_KSE;
                this.licenseInformation = MessageFormat.format(StringConstants.WelcomeTopPart_TRIAL_INFO, this.getRemainingDays(this.getExpirationDate()));
                this.callToAction = StringConstants.WelcomeTopPart_TRIAL_CTA;
            }
        }
    }

    private int getRemainingDays(String expirationDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyy");
        try {
            Date expDate = formatter.parse(expirationDate);
            long diff = expDate.getTime() - new Date().getTime();
            return (int)TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
        }
        catch (ParseException e) {
            LogUtil.logError((Throwable)e);
            return 0;
        }
    }

    private String getExpirationDate() {
        if (ActivationInfoCollector.isLicenseOffline()) {
            return ActivationInfoCollector.getExpirationDate();
        }
        Date expDate = ApplicationContext.getInstance().getExpirationTrial();
        if (expDate == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyy");
        return formatter.format(expDate);
    }

    private void createWelcomeComposite() {
        Composite whole = new Composite((Composite)this, 0);
        whole.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        whole.setBackground(BLUE);
        GridLayout wholeLayout = new GridLayout(2, false);
        wholeLayout.marginWidth = 0;
        wholeLayout.horizontalSpacing = 11;
        whole.setLayout((Layout)wholeLayout);
        Label left = new Label(whole, 0);
        left.setImage(this.logo);
        Composite right = new Composite(whole, 0);
        GridLayout rightLayout = new GridLayout();
        rightLayout.marginWidth = 0;
        rightLayout.verticalSpacing = 3;
        right.setLayout((Layout)rightLayout);
        GridData rightGridData = new GridData();
        rightGridData.verticalAlignment = 2;
        right.setLayoutData((Object)rightGridData);
        Label msg = new Label(right, 0);
        msg.setText(this.welcomeMessage);
        msg.setForeground(ColorUtil.getTextWhiteColor());
        ControlUtils.setFontSize((Control)msg, (int)16);
        Label ver = new Label(right, 0);
        ver.setText(MessageFormat.format(MessageConstants.PA_LBL_KATALON_VERSION, ApplicationInfo.versionNo()));
        ver.setForeground(ColorUtil.getTextWhiteColor());
        ControlUtils.setFontSize((Control)ver, (int)12);
    }

    private void createMiddleComposite() {
        this.middleComposite = new Composite((Composite)this, 0);
        this.middleComposite.setBackground(BLUE);
        this.middleGd = new GridData(0x1000000, 0x1000000, true, false);
        this.middleComposite.setLayoutData((Object)this.middleGd);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 10;
        this.middleComposite.setLayout((Layout)gl);
        Label lbl = new Label(this.middleComposite, 64);
        lbl.setAlignment(0x1000000);
        lbl.setLayoutData((Object)new GridData(0x1000000, 0x1000008, true, true));
        ControlUtils.setFontStyle((Control)lbl, (int)3, (int)12);
        lbl.setText(this.licenseInformation);
        lbl.setForeground(this.txtColor);
        Composite btnGroup = new Composite(this.middleComposite, 0);
        btnGroup.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        RowLayout rl = new RowLayout();
        rl.spacing = 12;
        btnGroup.setLayout((Layout)rl);
        ComponentBuilder.label((Composite)btnGroup).text(StringConstants.WelcomeTopPart_HELP_CENTER).fontSize(12).autoSize(87, 30).primaryButton2().border(1, ROYAL_BLUE).background(BLUE).onClick(event -> {
            Trackings.trackStartPageAreaClicked((String)"helpcenter");
            this.openURL(HELP_CENTER_URL);
        }).build();
        ComponentBuilder.label((Composite)btnGroup).text(StringConstants.WelcomeTopPart_PLUGINS_STORE).fontSize(12).autoSize(96, 30).primaryButton2().border(1, ROYAL_BLUE).background(BLUE).onClick(event -> {
            Trackings.trackStartPageAreaClicked((String)"plugins_store");
            this.openURL(STORE_URL);
        }).build();
        ComponentBuilder.label((Composite)btnGroup).text(StringConstants.WelcomeTopPart_TUTORIALS).fontSize(12).autoSize(72, 30).primaryButton2().border(1, ROYAL_BLUE).background(BLUE).onClick(event -> {
            Trackings.trackStartPageAreaClicked((String)"tutorials");
            this.openURL(TUTORIAL_URL);
        }).build();
    }

    private void createCtaComposite() {
        Composite cta = new Composite((Composite)this, 0);
        cta.setBackground(BLUE);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        cta.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        cta.setLayoutData((Object)gd);
        if (licenseType == LicenseType.FREE && !this.isTrialExpired) {
            CustomDrawnCanvas buttonCanvas = new CustomDrawnCanvas(cta, 0, 1, 5, BLUE, OLIVE_DRAB, BLUE, OLIVE_DRAB, Display.getCurrent().getSystemCursor(21)){
                private Label lblCallToAction;

                @Override
                protected void createContent(Composite parent) {
                    parent.setLayout((Layout)new GridLayout());
                    this.lblCallToAction = new Label(parent, 64);
                    this.lblCallToAction.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
                    this.lblCallToAction.setText(WelcomeTopPart.this.callToAction);
                    this.lblCallToAction.setForeground(ColorUtil.getTextWhiteColor());
                    this.lblCallToAction.setAlignment(0x1000000);
                }
            };
            GridData gdCanvas = new GridData(131072, 0x1000000, false, false);
            gdCanvas.widthHint = 220;
            buttonCanvas.setLayoutData(gdCanvas);
            buttonCanvas.setBackground(BLUE);
            ControlUtils.recursivelyAddMouseListener((Control)buttonCanvas, (MouseAdapter)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Trackings.trackStartPageAreaClicked((String)"subscribe");
                    WelcomeTopPart.this.openURL(WelcomeTopPart.this.ctaUrl);
                }
            });
        } else {
            ComponentBuilder.label((Composite)cta).text(this.callToAction).fontSize(12).size(105, 30).primaryButton2().background(OLIVE_DRAB).onClick(event -> {
                Trackings.trackStartPageAreaClicked((String)"subscribe");
                this.openURL(this.ctaUrl);
            }).build();
        }
    }

    protected void checkSubclass() {
    }

    private void openURL(String url) {
        Program.launch((String)url);
    }

    private static abstract class CustomDrawnCanvas
    extends Canvas {
        private static final Color COMPOSITE_COLOR = ColorUtil.getColor((String)"#F5F6F5");
        private boolean isHovered;
        private int borderWidth;
        private int borderRadius;
        private Color borderColor;
        private Color backgroundColor;
        private Color hoverBorderColor;
        private Color hoverBackgroundColor;
        private Cursor cursor;
        private Canvas self = this;

        public CustomDrawnCanvas(Composite parent, int style, int borderWidth, int borderRadius, Color borderColor, Color backgroundColor, Color hoverBorderColor, Color hoverBackgroundColor, Cursor cursor) {
            super(parent, style);
            this.borderWidth = borderWidth;
            this.borderRadius = borderRadius;
            this.borderColor = borderColor;
            this.backgroundColor = backgroundColor;
            this.hoverBorderColor = hoverBorderColor;
            this.hoverBackgroundColor = hoverBackgroundColor;
            this.cursor = cursor;
            this.createContent((Composite)this);
            this.setBackground(COMPOSITE_COLOR);
            ComponentUtil.setChildrenBackgroundColor((Composite)this, (Color)backgroundColor);
            this.registerListeners();
        }

        protected abstract void createContent(Composite var1);

        private void registerListeners() {
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Point rect = this.getSize();
                    if (isHovered) {
                        this.drawRectangle(gc, rect.x, rect.y, borderWidth, borderRadius, hoverBorderColor, hoverBackgroundColor);
                    } else {
                        this.drawRectangle(gc, rect.x, rect.y, borderWidth, borderRadius, borderColor, backgroundColor);
                    }
                }
            });
            ControlUtils.recursivelyAddMouseTrackListener((Control)this, (MouseTrackListener)new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    isHovered = true;
                    this.setCursor(cursor);
                    this.redraw();
                    ComponentUtil.setChildrenBackgroundColor((Composite)self, (Color)hoverBackgroundColor);
                }

                public void mouseExit(MouseEvent e) {
                    isHovered = false;
                    this.redraw();
                    ComponentUtil.setChildrenBackgroundColor((Composite)self, (Color)backgroundColor);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
        }

        private void drawRectangle(GC gc, int width, int height, int borderWidth, int borderRadius, Color borderColor, Color backgroundColor) {
            if (borderColor != null) {
                gc.setForeground(borderColor);
                gc.setLineWidth(borderWidth);
                gc.drawRoundRectangle(0, 0, width - borderWidth, height - borderWidth, borderRadius, borderRadius);
            }
            if (backgroundColor != null) {
                gc.setBackground(backgroundColor);
                gc.fillRoundRectangle(borderWidth, borderWidth, width - 2 * borderWidth, height - 2 * borderWidth, borderRadius, borderRadius);
            }
        }
    }
}

