/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.preferences;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import javax.inject.Inject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GeneralPreferencePage
extends PreferencePage {
    private Button radioAutoRestorePrevSession;
    private Button radioAutoCleanPrevSession;
    private Button chkCheckNewVersion;
    private Button chkCheckAllowUsageTracking;
    private Button chkShowHelpAtStartUp;
    private Button chkReceiveDynamicContentNotifications;
    private Button chkShowStartPageContents;
    private Composite parentComposite;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    @Inject
    private IEventBroker eventBroker;

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.parentComposite = new Composite(parent, 0);
        this.parentComposite.setLayout((Layout)layout);
        Group prevSession = new Group(this.parentComposite, 4);
        prevSession.setText(StringConstants.PAGE_GRP_ON_NEXT_STARTING_APP);
        prevSession.setLayout((Layout)new GridLayout(1, false));
        prevSession.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.radioAutoRestorePrevSession = new Button((Composite)prevSession, 16);
        this.radioAutoRestorePrevSession.setText(StringConstants.PAGE_RADIO_AUTO_RESTORE_PREV_SESSION);
        this.radioAutoCleanPrevSession = new Button((Composite)prevSession, 16);
        this.radioAutoCleanPrevSession.setText(StringConstants.PAGE_RADIO_AUTO_CLEAN_PREV_SESSION);
        this.chkShowHelpAtStartUp = this.createCheckBox(this.parentComposite, MessageConstants.PAGE_PREF_SHOW_HELP_AT_START_UP, null);
        this.chkCheckNewVersion = this.createCheckBox(this.parentComposite, MessageConstants.PAGE_PREF_AUTO_CHECK_NEW_VERSION_TITLE, null);
        this.chkCheckAllowUsageTracking = this.createCheckBox(this.parentComposite, MessageConstants.PAGE_PREF_AUTO_ALLOW_USAGE_TRACKING, MessageConstants.PAGE_PREF_AUTO_ALLOW_USAGE_TRACKING_TOOLTIPS);
        this.chkReceiveDynamicContentNotifications = this.createCheckBox(this.parentComposite, MessageConstants.PAGE_PREF_RECEIVE_DYNAMIC_CONTENT_NOTIFICATIONS, MessageConstants.PAGE_PREF_RECEIVE_DYNAMIC_CONTENT_NOTIFICATIONS_TOOLTIPS);
        this.chkShowStartPageContents = this.createCheckBox(this.parentComposite, MessageConstants.PAGE_PREF_SHOW_START_PAGE_CONTENTS, MessageConstants.PAGE_PREF_SHOW_START_PAGE_CONTENTS_TOOLTIPS);
        this.initialize();
        return this.parentComposite;
    }

    public Button createCheckBox(Composite parent, String checkBoxTitle, final String toolTipContent) {
        Composite wrapComposite = new Composite(parent, 0);
        RowLayout wrapCompositeLayout = new RowLayout();
        wrapCompositeLayout.marginLeft = 0;
        wrapComposite.setLayout((Layout)wrapCompositeLayout);
        Button checkBox = new Button(wrapComposite, 32);
        checkBox.setText(checkBoxTitle);
        if (toolTipContent == null) {
            return checkBox;
        }
        final Label tooltipsButton = new Label(wrapComposite, 0);
        tooltipsButton.setImage(ImageManager.getImage((String)"info_16.png"));
        if ("linux".equals(Platform.getOS())) {
            tooltipsButton.setToolTipText(toolTipContent);
        } else {
            tooltipsButton.addMouseTrackListener(new MouseTrackListener(){
                private Shell popup;
                private Shell chevron;
                private boolean isDarkMode = ComponentBundleActivator.isDarkTheme((Display)Display.getCurrent());

                public void mouseEnter(MouseEvent e) {
                    if (this.chevron != null) {
                        this.chevron.setVisible(true);
                    }
                    if (this.popup != null) {
                        this.popup.setVisible(true);
                        return;
                    }
                    this.chevron = new Shell(tooltipsButton.getShell(), 16392);
                    this.chevron.setLayout((Layout)new FillLayout());
                    Label chevronLabel = new Label((Composite)this.chevron, 0);
                    if (!this.isDarkMode) {
                        chevronLabel.setImage(ImageManager.getImage((String)"chevron_down_comment.png"));
                    }
                    this.chevron.setSize(chevronLabel.computeSize(-1, -1));
                    this.chevron.setLocation(tooltipsButton.toDisplay((int)2, (int)18).x, tooltipsButton.toDisplay((int)2, (int)18).y);
                    this.popup = new Shell(tooltipsButton.getShell(), 16392);
                    this.popup.setLayout((Layout)new FillLayout());
                    Composite mainComposite = new Composite((Composite)this.popup, 2048);
                    mainComposite.setLayoutData((Object)new GridData(1808));
                    mainComposite.setLayout((Layout)new GridLayout());
                    mainComposite.setBackground(Display.getCurrent().getSystemColor(1));
                    Label toolTips = new Label(mainComposite, 0);
                    toolTips.setText(GeneralPreferencePage.this.wrapMessage(toolTipContent));
                    toolTips.setBackground(Display.getCurrent().getSystemColor(1));
                    this.popup.setSize(mainComposite.computeSize(265, -1));
                    this.popup.setLocation(this.chevron.toDisplay((int)-10, (int)0).x, this.chevron.toDisplay((int)-10, (int)5).y);
                    this.chevron.moveAbove((Control)this.popup);
                    this.chevron.setVisible(true);
                    this.popup.setVisible(true);
                }

                public void mouseExit(MouseEvent e) {
                    if (this.chevron != null && this.chevron.isVisible()) {
                        this.chevron.setVisible(false);
                    }
                    if (this.popup != null && this.popup.isVisible()) {
                        this.popup.setVisible(false);
                    }
                }

                public void mouseHover(MouseEvent e) {
                    if (this.chevron != null && !this.chevron.isVisible()) {
                        this.chevron.setVisible(true);
                    }
                    if (this.popup != null && !this.popup.isVisible()) {
                        this.popup.setVisible(true);
                    }
                }
            });
        }
        return checkBox;
    }

    private String wrapMessage(String message) {
        int maxCharacters = 50;
        if (message.length() <= maxCharacters) {
            return message;
        }
        int positionToBreak = this.findBreakBefore(message, maxCharacters);
        if (positionToBreak == -1) {
            positionToBreak = maxCharacters;
        }
        return String.valueOf(message.substring(0, positionToBreak).trim()) + "\n" + this.wrapMessage(message.substring(positionToBreak).trim());
    }

    private int findBreakBefore(String line, int start) {
        int i = start;
        while (i >= 0) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) || c == '-') {
                return i;
            }
            --i;
        }
        return -1;
    }

    public IPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
    }

    private void initialize() {
        IPreferenceStore prefStore = this.getPreferenceStore();
        boolean autoRestore = prefStore.getBoolean("general.autoRestorePreviousSession");
        this.radioAutoRestorePrevSession.setSelection(autoRestore);
        this.radioAutoCleanPrevSession.setSelection(!autoRestore);
        boolean setCheckNewVersion = prefStore.contains("general.autoCheckNewVersion");
        this.chkCheckNewVersion.setSelection(setCheckNewVersion ? prefStore.getBoolean("general.autoCheckNewVersion") : true);
        if (!setCheckNewVersion) {
            prefStore.setDefault("general.autoCheckNewVersion", true);
        }
        if (!prefStore.contains("general.showHelpAtStartUp")) {
            prefStore.setDefault("general.showHelpAtStartUp", true);
        }
        this.chkShowHelpAtStartUp.setSelection(prefStore.getBoolean("general.showHelpAtStartUp"));
        boolean canConfigUsageTracking = this.featureService.canUse(KSEFeature.CONFIGURE_USAGE_TRACKING);
        if (canConfigUsageTracking) {
            if (!prefStore.contains("general.autoCheckAllowUsage_Tracking")) {
                prefStore.setDefault("general.autoCheckAllowUsage_Tracking", true);
            }
            this.chkCheckAllowUsageTracking.setSelection(prefStore.getBoolean("general.autoCheckAllowUsage_Tracking"));
        } else {
            this.chkCheckAllowUsageTracking.setSelection(true);
            this.chkCheckAllowUsageTracking.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CONFIGURE_USAGE_TRACKING);
                    GeneralPreferencePage.this.chkCheckAllowUsageTracking.setSelection(true);
                }
            });
        }
        boolean canConfigReceiveDynamicContentNotifications = this.featureService.canUse(KSEFeature.CONFIGURE_RECEIVE_DYNAMIC_CONTENT_NOTIFICATIONS);
        if (canConfigReceiveDynamicContentNotifications) {
            if (!prefStore.contains("general.receiveDynamicContentNotifications")) {
                prefStore.setDefault("general.receiveDynamicContentNotifications", true);
            }
            this.chkReceiveDynamicContentNotifications.setSelection(prefStore.getBoolean("general.receiveDynamicContentNotifications"));
        } else {
            this.chkReceiveDynamicContentNotifications.setSelection(true);
            this.chkReceiveDynamicContentNotifications.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CONFIGURE_RECEIVE_DYNAMIC_CONTENT_NOTIFICATIONS);
                    GeneralPreferencePage.this.chkReceiveDynamicContentNotifications.setSelection(true);
                }
            });
        }
        boolean canConfigShowStartPageContents = this.featureService.canUse(KSEFeature.CONFIGURE_SHOW_START_PAGE_CONTENTS);
        if (canConfigShowStartPageContents) {
            if (!prefStore.contains("general.showStartPageContents")) {
                prefStore.setDefault("general.showStartPageContents", true);
            }
            this.chkShowStartPageContents.setSelection(prefStore.getBoolean("general.showStartPageContents"));
        } else {
            this.chkShowStartPageContents.setSelection(true);
            this.chkShowStartPageContents.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CONFIGURE_SHOW_START_PAGE_CONTENTS);
                    GeneralPreferencePage.this.chkShowStartPageContents.setSelection(true);
                }
            });
        }
    }

    protected void performDefaults() {
        if (this.parentComposite == null) {
            return;
        }
        this.getPreferenceStore().setToDefault("general.autoRestorePreviousSession");
        this.getPreferenceStore().setToDefault("general.autoCheckNewVersion");
        this.getPreferenceStore().setToDefault("general.autoCheckAllowUsage_Tracking");
        this.getPreferenceStore().setToDefault("general.showHelpAtStartUp");
        this.getPreferenceStore().setToDefault("general.receiveDynamicContentNotifications");
        this.getPreferenceStore().setToDefault("general.showStartPageContents");
        this.initialize();
        super.performDefaults();
    }

    protected void performApply() {
        if (this.parentComposite == null) {
            return;
        }
        this.getPreferenceStore().setValue("general.autoRestorePreviousSession", this.radioAutoRestorePrevSession.getSelection());
        this.getPreferenceStore().setValue("general.autoCheckNewVersion", this.chkCheckNewVersion.getSelection());
        this.getPreferenceStore().setValue("general.showHelpAtStartUp", this.chkShowHelpAtStartUp.getSelection());
        this.getPreferenceStore().setValue("general.autoCheckAllowUsage_Tracking", this.chkCheckAllowUsageTracking.getSelection());
        this.getPreferenceStore().setValue("general.receiveDynamicContentNotifications", this.chkReceiveDynamicContentNotifications.getSelection());
        this.getPreferenceStore().setValue("general.showStartPageContents", this.chkShowStartPageContents.getSelection());
        this.eventBroker.post("NOTIFICATIONS/RELOAD", null);
        this.eventBroker.post("START_PAGE/RELOAD", null);
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

