/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.components.util.StyleContext;
import com.kms.katalon.constants.MessageConstants;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BaseQuickStartDialog
extends AbstractDialog {
    protected Composite container;
    protected Composite innerContainer;
    protected Composite tipsComposite;
    protected Canvas mainButton;

    public BaseQuickStartDialog(Shell parentShell) {
        super(parentShell, false);
    }

    protected int getShellStyle() {
        int canCloseBit = this.isClosable() ? 64 : 0;
        int canResizeBit = this.isResizable() ? 16 : 0;
        return 0x8020 | canCloseBit | canResizeBit;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setBackgroundMode(1);
    }

    protected Point getInitialLocation(Point initialSize) {
        this.getShell().pack();
        Point shellSize = this.getShell().getSize();
        int width = Math.max(shellSize.x, initialSize.x);
        int height = Math.max(shellSize.y, initialSize.y);
        return DialogUtil.computeCenterLocation((Point)new Point(width, height), (Shell)this.getParentShell());
    }

    public String getDialogTitle() {
        return MessageConstants.DIALOG_TITLE_QUICK_START_DIALOG;
    }

    protected Point getContainerMargin() {
        return new Point(ComponentUtil.applyZoom((int)30), ComponentUtil.applyZoom((int)10));
    }

    protected String getMainButtonText() {
        return "";
    }

    protected String getTipContent() {
        return "";
    }

    protected Control createDialogContainer(Composite parent) {
        this.beginConstruction(parent);
        Point margin = this.getContainerMargin();
        this.container = (Composite)ComponentBuilder.gridContainer((Composite)parent).build();
        this.innerContainer = (Composite)ComponentBuilder.gridContainer((Composite)this.container).fill().margin(margin.y, margin.x).build();
        this.createContent(this.innerContainer);
        this.createButtons(this.innerContainer);
        this.createTipsComposite(this.innerContainer);
        this.endConstruction();
        this.innerContainer.setFocus();
        return this.container;
    }

    protected void beginConstruction(Composite parent) {
        StyleContext.begin();
        StyleContext.setBackground((Color)ColorUtil.getWhiteBackgroundColor());
        StyleContext.setColor((Color)ColorUtil.getColor((String)"#09092E"));
        parent.setBackground(StyleContext.getBackground());
        parent.getParent().setBackground(StyleContext.getBackground());
        StyleContext.setFont((Font)FontUtil.H4);
    }

    protected void endConstruction() {
        StyleContext.end();
    }

    protected void createContent(Composite container) {
    }

    protected void createButtons(Composite parent) {
        if (StringUtils.isBlank((CharSequence)this.getMainButtonText())) {
            return;
        }
        Composite buttonWrapper = (Composite)ComponentBuilder.gridContainer((Composite)parent).marginTop(30).marginBottom(30).fillHorizontal().build();
        this.mainButton = (Canvas)ComponentBuilder.canvas((Composite)buttonWrapper).text(this.getMainButtonText()).autoSizeXL(160).center().primaryButton().onClick(event -> this.okPressed()).build();
    }

    protected void createTipsComposite(Composite parent) {
        if (StringUtils.isBlank((CharSequence)this.getTipContent())) {
            return;
        }
        Composite tipsCompositeWrapper = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().width(0).build();
        StyleContext.setFontSize((int)10);
        StyleContext.setBackground((Color)ColorUtil.getColor((String)"#F5F5F5"));
        Composite tipsCompositeInner = (Composite)ComponentBuilder.gridContainer((Composite)tipsCompositeWrapper).fillHorizontal().margin(10, 50).build();
        this.tipsComposite = (Composite)ComponentBuilder.gridContainer((Composite)tipsCompositeInner, (int)2).fillHorizontal().center().build();
        ComponentBuilder.canvas((Composite)this.tipsComposite).text("TIPS").bold().autoSize(40, 20).grayBadge().middle().build();
        ComponentBuilder.label((Composite)this.tipsComposite).text(this.getTipContent()).color(ColorUtil.getColor((String)"#797979")).fillHorizontal().middle().build();
        this.createMoreTips(this.tipsComposite);
        StyleContext.prevBackground();
        StyleContext.prevFont();
    }

    protected void createMoreTips(Composite tipsComposite) {
    }

    protected void addTip(Control tip) {
        ComponentUtil.appendGridChild((Composite)this.tipsComposite, (Control)tip);
        this.tipsComposite.pack();
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    protected void handleShellCloseEvent() {
        if (this.isClosable()) {
            this.close();
        }
    }

    protected boolean isClosable() {
        return true;
    }

    protected void registerControlModifyListeners() {
    }

    protected void adjustLayout() {
        ComponentUtil.adjustChildrenWidth((Composite)this.innerContainer);
        DialogUtil.autoScroll((Composite)this.container, (int)512);
        DialogUtil.recenter5((Shell)this.getShell(), (Shell)this.getParentShell());
    }

    protected void setInput() {
    }

    protected boolean isResizable() {
        return false;
    }

    protected boolean shouldReopen() {
        return false;
    }

    public boolean close() {
        if (this.shouldReopen()) {
            try {
                BaseQuickStartDialog clone = (BaseQuickStartDialog)((Object)((Object)((Object)this)).getClass().getConstructor(Shell.class).newInstance(this.getParentShell()));
                clone.open();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return super.close();
    }

    static interface SelectionCallback {
        public void call(Object var1);
    }
}

