/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import java.io.File;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class BDDTestingDefineStepsTourHandler {
    private HighlightOverlay mainOverlay;
    private IEventBroker eventBroker;
    private Composite featureEditor;
    private ProjectEntity currentProject;
    private String SRIPT_GROOVY_OPEN_FILE_PATH = "Include/scripts/groovy/operations/Divide.groovy";
    private String GROOVY_FOLDER_NAME = "groovy";

    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            KatalonTour tour = new KatalonTour(QuickStartTourType.BDD_TESTING_STEP_DEFINITION);
            this.beforeStartTour();
            this.addStep1CreateNewStepDefinition(tour, "introduce-groovy-folder", "Steps in the feature files must be defined before use.\r\n\nTo create new step definitions, in the [Include/scripts/groovy] folder, right-click > [New] > [Step Definition].\r\n\r\nFor now, let's open one of our sample step definition files.", "");
            this.addStep2ViewBDDGroovyEditor(tour, "introduce-step-definition-file", "In the editor view, you can input the step definition class in Java or Groovy.", "");
            this.addStep3DefineStepToExecute(tour, "introduce-keyword-usage", "Define steps to execute the scenario in the feature files. You can reuse Katalon Studio built-in keywords in step definition files.\r\n\r\nHere, we defined the \"When\" step with the def syntax, in which we use the \"callTestCase\" built-in keyword.", "");
            this.addStep4TryToRunBDD(tour, "introduce-test-case-tour", "Now that you have a feature file and its step definition file, let's try to run your first BDD test case, shall we?", "");
            tour.onEnd(() -> {
                Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.END.name());
                DialogUtil.close((Shell)this.mainOverlay);
                DialogUtil.setCanClose((Shell)ShellManager.getWebRecorderDialog(), (boolean)true);
                DialogUtil.setCanClose((Shell)ShellManager.getTestCaseSavingDialog(), (boolean)true);
                DialogUtil.setCanClose((Shell)ShellManager.getTestObjectsSavingDialog(), (boolean)true);
                if (tour.isSkipped() || !tour.isTerminated()) {
                    UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                    curProfile.addCompletedTour(QuickStartTourType.BDD_TESTING_STEP_DEFINITION.name());
                    UserProfileHelper.saveProfile((UserProfile)curProfile);
                    TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.BDD_TESTING_ADDING_TO_TEST_CASE);
                    if (tour.isSkipped()) {
                        return;
                    }
                }
                if (!tour.isTerminated()) {
                    QuickStartTourType tourType = QuickStartController.getCurrentTourTypeFromQuickStartPart();
                    new OpenQuickStartOverviewHandler().execute(tourType, QuickStartTourType.BDD_TESTING_STEP_DEFINITION, QuickStartTourType.BDD_TESTING_ADDING_TO_TEST_CASE);
                }
            });
            tour.start();
        });
    }

    private void addStep1CreateNewStepDefinition(KatalonTour defineStepsTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByText((Widget)mainShell, (String)this.GROOVY_FOLDER_NAME);
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            this.mainOverlay = BDDTestingDefineStepsTourHandler.createOverlay();
            this.mainOverlay.open();
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        BDDTestingDefineStepsTourHandler.createStep(defineStepsTour, stepInfo);
    }

    private void addStep2ViewBDDGroovyEditor(KatalonTour defineStepsTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
            List widgets = ComponentFinder.findAllByText((Widget)ShellManager.getMainShell(), (String)"operations");
            this.eventBroker.post("EXPLORER/EXPAND_TREE_ENTITY", ((Widget)widgets.get(widgets.size() - 1)).getData());
        };
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(20, targetArea.height - dialogArea.height);
        };
        stepInfo.marginLeftXButton = 13;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            Composite editorPartStack = (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
            String editorTabNamePattern = MessageFormat.format("/.*{0}/", Pattern.quote("Divide.groovy"));
            this.featureEditor = (Composite)ComponentFinder.findByTypeAndText((Widget)editorPartStack, Composite.class, (String)editorTabNamePattern);
            return this.featureEditor;
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        BDDTestingDefineStepsTourHandler.createStep(defineStepsTour, stepInfo);
    }

    private void addStep3DefineStepToExecute(KatalonTour defineStepsTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(20, targetArea.height - (OSUtil.isWindows() ? 280 : 100));
        };
        stepInfo.marginLeftXButton = 13;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> this.featureEditor;
        stepInfo.nextable = true;
        BDDTestingDefineStepsTourHandler.createStep(defineStepsTour, stepInfo);
    }

    private void addStep4TryToRunBDD(KatalonTour defineStepsTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getConsolePartStack().getWidget();
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        stepInfo.nextButtonText = "Next";
        stepInfo.blockingUI = false;
        stepInfo.ignoreFocusRegion = true;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        BDDTestingDefineStepsTourHandler.createStep(defineStepsTour, stepInfo);
    }

    private void beforeStartTour() {
        this.eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        this.currentProject = ProjectController.getInstance().getCurrentProject();
        this.eventBroker.send("EXPLORER/COLLAPSE_ALL_ITEMS", null);
        try {
            this.expandFolders();
            this.openGroovyFile();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void expandFolders() throws Exception {
        Shell mainShell = ShellManager.getMainShell();
        Widget target = ComponentFinder.findByText((Widget)mainShell, (String)this.GROOVY_FOLDER_NAME);
        if (target != null && target instanceof TreeItem) {
            return;
        }
        TreeItem item = (TreeItem)ComponentFinder.findByText((Widget)mainShell, (String)"Include");
        this.eventBroker.send("EXPLORER/EXPAND_TREE_ENTITY", item.getData());
        String scriptFolderPath = FileServiceConstant.getScriptFolderLocation((String)this.currentProject.getFolderLocation());
        FolderTreeEntity tree = new FolderTreeEntity(EntityFileServiceManager.getFolder((File)new File(scriptFolderPath)), null);
        this.eventBroker.send("EXPLORER/EXPAND_TREE_ENTITY", (Object)tree);
        String groovyFolderPath = FileServiceConstant.getGroovyScriptFolderLocation((String)this.currentProject.getFolderLocation());
        tree = new FolderTreeEntity((FolderEntity)EntityFileServiceManager.get((File)new File(groovyFolderPath)), null);
        this.eventBroker.send("EXPLORER/EXPAND_TREE_ENTITY", (Object)tree);
    }

    private void openGroovyFile() throws ControllerException {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        String filePath = Paths.get(currentProject.getFolderLocation(), this.SRIPT_GROOVY_OPEN_FILE_PATH).toString();
        this.eventBroker.send("EXPLORER/OPEN_SELECTED_ITEM", (Object)SystemFileController.getInstance().getSystemFile(filePath, currentProject));
    }

    private static HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                overlay.close();
                Trackings.trackTourAction((String)QuickStartTourType.BDD_TESTING_STEP_DEFINITION.name(), (String)TourAction.BROKEN.name());
            }
        });
        return overlay;
    }

    private static void createStep(KatalonTour defineStepsTour, StepInfo stepInfo) {
        defineStepsTour.addStep(new GeneralTourStep(defineStepsTour, stepInfo));
    }
}

