/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import java.io.File;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class CreateAFeatureFileTourHandler {
    private HighlightOverlay mainOverlay;
    private Timer waitForRunMenuTimer;
    @Inject
    IEventBroker eventBroker;
    private String aFeatureFile = "Divide.feature";
    private Composite testCaseEditor;
    private Widget includeItem;
    private Widget plusFeatureItem;
    private static int WAIT__FOR_DONE_FEATURE_FILE_EXECUTION_TO_START_TIMEOUT = 100000;

    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            KatalonTour theFirstBddTour = new KatalonTour(QuickStartTourType.BDD_TESTING_FEATURE_FILE);
            this.addStep1OpenSampleFeatureFiles(theFirstBddTour, "open-sample-feature-files", "You can find feature files in the [Include/features] folder. To create a new feature file, right-click > [New] > [New Feature File].\r\n\r\nFor now, let's open one of our sample feature files.", "");
            this.addStep2AdviseOrganizingFeatureFiles(theFirstBddTour, "advise-organizing-feature-files", "It's better to organize your feature files with a multi-level system.\r\n\r\nA feature file can contain many scenarios. However, you should have one scenario per feature file for easy maintenance.", "");
            this.addStep3HighlightFeatureFile(theFirstBddTour, "open-divide-feature-file", "Input your testing scenario in the feature file editor. Steps in the scenario will then be defined by step definitions.\r\n\r\nHere, we created a simple scenario in the [Divide] feature file.", "");
            this.addStep4RunFeatureFile(theFirstBddTour, "run-feature-file", "In Katalon Studio, you can run the feature file directly with this [Run] button here. Let's try it!", "");
            this.addStep5WaitForLauncher(theFirstBddTour, "wait-for-launcher", "", "");
            this.addStep6CheckTheResult(theFirstBddTour, "check-the-result", "Okay, it's done! Let's check the result to make sure that all the tests were passed!", "");
            this.addStep7PrepareToGoToTheNextTour(theFirstBddTour, "prepare-to-go-to-the-next-tour", "Next, we will define and link the steps in the feature files.", "");
            theFirstBddTour.onEnd(() -> {
                Trackings.trackTourAction((String)theFirstBddTour.getType().name(), (String)TourAction.END.name());
                DialogUtil.close((Shell)this.mainOverlay);
                DialogUtil.setCanClose((Shell)ShellManager.getWebRecorderDialog(), (boolean)true);
                DialogUtil.setCanClose((Shell)ShellManager.getTestCaseSavingDialog(), (boolean)true);
                DialogUtil.setCanClose((Shell)ShellManager.getTestObjectsSavingDialog(), (boolean)true);
                if (theFirstBddTour.isSkipped() || !theFirstBddTour.isTerminated()) {
                    UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                    curProfile.addCompletedTour(QuickStartTourType.BDD_TESTING_FEATURE_FILE.name());
                    UserProfileHelper.saveProfile((UserProfile)curProfile);
                    TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.BDD_TESTING_STEP_DEFINITION);
                    if (theFirstBddTour.isSkipped()) {
                        return;
                    }
                }
                if (!theFirstBddTour.isTerminated()) {
                    QuickStartTourType tourType = QuickStartController.getCurrentTourTypeFromQuickStartPart();
                    new OpenQuickStartOverviewHandler().execute(tourType, QuickStartTourType.BDD_TESTING_FEATURE_FILE, QuickStartTourType.BDD_TESTING_STEP_DEFINITION);
                }
            });
            theFirstBddTour.start();
        });
    }

    private void addStep1OpenSampleFeatureFiles(KatalonTour theFirstBddTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            this.mainOverlay = CreateAFeatureFileTourHandler.createOverlay();
            this.mainOverlay.open();
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByText((Widget)mainShell, (String)"Include");
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        CreateAFeatureFileTourHandler.createStep(theFirstBddTour, stepInfo);
    }

    private void addStep2AdviseOrganizingFeatureFiles(KatalonTour theFirstBddTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
            try {
                this.expandFolders();
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        };
        stepInfo.highlightAreaProvider = (target, parentShell) -> {
            Rectangle upperRect = ComponentUtil.getScreenArea((Widget)this.includeItem, (Control)parentShell);
            Rectangle lowerRect = ComponentUtil.getScreenArea((Widget)this.plusFeatureItem, (Control)parentShell);
            Rectangle targetArea = ComponentUtil.getScreenArea((Widget)target, (Control)parentShell);
            targetArea.y = upperRect.y;
            targetArea.x = upperRect.x;
            targetArea.height = Math.abs(lowerRect.y - upperRect.y) + upperRect.height;
            targetArea.width = upperRect.width;
            return targetArea;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            this.includeItem = ComponentFinder.findByText((Widget)mainShell, (String)"Include");
            this.plusFeatureItem = ComponentFinder.findByText((Widget)mainShell, (String)"Plus.feature");
            if (this.includeItem == null || this.plusFeatureItem == null) {
                return null;
            }
            return ComponentFinder.findByText((Widget)mainShell, (String)"Include");
        };
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width, targetArea.y - targetArea.height);
        };
        CreateAFeatureFileTourHandler.createStep(theFirstBddTour, stepInfo);
    }

    private void addStep3HighlightFeatureFile(KatalonTour theFirstBddTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
            this.openOneFeatureFile();
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = stepInfo.targetFinder = mainShell -> {
            Composite editorPartStack = (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
            String editorTabNamePattern = MessageFormat.format("/.*{0}/", Pattern.quote(this.aFeatureFile));
            this.testCaseEditor = (Composite)ComponentFinder.findByTypeAndText((Widget)editorPartStack, Composite.class, (String)editorTabNamePattern);
            return this.testCaseEditor;
        };
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        stepInfo.marginLeftXButton = 13;
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        CreateAFeatureFileTourHandler.createStep(theFirstBddTour, stepInfo);
    }

    private void addStep4RunFeatureFile(KatalonTour theFirstBddTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"/Run.*/");
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Widget runButton = ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), ToolItem.class, (String)"/Run.*/");
                UITimeUtil.cancel((Timer)this.waitForRunMenuTimer);
                UITimeUtil.waitFor(timer -> {
                    this.waitForRunMenuTimer = timer;
                    return ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run") != null;
                }, () -> {
                    Menu runMenu = (Menu)ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run");
                    ComponentEventUtil.handleDropdownClick((Menu)runMenu, (Event)event, () -> theFirstBddTour.next());
                }, (long)0L);
            }
        };
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        CreateAFeatureFileTourHandler.createStep(theFirstBddTour, stepInfo);
    }

    private void addStep5WaitForLauncher(KatalonTour theFirstBddTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.mainScript = () -> UITimeUtil.waitFor(timer -> LauncherManager.getInstance().isAnyLauncherRunning(), () -> theFirstBddTour.next());
        CreateAFeatureFileTourHandler.createStep(theFirstBddTour, stepInfo);
    }

    private void addStep6CheckTheResult(KatalonTour theFirstBddTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getConsolePartStack().getWidget();
        stepInfo.waitToStartTimeout = WAIT__FOR_DONE_FEATURE_FILE_EXECUTION_TO_START_TIMEOUT;
        stepInfo.waitToStart = timer -> !LauncherManager.getInstance().isAnyLauncherRunning();
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        stepInfo.nextButtonText = "Clap!";
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        CreateAFeatureFileTourHandler.createStep(theFirstBddTour, stepInfo);
    }

    private void addStep7PrepareToGoToTheNextTour(KatalonTour theFirstBddTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getConsolePartStack().getWidget();
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        stepInfo.blockingUI = false;
        stepInfo.ignoreFocusRegion = true;
        stepInfo.nextButtonText = "Next";
        stepInfo.ignoreFocusRegion = true;
        stepInfo.nextable = true;
        CreateAFeatureFileTourHandler.createStep(theFirstBddTour, stepInfo);
    }

    private static void createStep(KatalonTour theFirstBddTour, StepInfo stepInfo) {
        theFirstBddTour.addStep(new GeneralTourStep(theFirstBddTour, stepInfo));
    }

    private static HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                overlay.close();
                Trackings.trackTourAction((String)QuickStartTourType.BDD_TESTING_FEATURE_FILE.name(), (String)TourAction.BROKEN.name());
            }
        });
        return overlay;
    }

    private void openOneFeatureFile() {
        this.eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        try {
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            String filePath = Paths.get(currentProject.getFolderLocation(), "Include/features/operations/" + this.aFeatureFile).toString();
            this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)SystemFileController.getInstance().getSystemFile(filePath, currentProject));
        }
        catch (ControllerException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private void expandFolders() throws Exception {
        this.eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        Shell mainShell = ShellManager.getMainShell();
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        TreeItem treeItem = (TreeItem)ComponentFinder.findByText((Widget)mainShell, (String)"Include");
        this.eventBroker.post("EXPLORER/EXPAND_TREE_ENTITY", treeItem.getData());
        String featuresFolderPath = FileServiceConstant.getFeatureFolderLocation((String)currentProject.getFolderLocation());
        FolderTreeEntity tree = new FolderTreeEntity(EntityFileServiceManager.getFolder((File)new File(featuresFolderPath)), null);
        this.eventBroker.post("EXPLORER/EXPAND_TREE_ENTITY", (Object)tree);
        String operationsFolderPath = FileServiceConstant.getOperationsFeaturesFolderLocation((String)currentProject.getFolderLocation());
        tree = new FolderTreeEntity((FolderEntity)EntityFileServiceManager.get((File)new File(operationsFolderPath)), null);
        this.eventBroker.post("EXPLORER/EXPAND_TREE_ENTITY", (Object)tree);
    }
}

