/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.composer.components.impl.overlay.GuidingPopover;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.impl.util.PlatformUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.KatalonTourStep;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.composer.tour.TourCancellationSurvey;
import com.kms.katalon.tracking.service.Trackings;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GeneralTourStep
extends KatalonTourStep {
    public GeneralTourStep(final KatalonTour tour, final StepInfo stepInfo) {
        super(new KatalonTourStep.StepListener(){

            @Override
            public void run(KatalonTourStep step) {
                QuickStartTourType currentTourType = QuickStartController.getCurrentTourTypeFromQuickStartPart();
                if (currentTourType != QuickStartTourType.BDD_TESTING) {
                    Trackings.trackTourStep((String)tour.getType().name(), (String)stepInfo.name);
                }
                if (stepInfo.beforeStep != null) {
                    stepInfo.beforeStep.run();
                }
                if (stepInfo.mainScript != null) {
                    stepInfo.mainScript.run();
                    return;
                }
                UITimeUtil.WaitForCondition waitForDialog = timer -> stepInfo2.dialogFinder.find(timer) != null;
                UITimeUtil.WaitForCondition waitToStart = stepInfo.waitToStart != null ? stepInfo.waitToStart : waitForDialog;
                UITimeUtil.waitFor((UITimeUtil.WaitForCondition)waitToStart, () -> {
                    Shell stepDialog = stepInfo2.dialogFinder.find(null);
                    if (stepInfo2.setupDialog != null) {
                        stepInfo2.setupDialog.call(stepDialog);
                    }
                    UITimeUtil.waitFor(timer -> stepInfo2.targetFinder.find(stepDialog) != null, () -> {
                        Widget target = stepInfo2.targetFinder.find(stepDialog);
                        Widget secondTarget = stepInfo2.secondTarget;
                        HighlightOverlay stepOverlay = stepInfo2.overlay != null ? stepInfo2.overlay : new HighlightOverlay((Control)stepDialog);
                        stepOverlay.setAlpha(PlatformUtil.isSonomaOrLater() ? 0 : 40);
                        stepOverlay.setBlockingUI(stepInfo2.blockingUI);
                        stepOverlay.setIgnoreFocusRegion(stepInfo2.ignoreFocusRegion);
                        UITimeUtil.setTimeout(() -> {
                            if (ControlUtil.isDisposed((Widget)stepOverlay) || tour.isTerminated()) {
                                return;
                            }
                            stepOverlay.add(target, stepInfo2.highlightAreaProvider);
                            GuidingPopover stepInfoPopover = new GuidingPopover((Shell)stepOverlay, stepInfo2.title, stepInfo2.description, (Widget)(!ControlUtil.isDisposed((Widget)target) ? target : stepDialog));
                            stepInfoPopover.setMarginLeftXButton(stepInfo2.marginLeftXButton);
                            stepInfoPopover.setPositionProvider(stepInfo2.guidingDialogPositionProvider);
                            stepInfoPopover.setUseNextButton(stepInfo2.nextable);
                            stepInfoPopover.setNextButtonText(stepInfo2.nextButtonText);
                            stepInfoPopover.setNumSteps(tour.getNumSteps());
                            stepInfoPopover.setCurStepIndex(tour.getCurStepIndex());
                            if (stepInfo2.hasActionBeforeClose.booleanValue()) {
                                stepInfoPopover.setBeforeClose(() -> {
                                    Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.CLOSE.name());
                                    TourCancellationSurvey confirmDialog = new TourCancellationSurvey(ShellManager.getLastActiveAliveShell());
                                    int returnCode = confirmDialog.open();
                                    stepInfoPopover.setReturnCode(returnCode);
                                    if (returnCode == 0) {
                                        Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.CONTINUE.name());
                                    }
                                    if (returnCode == 1) {
                                        Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.SKIP.name());
                                    }
                                    if (returnCode == 16) {
                                        Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.REMIND.name());
                                    }
                                    return returnCode != 0;
                                });
                            } else {
                                stepInfoPopover.setBeforeClose(null);
                            }
                            if (stepInfo2.triggerWhenClickTarget || stepInfo2.customClickHandler != null) {
                                ComponentEventUtil.replaceClickAction((Widget)target, event -> {
                                    if (step.isEnded()) {
                                        return;
                                    }
                                    if (event.detail == 4) {
                                        event.doit = false;
                                    }
                                    if (stepInfo2.customClickHandler != null) {
                                        stepInfo2.customClickHandler.handleEvent(event);
                                    }
                                    if (!event.doit) {
                                        return;
                                    }
                                    if (stepInfo2.triggerWhenClickTarget) {
                                        DialogUtil.close((Shell)stepInfoPopover);
                                    }
                                });
                            }
                            if (stepInfo2.triggerWhenClickSecondTarget && stepInfo2.secondTarget != null) {
                                ComponentEventUtil.replaceClickAction((Widget)secondTarget, event -> {
                                    if (step.isEnded()) {
                                        return;
                                    }
                                    if (event.detail == 4) {
                                        event.doit = false;
                                    }
                                    if (!event.doit) {
                                        return;
                                    }
                                    if (stepInfo2.triggerWhenClickSecondTarget) {
                                        DialogUtil.close((Shell)stepInfoPopover);
                                    }
                                });
                            }
                            stepInfoPopover.addDisposeListener(event -> {
                                if (step.isEnded()) {
                                    return;
                                }
                                if (stepInfoPopover.getReturnCode() == 0) {
                                    tour.next();
                                    return;
                                }
                                if (stepInfoPopover.getReturnCode() == 1) {
                                    tour.finish();
                                } else {
                                    tour.stop();
                                }
                            });
                            step.onEnd(stepz -> {
                                DialogUtil.close((Shell)stepInfoPopover);
                                stepOverlay.removeAll();
                                if (!stepInfo2.keepOverlay || stepz.isInterupted()) {
                                    DialogUtil.close((Shell)stepOverlay);
                                }
                                stepInfo2.overlay = stepOverlay;
                                if (stepInfo2.afterStep != null) {
                                    stepInfo2.afterStep.run();
                                }
                            });
                            ComponentEventUtil.onClick((Widget)stepOverlay, event -> {
                                if (!stepInfoPopover.isDisposed()) {
                                    stepInfoPopover.forceFocus();
                                }
                            });
                            if (stepOverlay != stepInfo2.parentOverlay) {
                                ComponentEventUtil.onClick((Widget)stepInfo2.parentOverlay, event -> {
                                    if (!stepInfoPopover.isDisposed()) {
                                        stepOverlay.highlight();
                                        stepInfoPopover.getParent().getShell().forceActive();
                                        stepInfoPopover.forceActive();
                                    }
                                });
                            }
                            if (!stepInfo2.noToolTip) {
                                stepInfoPopover.open();
                            }
                            if (stepInfo2.waitToEnd != null) {
                                UITimeUtil.waitFor(timer -> {
                                    if (step.isEnded() || ControlUtil.isDisposed((Widget)stepOverlay)) {
                                        timer.cancel();
                                        return false;
                                    }
                                    return stepInfo2.waitToEnd.test(timer);
                                }, () -> step.next());
                            }
                        }, (long)stepInfo2.popverDelayTime);
                        if (!ControlUtil.isDisposed((Widget)stepOverlay) && !stepOverlay.isVisible()) {
                            stepOverlay.open();
                        }
                        if (stepInfo2.additionalScript != null) {
                            stepInfo2.additionalScript.run(step);
                        }
                    }, (long)stepInfo2.waitToStartTimeout);
                }, (long)stepInfo.waitToStartTimeout);
            }
        });
    }
}

