/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.quickstart.DownloadKREDialog;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KRESetUpInstructionDialog;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.composer.tour.TourCancellationSurvey;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.KREUtil;
import com.kms.katalon.util.TourEventBroker;
import com.kms.katalon.webserver.WebViewController;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class KatalonRuntimeEngineTourHandler {
    private HighlightOverlay mainOverlay;
    private HighlightOverlay commandBuilderOverlay;
    private HighlightOverlay generatedCommandOverlay;
    private Button browse;
    private Text testSuiteTextBox;
    private Shell commandBuilderShell;
    private Shell testSuiteBrowser;
    private String testSuiteName;
    private Object generateCommandBuilderDialog;
    private Object generatedCommandDialog;

    public KatalonRuntimeEngineTourHandler() {
    }

    public KatalonRuntimeEngineTourHandler(String testSuiteName) {
        this.testSuiteName = testSuiteName;
    }

    @Execute
    public void execute() {
        this.openDownloadKREDialog();
    }

    private void openDownloadKREDialog() {
        UISynchronizeService.asyncExec(() -> {
            int returnedCode = new DownloadKREDialog(ShellManager.getLastActiveAliveShell()).open();
            switch (returnedCode) {
                case 0: {
                    Trackings.trackTourStep((String)QuickStartTourType.SET_UP_KRE.name(), (String)"i-had-kre");
                    this.setupKREtour();
                    break;
                }
                case 2: {
                    Trackings.trackTourStep((String)QuickStartTourType.SET_UP_KRE.name(), (String)"download-kre");
                    KREUtil.downloadKRE();
                    this.setupKREtour();
                    break;
                }
                default: {
                    Trackings.trackTourStep((String)QuickStartTourType.SET_UP_KRE.name(), (String)"close-download-kre");
                    TourCancellationSurvey cancelDialog = new TourCancellationSurvey(ShellManager.getLastActiveAliveShell());
                    int cancelDialogReturnedCode = cancelDialog.open();
                    if (cancelDialogReturnedCode == 0) {
                        Trackings.trackTourAction((String)QuickStartTourType.SET_UP_KRE.name(), (String)TourAction.CONTINUE.name());
                        this.openDownloadKREDialog();
                    }
                    if (cancelDialogReturnedCode == 1) {
                        this.saveUserProfileTourInformation(null);
                        Trackings.trackTourAction((String)QuickStartTourType.SET_UP_KRE.name(), (String)TourAction.SKIP.name());
                    }
                    if (cancelDialogReturnedCode != 16) break;
                    Trackings.trackTourAction((String)QuickStartTourType.SET_UP_KRE.name(), (String)TourAction.REMIND.name());
                }
            }
        });
    }

    private void setupKREtour() {
        UISynchronizeService.asyncExec(() -> {
            KatalonTour tour = new KatalonTour(QuickStartTourType.SET_UP_KRE);
            String firstName = ApplicationContext.getInstance().getUserFirstName();
            firstName = StringUtils.isNotBlank((CharSequence)firstName) ? MessageFormat.format(" {0}", firstName) : "";
            this.addStep1ClickBuildCmdButton(tour, "build-cmd-button", "Hi" + firstName + "! Let's generate a command by clicking on this button!", "");
            this.addStep2BrowseTestSuite(tour, "browse", "Select your Test Suite here!", "");
            this.addStep3ChooseTestSuite(tour, "choose-test-suite", "Click [OK] to continue", "");
            this.addStep4CheckUpdateWebdriver(tour, "check-update-webdriver", "This setting enables automatic WebDriver updates.", "");
            this.addStep5GenerateCommand(tour, "generate-command", "Click here to get the generated command!", "");
            this.addStep6CopyToClipboard(tour, "copy-to-clipboard", "Great! Click on this button to copy the generated command!", "");
            this.addStep7CongratDialog(tour, "kre-instruction-dialog", "", "");
            tour.onEnd(() -> {
                DialogUtil.close((Shell)this.mainOverlay);
                DialogUtil.close((Shell)this.commandBuilderOverlay);
                DialogUtil.close((Shell)this.generatedCommandOverlay);
                this.returnCloseStateForGenerateCommandBuilderDialog();
                this.returnCloseStateForGeneratedCommandDialog();
                if (tour.isSkipped() || !tour.isTerminated()) {
                    this.saveUserProfileTourInformation(tour);
                    if (tour.isSkipped()) {
                        Trackings.trackTourAction((String)QuickStartTourType.SET_UP_KRE.name(), (String)TourAction.END.name());
                        return;
                    }
                    QuickStartTourType tourType = QuickStartController.getCurrentTourTypeFromQuickStartPart();
                    new OpenQuickStartOverviewHandler().execute(tourType, QuickStartTourType.SET_UP_KRE, null);
                }
                if (tour.isTerminated()) {
                    DialogUtil.close((Shell)this.mainOverlay);
                    DialogUtil.close((Shell)this.commandBuilderOverlay);
                    DialogUtil.close((Shell)this.generatedCommandOverlay);
                }
            });
            tour.start();
        });
    }

    private void addStep1ClickBuildCmdButton(KatalonTour kreTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            this.mainOverlay = KatalonRuntimeEngineTourHandler.createOverlay();
            this.mainOverlay.open();
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByText((Widget)mainShell, (String)"Build CMD");
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        KatalonRuntimeEngineTourHandler.createStep(kreTour, stepInfo);
    }

    private void addStep2BrowseTestSuite(KatalonTour kreTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"Generate Command for Console Mode");
        stepInfo.setupDialog = dialog -> {
            DialogUtil.setCanClose((Shell)dialog, (boolean)false);
            Button updateWebdriver = (Button)ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"Update WebDriver automatically");
            if (updateWebdriver != null) {
                updateWebdriver.setSelection(true);
            }
            try {
                List tsList = TestSuiteController.getInstance().getAllTestSuites(ProjectController.getInstance().getCurrentProject());
                if (StringUtils.isNotBlank((CharSequence)this.testSuiteName)) {
                    TestSuiteEntity tsEntity = TestSuiteController.getInstance().getTestSuiteByName(this.testSuiteName, ProjectController.getInstance().getCurrentProject());
                    String string = this.testSuiteName = tsEntity != null ? tsEntity.getIdForDisplay() : "";
                }
                if (!tsList.isEmpty() && StringUtils.isBlank((CharSequence)this.testSuiteName)) {
                    this.testSuiteName = ((TestSuiteEntity)tsList.get(0)).getIdForDisplay();
                }
                if (StringUtils.isNotBlank((CharSequence)this.testSuiteName)) {
                    stepInfo.nextable = true;
                }
                if (dialog.isVisible() && dialog.getData() instanceof Dialog) {
                    this.generateCommandBuilderDialog = dialog.getData();
                    Class<?> clazz = dialog.getData().getClass();
                    Method changeTSName = clazz.getDeclaredMethod("changeTSName", String.class);
                    changeTSName.invoke(dialog.getData(), this.testSuiteName);
                    clazz.getDeclaredMethods();
                    Method setInTour = clazz.getDeclaredMethod("setInTour", Boolean.TYPE);
                    setInTour.invoke(this.generateCommandBuilderDialog, true);
                }
            }
            catch (Exception exception) {}
        };
        stepInfo.targetFinder = shell -> {
            this.commandBuilderShell = shell;
            this.testSuiteTextBox = (Text)ComponentFinder.findAllByType((Widget)shell, Text.class).get(0);
            this.browse = (Button)ComponentFinder.findByTypeAndText((Widget)shell, Button.class, (String)"Browse...");
            stepInfo.secondTarget = this.browse;
            List components = ComponentFinder.findAllByType((Widget)shell, Composite.class);
            if ((components = components.stream().filter(component -> component.getChildren().length == 3 && ComponentFinder.findByTypeAndText((Widget)component, Button.class, (String)"Browse...") != null).collect(Collectors.toList())).size() > 0) {
                return (Widget)components.get(components.size() - 1);
            }
            return null;
        };
        stepInfo.guidingDialogPositionProvider = (shell, arg) -> {
            Rectangle browseRec = ComponentUtil.getScreenArea((Widget)this.browse, (Control)this.commandBuilderShell);
            Rectangle recT = ComponentUtil.getScreenArea((Widget)this.testSuiteTextBox, (Control)this.commandBuilderShell);
            Rectangle bestArea = (Rectangle)arg[0];
            int x = bestArea.x + recT.width - browseRec.width;
            return new Point(x, bestArea.y);
        };
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickSecondTarget = true;
        stepInfo.blockingUI = true;
        stepInfo.afterStep = () -> {
            this.commandBuilderOverlay = stepInfo.overlay;
        };
        KatalonRuntimeEngineTourHandler.createStep(kreTour, stepInfo);
    }

    private void addStep3ChooseTestSuite(KatalonTour kreTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.commandBuilderOverlay;
        };
        stepInfo.dialogFinder = timer -> {
            Shell browser = ComponentFinder.findShell((String)"Test Suite Browser");
            if (browser == null) {
                kreTour.next();
                timer.cancel();
            }
            return browser;
        };
        stepInfo.setupDialog = dialog -> {
            this.testSuiteBrowser = dialog;
            DialogUtil.setCanClose((Shell)dialog, (boolean)false);
            ((Button)ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"Cancel")).setEnabled(false);
        };
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByText((Widget)parentShell, (String)"OK");
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.blockingUI = false;
        stepInfo.afterStep = () -> {
            DialogUtil.setCanClose((Shell)this.testSuiteBrowser, (boolean)true);
            ((Button)ComponentFinder.findByTypeAndText((Widget)this.testSuiteBrowser, Button.class, (String)"Cancel")).setEnabled(true);
        };
        KatalonRuntimeEngineTourHandler.createStep(kreTour, stepInfo);
    }

    private void addStep4CheckUpdateWebdriver(KatalonTour kreTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.commandBuilderOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"Generate Command for Console Mode");
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByText((Widget)parentShell, (String)"Update WebDriver automatically");
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        KatalonRuntimeEngineTourHandler.createStep(kreTour, stepInfo);
    }

    private void addStep5GenerateCommand(KatalonTour kreTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.commandBuilderOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.dialogFinder = timer -> ComponentFinder.findShell((String)"Generate Command for Console Mode");
        stepInfo.targetFinder = parentShell -> ComponentFinder.findByTypeAndText((Widget)parentShell, Button.class, (String)"Generate Command");
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.afterStep = () -> {
            this.generatedCommandOverlay = stepInfo.overlay;
        };
        KatalonRuntimeEngineTourHandler.createStep(kreTour, stepInfo);
    }

    private void addStep6CopyToClipboard(KatalonTour kreTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.commandBuilderOverlay;
        };
        stepInfo.dialogFinder = timer -> {
            Shell generatedCommand = ComponentFinder.findShell((String)"Generated Command");
            return generatedCommand;
        };
        stepInfo.setupDialog = dialog -> {
            if (dialog.isVisible() && dialog.getData() instanceof Dialog) {
                this.generatedCommandDialog = dialog.getData();
            }
            Button closeButton = (Button)ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"&Close");
            closeButton.setEnabled(false);
            Button copyToClipboardButton = (Button)ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"Copy to Clipboard");
            ComponentEventUtil.onClick((Widget)copyToClipboardButton, event -> {
                Shell newShellDialog = new Shell(dialog);
                String url = WebViewController.getInstance().getPage(MessageFormat.format("KREExecutionInstruction.html?os={0}", this.buildOSString().orElse("win32")));
                KRESetUpInstructionDialog kreDialog = new KRESetUpInstructionDialog(newShellDialog, url);
                kreDialog.setCurrentTour(kreTour);
                this.closeGeneratedCommandDialog(dialog);
                kreDialog.open();
            });
        };
        stepInfo.targetFinder = shell -> ComponentFinder.findByTypeAndText((Widget)shell, Button.class, (String)"Copy to Clipboard");
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.afterStep = () -> {
            this.generatedCommandOverlay = stepInfo.overlay;
            Shell generatedCommand = ComponentFinder.findShell((String)"Generated Command");
            if (generatedCommand != null) {
                Button closeButton = (Button)ComponentFinder.findByTypeAndText((Widget)generatedCommand, Button.class, (String)"&Close");
                closeButton.setEnabled(true);
            }
        };
        KatalonRuntimeEngineTourHandler.createStep(kreTour, stepInfo);
    }

    private void addStep7CongratDialog(KatalonTour kreTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> {
            Shell targetShell = ComponentFinder.findShell((String)"Open Command Prompt for KRE execution");
            return targetShell;
        };
        stepInfo.targetFinder = shell -> ComponentFinder.findShell((String)"Open Command Prompt for KRE execution");
        stepInfo.keepOverlay = false;
        stepInfo.blockingUI = false;
        stepInfo.ignoreFocusRegion = true;
        stepInfo.noToolTip = true;
        stepInfo.waitToEnd = timer -> {
            Shell targetShell = ComponentFinder.findShell((String)"Open Command Prompt for KRE execution");
            return targetShell == null;
        };
        KatalonRuntimeEngineTourHandler.createStep(kreTour, stepInfo);
    }

    private static void createStep(KatalonTour testPlanningTour, StepInfo stepInfo) {
        testPlanningTour.addStep(new GeneralTourStep(testPlanningTour, stepInfo));
    }

    private static HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                overlay.close();
                Trackings.trackTourAction((String)QuickStartTourType.SET_UP_KRE.name(), (String)TourAction.BROKEN.name());
            }
        });
        return overlay;
    }

    private Optional<String> buildOSString() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Optional.of("win32");
        }
        if (SystemUtils.IS_OS_MAC) {
            return Optional.of("macosx");
        }
        if (SystemUtils.IS_OS_LINUX) {
            return Optional.of("linux");
        }
        return Optional.empty();
    }

    private void returnCloseStateForGenerateCommandBuilderDialog() {
        try {
            if (this.generateCommandBuilderDialog != null) {
                Class<?> clazz = this.generateCommandBuilderDialog.getClass();
                Method setInTour = clazz.getDeclaredMethod("setInTour", Boolean.TYPE);
                setInTour.invoke(this.generateCommandBuilderDialog, false);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void returnCloseStateForGeneratedCommandDialog() {
        try {
            if (this.generatedCommandDialog != null) {
                Class<?> subClazz = this.generatedCommandDialog.getClass();
                Field isInTourField = subClazz.getDeclaredField("isInTour");
                isInTourField.setAccessible(true);
                isInTourField.set(this.generatedCommandDialog, false);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void closeGeneratedCommandDialog(Shell dialog) {
        try {
            if (this.generatedCommandDialog != null) {
                this.returnCloseStateForGeneratedCommandDialog();
                DialogUtil.close((Shell)dialog);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void saveUserProfileTourInformation(KatalonTour tour) {
        if (tour == null) {
            tour = new KatalonTour(QuickStartTourType.SET_UP_KRE);
        }
        UserProfile curProfile = UserProfileHelper.getCurrentProfile();
        curProfile.addCompletedTour(tour.getType().name());
        UserProfileHelper.saveProfile((UserProfile)curProfile);
        TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.SET_UP_KRE);
    }
}

