/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import java.util.ArrayList;
import java.util.List;

public class KatalonTourStep {
    private List<StepListener> internalEndListeners = new ArrayList<StepListener>();
    private List<StepListener> endListeners = new ArrayList<StepListener>();
    private List<StepListener> runListeners = new ArrayList<StepListener>();
    private boolean isInterupted;
    private boolean isEnded;

    public KatalonTourStep(StepListener runner) {
        this.addRunner(runner);
    }

    public KatalonTourStep addRunner(StepListener runner) {
        this.runListeners.add(runner);
        return this;
    }

    public void run() {
        this.runListeners.forEach(runner -> runner.run(this));
    }

    public void next() {
        if (this.isEnded()) {
            return;
        }
        this.notifyEnd();
    }

    public void stop() {
        if (this.isEnded()) {
            return;
        }
        this.setInterupted(true);
        this.notifyEnd();
    }

    public void onEnd(StepListener callback) {
        this.endListeners.add(callback);
    }

    public void onEndInternal(StepListener callback) {
        this.internalEndListeners.add(callback);
    }

    public void clearEndInternal() {
        this.internalEndListeners.clear();
    }

    public void notifyEnd() {
        this.setEnded(true);
        this.endListeners.forEach(endListener -> endListener.run(this));
        this.internalEndListeners.forEach(endListener -> endListener.run(this));
    }

    public boolean isInterupted() {
        return this.isInterupted;
    }

    public void setInterupted(boolean isInterupted) {
        this.isInterupted = isInterupted;
    }

    public boolean isEnded() {
        return this.isInterupted || this.isEnded;
    }

    public void setEnded(boolean isEnded) {
        this.isEnded = isEnded;
    }

    public static interface StepListener {
        public void run(KatalonTourStep var1);
    }
}

