/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.core.webui.util.OSUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class TourCancellationSurvey
extends BaseQuickStartDialog {
    private final int CONTENT_WIDTH = OSUtil.isMac() ? 520 : 500;
    private boolean isActionButtonClicked = false;

    public TourCancellationSurvey(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String getDialogTitle() {
        return "You are about to skip the onboarding tour";
    }

    @Override
    protected void createContent(Composite container) {
        Composite body = (Composite)ComponentBuilder.gridContainer((Composite)container).margin(30).gridVerticalSpacing(10).build();
        this.createGuidings(body);
    }

    private void createGuidings(Composite parent) {
        String confirmQuestion = "Are you sure you do not want to see how your automated test looks like and how to run it?";
        ComponentBuilder.label((Composite)parent).text(confirmQuestion).width(this.CONTENT_WIDTH).build();
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite buttonsCompositeWrapper = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().build();
        Composite buttonsComposite = (Composite)ComponentBuilder.gridContainer((Composite)buttonsCompositeWrapper, (int)3).right().margin(10).build();
        ComponentBuilder.canvas((Composite)buttonsComposite).text("Remind me later").linkButton().autoSizeMD(140).onClick(event -> {
            this.isActionButtonClicked = true;
            this.setReturnCode(16);
            this.close();
        }).build();
        ComponentBuilder.canvas((Composite)buttonsComposite).text("Skip this tour").grayButton().autoSizeMD(140).onClick(event -> {
            this.isActionButtonClicked = true;
            this.userCancelQuickStartTour();
            this.cancelPressed();
        }).build();
        ComponentBuilder.canvas((Composite)buttonsComposite).text("Keep learning >>").primaryButton().autoSizeMD(180).onClick(event -> {
            this.isActionButtonClicked = true;
            this.okPressed();
        }).build();
    }

    @Override
    public boolean close() {
        if (!this.isActionButtonClicked) {
            this.setReturnCode(0);
        }
        return super.close();
    }

    @Override
    protected boolean isClosable() {
        return true;
    }

    public void userCancelQuickStartTour() {
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        userProfile.setDoneFirstQuickStartTour(true);
        UserProfileHelper.saveProfile((UserProfile)userProfile);
    }
}

