/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tour;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.OpenQuickStartOverviewHandler;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.quickstart.QuickRecordGuidingDialogV2;
import com.kms.katalon.composer.tour.GeneralTourStep;
import com.kms.katalon.composer.tour.KatalonTour;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.StepInfo;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourEventBroker;
import java.text.MessageFormat;
import java.util.List;
import java.util.Timer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class WebTestingTourHandler {
    private static final int NUM_DEFAULT_STEPS = 2;
    private static final String STOP_RECORDING = "Stop recording";
    private HighlightOverlay mainOverlay;
    private HighlightOverlay recorderOverlay;
    private Shell recorderDialogShell;
    private Timer waitForRunMenuTimer;

    @Execute
    public void execute() {
        UISynchronizeService.asyncExec(() -> {
            KatalonTour tour = new KatalonTour(QuickStartTourType.WEB_TESTING);
            String firstName = ApplicationContext.getInstance().getUserFirstName();
            firstName = StringUtils.isNotBlank((CharSequence)firstName) ? MessageFormat.format(" {0}", firstName) : "";
            this.addStep1OpenRecorder(tour, "open-recorder", String.valueOf(MessageFormat.format("Hi{0}! Welcome to our onboarding tour: \"Create and Run your First Test\".", firstName)) + "\r\n\r\nLet's start by clicking on this button to open Web Recorder!", "");
            this.addStep2SetupRecorder(tour, "setup-recorder", "With the Web Recorder, you can perform common actions on the web and turn them directly into test steps.\r\n\r\nNow, what website would you like to test?", "");
            this.addStep3StartRecording(tour, "start-recording", "Web Recorder makes generating test scripts easy and natural.\r\n\r\nLet's start recording! If you're ready, click on the [Record] button.", "");
            this.addStep4MannualTestTheWebPage(tour, "test-the-web-page", "Go ahead and interact with the page. Perform at least three actions." + System.lineSeparator() + " " + System.lineSeparator() + "Every action you perform is highlighted in red." + System.lineSeparator() + " " + System.lineSeparator() + "All your actions on this web page are captured as test steps like this.", "");
            this.addStep5StopRecording(tour, "stop-recording", "Done? You can stop recording now. Click on the [Stop] button here.", "");
            this.addStep6SaveRecording(tour, "save-recording", "Now, let's save your test case. Click on the [Save Script] button.", "");
            this.addStep7SaveTestObjects(tour, "save-test-objects", "Remember those buttons you clicked on that web page? Those are \"web elements\", and were saved together with your actions.\r\n\r\nLet's add these captured elements to our Object Repository! You will need them later. Click [OK].", "");
            this.addStep8SaveTestCase(tour, "save-test-case", "You now have everything you need: test steps saved as a script, and the web elements they interact with. We can now create a new test case. Give it a name and click [OK].", "");
            this.addStep9ShowTestsExplorer(tour, "show-test-explorer", "Voil\u00e0! You've just created your very first test case. It is stored under the \"Test Cases\" folder. ", "");
            this.addStep10ShowTestEditor(tour, "show-test-case-editor", "This editor view is where you can adjust your test case in both manual and script view.", "");
            this.addStep11RunYourTest(tour, "run-test-case", "Amazing! Now let's run this test and see how it works! Click on the [Run] button.", "");
            this.addStep12WaitForLauncher(tour, "wait-for-launcher", "", "");
            this.addStep13CheckTheResult(tour, "check-the-result", "You've just completed your first automation test!\r\n\r\nLet's check the results to see if all the steps passed.", "");
            tour.onEnd(() -> {
                Trackings.trackTourAction((String)tour.getType().name(), (String)TourAction.END.name());
                DialogUtil.close((Shell)this.mainOverlay);
                DialogUtil.setCanCloseAndClickOK((Shell)ShellManager.getWebRecorderDialog(), (boolean)true);
                DialogUtil.setCanCloseAndClickOK((Shell)ShellManager.getTestCaseSavingDialog(), (boolean)true);
                DialogUtil.setCanCloseAndClickOK((Shell)ShellManager.getTestObjectsSavingDialog(), (boolean)true);
                if (tour.isSkipped() || !tour.isTerminated()) {
                    UserProfile curProfile = UserProfileHelper.getCurrentProfile();
                    curProfile.addCompletedTour(tour.getType().name());
                    curProfile.addCompletedTour(QuickStartTourType.GENERIC_TESTING.name());
                    UserProfileHelper.saveProfile((UserProfile)curProfile);
                    TourEventBroker.refreshPageAfterCompletedTour(QuickStartTourType.TEST_PLANNING);
                    if (tour.isSkipped()) {
                        return;
                    }
                }
                if (!tour.isTerminated()) {
                    new OpenQuickStartOverviewHandler().execute(tour.getType(), QuickStartTourType.TEST_PLANNING);
                }
            });
            tour.start();
        });
    }

    private void addStep1OpenRecorder(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"Record Web");
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            this.mainOverlay = WebTestingTourHandler.createOverlay();
            this.mainOverlay.open();
            stepInfo.overlay = this.mainOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep2SetupRecorder(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getWebRecorderDialog();
        stepInfo.setupDialog = dialog -> {
            this.recorderDialogShell = dialog;
            DialogUtil.setCanCloseAndClickOK((Shell)dialog, (boolean)false);
        };
        stepInfo.targetFinder = dialog -> {
            Label urlLabel = (Label)ComponentFinder.findByTypeAndText((Widget)dialog, Label.class, (String)"URL");
            return urlLabel.getParent().getChildren()[1];
        };
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.afterStep = () -> {
            this.recorderOverlay = stepInfo.overlay;
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep3StartRecording(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getWebRecorderDialog();
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, ToolItem.class, (String)"Record");
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Shell activeDropdown = ComponentFinder.findShell((String)"control.type.dropdown");
                List options = ComponentFinder.findAll((Widget)activeDropdown, (ComponentFinder.WidgetFilter)ComponentFinder.TypeFilter(ToolItem.class));
                options.forEach(option -> {
                    if (ComponentDataUtil.getAnyText((Widget)option).equalsIgnoreCase("Empty")) {
                        return;
                    }
                    ComponentEventUtil.replaceClickAction((Widget)option, event1 -> webTestingTour.next());
                });
            }
        };
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.recorderOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep4MannualTestTheWebPage(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.mainScript = () -> UITimeUtil.waitFor(timer -> {
            ToolItem stopButton = (ToolItem)ComponentFinder.findByTypeAndText((Widget)ShellManager.getWebRecorderDialog(), ToolItem.class, (String)STOP_RECORDING);
            if (ControlUtil.isDisposed((Widget)stopButton)) {
                timer.cancel();
                return false;
            }
            return stopButton.getEnabled();
        }, () -> UITimeUtil.setTimeout(() -> {
            QuickRecordGuidingDialogV2 guidingDialog = new QuickRecordGuidingDialogV2(ShellManager.getLastActiveAliveShell(), stepInfo.title, stepInfo.description);
            guidingDialog.open();
            webTestingTour.next();
        }, (long)2000L), (long)0L);
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep5StopRecording(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getWebRecorderDialog();
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, ToolItem.class, (String)STOP_RECORDING);
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.recorderOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.waitToStart = timer -> {
            boolean isBrowserClosed;
            if (this.recorderDialogShell.isDisposed()) {
                timer.cancel();
                return false;
            }
            Object recorderDialogz = this.recorderDialogShell.getData();
            int numSteps = (Integer)ObjectUtil.invokeGet((Object)recorderDialogz, (String)"countAllSteps", (Object)0);
            ToolItem stopButton = (ToolItem)ComponentFinder.findByTypeAndText((Widget)this.recorderDialogShell, ToolItem.class, (String)STOP_RECORDING);
            boolean bl = isBrowserClosed = numSteps > 0 && !ControlUtil.isDisposed((Widget)stopButton) && !stopButton.getEnabled();
            return numSteps - 2 >= 3 || isBrowserClosed;
        };
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.additionalScript = step -> UITimeUtil.waitFor(timer -> {
            boolean isBrowserClosed;
            if (this.recorderDialogShell.isDisposed() || step.isEnded()) {
                timer.cancel();
                return true;
            }
            Object recorderDialogz = this.recorderDialogShell.getData();
            int numSteps = (Integer)ObjectUtil.invokeGet((Object)recorderDialogz, (String)"countAllSteps", (Object)0);
            ToolItem stopButton = (ToolItem)ComponentFinder.findByTypeAndText((Widget)this.recorderDialogShell, ToolItem.class, (String)STOP_RECORDING);
            boolean bl = isBrowserClosed = numSteps > 0 && !ControlUtil.isDisposed((Widget)stopButton) && !stopButton.getEnabled();
            if (isBrowserClosed && !step.isEnded()) {
                step.next();
                return true;
            }
            return false;
        });
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep6SaveRecording(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getWebRecorderDialog();
        stepInfo.setupDialog = dialog -> DialogUtil.setCanClickOK((Shell)dialog, (boolean)true);
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"Save Script");
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.recorderOverlay;
            stepInfo.parentOverlay = this.mainOverlay;
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep7SaveTestObjects(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> {
            DialogUtil.setCanClose((Shell)this.recorderDialogShell, (boolean)true);
            Shell testCaseSavingDialog = ShellManager.getTestCaseSavingDialog();
            if (testCaseSavingDialog != null) {
                timer.cancel();
                webTestingTour.next();
                return null;
            }
            Shell testObjectsSavingDialog = ShellManager.getTestObjectsSavingDialog();
            if (testObjectsSavingDialog != null) {
                DialogUtil.setCanClose((Shell)testObjectsSavingDialog, (boolean)false);
                Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)testObjectsSavingDialog, Button.class, (String)GlobalMessageConstants.DIA_CANCEL);
                cancelButton.setEnabled(false);
                ComponentEventUtil.replaceClickAction((Widget)cancelButton, event -> webTestingTour.back());
            }
            return testObjectsSavingDialog;
        };
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)GlobalMessageConstants.DIA_OK);
        stepInfo.blockingUI = false;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.beforeStep = () -> {
            stepInfo.parentOverlay = this.mainOverlay;
        };
        stepInfo.afterStep = () -> {
            Shell testObjectsSavingDialog = ShellManager.getTestObjectsSavingDialog();
            if (testObjectsSavingDialog != null) {
                DialogUtil.setCanClose((Shell)testObjectsSavingDialog, (boolean)true);
                Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)testObjectsSavingDialog, Button.class, (String)GlobalMessageConstants.DIA_CANCEL);
                cancelButton.setEnabled(true);
                ComponentEventUtil.restoreClickAction((Widget)cancelButton);
            }
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep8SaveTestCase(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> {
            Shell testCaseSavingDialog = ShellManager.getTestCaseSavingDialog();
            if (testCaseSavingDialog != null) {
                DialogUtil.setCanClose((Shell)testCaseSavingDialog, (boolean)false);
                Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)testCaseSavingDialog, Button.class, (String)GlobalMessageConstants.DIA_CANCEL);
                cancelButton.setEnabled(false);
                ComponentEventUtil.replaceClickAction((Widget)cancelButton, event -> webTestingTour.stop());
            }
            return testCaseSavingDialog;
        };
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)GlobalMessageConstants.DIA_OK);
        stepInfo.blockingUI = false;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.afterStep = () -> {
            Shell testCaseSavingDialog = ShellManager.getTestCaseSavingDialog();
            if (testCaseSavingDialog != null) {
                DialogUtil.setCanClose((Shell)testCaseSavingDialog, (boolean)true);
                Button cancelButton = (Button)ComponentFinder.findByTypeAndText((Widget)testCaseSavingDialog, Button.class, (String)GlobalMessageConstants.DIA_CANCEL);
                cancelButton.setEnabled(true);
                ComponentEventUtil.restoreClickAction((Widget)cancelButton);
            }
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep9ShowTestsExplorer(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getExplorerPartStack().getWidget();
        stepInfo.nextable = true;
        stepInfo.nextButtonText = "I see it!";
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
        };
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            TreeItem objectRepositoryFolder = (TreeItem)ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), TreeItem.class, (String)"Object Repository");
            Rectangle bestArea = (Rectangle)args[0];
            Rectangle targetArea = (Rectangle)args[2];
            Rectangle objectRepositoryFolderPos = ComponentUtil.getScreenArea((Widget)objectRepositoryFolder);
            Point customDialogPos = new Point(bestArea.x, objectRepositoryFolderPos.y + objectRepositoryFolderPos.height / 2);
            return customDialogPos.y < targetArea.y + targetArea.height ? customDialogPos : new Point(bestArea.x, bestArea.y);
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep10ShowTestEditor(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
        stepInfo.nextable = true;
        stepInfo.nextButtonText = "I got it!";
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
        };
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle bestArea = (Rectangle)args[0];
            Rectangle dialogArea = (Rectangle)args[1];
            return new Point(bestArea.x + 8, bestArea.y - dialogArea.height - ComponentUtil.getTabNavHeight() - ComponentUtil.applyZoom((int)10));
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep11RunYourTest(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"/Run.*/");
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
        };
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Widget runButton = ComponentFinder.findByTypeAndText((Widget)ShellManager.getMainShell(), ToolItem.class, (String)"/Run.*/");
                UITimeUtil.cancel((Timer)this.waitForRunMenuTimer);
                UITimeUtil.waitFor(timer -> {
                    this.waitForRunMenuTimer = timer;
                    return ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run") != null;
                }, () -> {
                    Menu runMenu = (Menu)ComponentFinder.findByTypeAndText((Widget)runButton, Menu.class, (String)"Run");
                    ComponentEventUtil.handleDropdownClick((Menu)runMenu, (Event)event, () -> webTestingTour.next());
                }, (long)0L);
            }
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep12WaitForLauncher(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.mainScript = () -> UITimeUtil.waitFor(timer -> LauncherManager.getInstance().isAnyLauncherRunning(), () -> webTestingTour.next());
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private void addStep13CheckTheResult(KatalonTour webTestingTour, String name, String title, String description) {
        StepInfo stepInfo = new StepInfo(name, title, description);
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getConsolePartStack().getWidget();
        stepInfo.nextable = true;
        stepInfo.beforeStep = () -> {
            stepInfo.overlay = this.mainOverlay;
        };
        stepInfo.waitToStart = timer -> !LauncherManager.getInstance().isAnyLauncherRunning();
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle dialogArea = (Rectangle)args[1];
            Rectangle targetArea = (Rectangle)args[2];
            return new Point(targetArea.x + targetArea.width - dialogArea.width - 8, targetArea.y + targetArea.height - dialogArea.height - 8);
        };
        WebTestingTourHandler.createStep(webTestingTour, stepInfo);
    }

    private static void createStep(KatalonTour webTestingTour, StepInfo stepInfo) {
        webTestingTour.addStep(new GeneralTourStep(webTestingTour, stepInfo));
    }

    private static HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                overlay.close();
                Trackings.trackTourAction((String)QuickStartTourType.WEB_TESTING.name(), (String)TourAction.BROKEN.name());
            }
        });
        return overlay;
    }
}

