/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tutorial;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.preferences.TutorialPreferenceStore;
import com.kms.katalon.composer.tutorial.Tutorial;
import com.kms.katalon.composer.tutorial.TutorialType;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webservice.common.HttpUtil;
import com.kms.katalon.core.webservice.exception.SendRequestException;
import com.kms.katalon.entity.project.ProjectType;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ParseException;

public class TutorialCollection {
    private String user;
    private List<Tutorial> webui;
    private List<Tutorial> api;
    private List<Tutorial> mobile;
    private List<Tutorial> desktop;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public List<Tutorial> getWebUITutorials() {
        if (this.webui != null) {
            this.webui.stream().forEach(t -> t.setType(TutorialType.WEBUI));
        }
        return this.webui;
    }

    public void setWebUITutorials(List<Tutorial> webUITutorials) {
        this.webui = webUITutorials;
    }

    public List<Tutorial> getApiTutorials() {
        if (this.api != null) {
            this.api.stream().forEach(t -> t.setType(TutorialType.WEBSERVICE));
        }
        return this.api;
    }

    public void setApiTutorials(List<Tutorial> apiTutorials) {
        this.api = apiTutorials;
    }

    public List<Tutorial> getMobileTutorials() {
        if (this.mobile != null) {
            this.mobile.stream().forEach(t -> t.setType(TutorialType.MOBILE));
        }
        return this.mobile;
    }

    public void setMobileTutorials(List<Tutorial> mobileTutorials) {
        this.mobile = mobileTutorials;
    }

    public List<Tutorial> getDesktopTutorials() {
        if (this.desktop != null) {
            this.desktop.stream().forEach(t -> t.setType(TutorialType.DESKTOP));
        }
        return this.desktop;
    }

    public void setDesktopTutorials(List<Tutorial> desktopTutorials) {
        this.desktop = desktopTutorials;
    }

    public List<Tutorial> getTutorialsByProjectType(ProjectType projectType) {
        switch (projectType) {
            case WEBUI: {
                return this.getWebUITutorials();
            }
            case MOBILE: {
                return this.getMobileTutorials();
            }
            case WEBSERVICE: {
                return this.getApiTutorials();
            }
            case DESKTOP: {
                return this.getDesktopTutorials();
            }
        }
        return Collections.emptyList();
    }

    public void setTutorialsByProjectType(List<Tutorial> tutorials, ProjectType projectType) {
        switch (projectType) {
            case WEBUI: {
                this.setWebUITutorials(tutorials);
                break;
            }
            case MOBILE: {
                this.setMobileTutorials(tutorials);
                break;
            }
            case WEBSERVICE: {
                this.setApiTutorials(tutorials);
                break;
            }
            case DESKTOP: {
                this.setDesktopTutorials(tutorials);
                break;
            }
        }
    }

    public boolean isCompleted(ProjectType projectType) {
        List<Tutorial> tutorials = this.getTutorialsByProjectType(projectType);
        return !tutorials.stream().filter(t -> !t.isRead()).findAny().isPresent();
    }

    public static TutorialCollection fromJson(String tutorialListJson) {
        if (StringUtils.isNotBlank((CharSequence)tutorialListJson)) {
            return (TutorialCollection)JsonUtil.fromJson((String)tutorialListJson, TutorialCollection.class);
        }
        return null;
    }

    public static TutorialCollection syncWithRemote(String user) {
        TutorialCollection latestCollection = TutorialCollection.fetchTutorialCollection(user);
        if (latestCollection != null) {
            TutorialCollection.initializeTutorialReadStatuses(latestCollection);
        }
        return latestCollection;
    }

    private static TutorialCollection fetchTutorialCollection(String user) {
        try {
            String tutorialCollectionJson = HttpUtil.getStringContent((String)"https://raw.githubusercontent.com/katalon-studio/katalon-studio/master/in-app-tutorials/getting-started/basic_tutorials_sidebar.json");
            TutorialCollection collectionResult = TutorialCollection.fromJson(tutorialCollectionJson);
            if (collectionResult != null) {
                collectionResult.setUser(user);
                return collectionResult;
            }
        }
        catch (SendRequestException | ParseException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return null;
    }

    private static void initializeTutorialReadStatuses(TutorialCollection newCollection) {
        TutorialCollection storedCollection = TutorialPreferenceStore.getTutorialCollection(newCollection.getUser());
        if (storedCollection == null) {
            return;
        }
        ProjectType[] projectTypeArray = ProjectType.values();
        int n = projectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectType projectType = projectTypeArray[n2];
            List<Tutorial> tutorials = newCollection.getTutorialsByProjectType(projectType);
            List<Tutorial> storedTutorials = storedCollection.getTutorialsByProjectType(projectType);
            for (Tutorial tutorial : tutorials) {
                int idx = storedTutorials.indexOf(tutorial);
                if (idx == -1) continue;
                Tutorial storedTutorial = storedTutorials.get(idx);
                if (storedTutorial != null && storedTutorial.isRead()) {
                    tutorial.setRead(true);
                    continue;
                }
                tutorial.setRead(false);
            }
            ++n2;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TutorialCollection other = (TutorialCollection)obj;
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

