/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.tutorial;

import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.control.ProgressCircle;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.ResourcesUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.preferences.TutorialPreferenceStore;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.tutorial.Tutorial;
import com.kms.katalon.composer.tutorial.TutorialCollection;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.entity.project.ProjectType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TutorialPart {
    private static final Color COMPOSITE_COLOR = ColorUtil.getColor((String)"#F5F6F5");
    private static final Color THEME_COLOR = ColorUtil.getColor((String)"#75BE40");
    private static final Color COLOR_WHITE = ColorUtil.getWhiteBackgroundColor();
    private static final Color COLOR_BLACK = ColorUtil.getBlackBackgroundColor();
    private ProjectType projectType;
    private ProgressCircle progressCircle;
    private StackLayout mainBodyLayout;
    private ScrolledComposite scrolledComposite;
    private Composite partComposite;
    private Composite mainComposite;
    private Composite overviewComposite;
    private Composite detailsComposite;
    private TutorialCollection tutorialCollection;
    private List<Tutorial> tutorials;
    private Tutorial selectedTutorial;
    private Canvas backButton;
    private Canvas nextButton;
    private Canvas markAsReadButton;
    private Browser detailsBrowser;
    private List<TutorialItem> tutorialItems = new ArrayList<TutorialItem>();
    private boolean shouldShowOverview;
    private boolean shouldChangeBrowserContent = false;

    @PostConstruct
    public void initialize(Composite parent, MPart part) {
        this.partComposite = parent;
    }

    public void initComponents(ProjectType projectType, boolean showOverview) {
        this.projectType = projectType;
        this.initializeTutorials();
        this.shouldShowOverview = showOverview;
        if (this.tutorials != null && !this.tutorials.isEmpty()) {
            this.createControls(this.partComposite);
        }
    }

    private void initializeTutorials() {
        this.tutorialCollection = TutorialCollection.syncWithRemote(ApplicationContext.getInstance().getUserId());
        if (this.tutorialCollection != null) {
            this.tutorials = this.tutorialCollection.getTutorialsByProjectType(this.projectType);
        }
    }

    private void createControls(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.mainComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.mainComposite.setBackground(COMPOSITE_COLOR);
        GridLayout glMain = new GridLayout(1, false);
        glMain.marginWidth = 0;
        glMain.marginHeight = 0;
        this.mainComposite.setLayout((Layout)glMain);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createHeadingComposite(this.mainComposite);
        Composite bodyComposite = new Composite(this.mainComposite, 0);
        this.mainBodyLayout = new StackLayout();
        this.mainBodyLayout.marginWidth = 12;
        this.mainBodyLayout.marginHeight = 13;
        bodyComposite.setLayout((Layout)this.mainBodyLayout);
        bodyComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        bodyComposite.setBackground(COMPOSITE_COLOR);
        this.overviewComposite = this.createOverviewComposite(bodyComposite);
        this.detailsComposite = this.createDetailsComposite(bodyComposite);
        if (this.shouldShowOverview) {
            this.mainBodyLayout.topControl = this.overviewComposite;
            this.scrolledComposite.setMinSize(this.scrolledComposite.getSize().x, this.mainComposite.computeSize((int)-1, (int)-1).y);
        } else {
            this.selectedTutorial = this.getFirstUnreadTutorial();
            if (this.selectedTutorial == null) {
                this.mainBodyLayout.topControl = this.overviewComposite;
                this.scrolledComposite.setMinSize(this.scrolledComposite.getSize().x, this.mainComposite.computeSize((int)-1, (int)-1).y);
            } else {
                this.refreshDetailsSection();
                this.mainBodyLayout.topControl = this.detailsComposite;
            }
        }
        this.scrolledComposite.setContent((Control)this.mainComposite);
    }

    private Composite createHeadingComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 14;
        gridLayout.marginHeight = 14;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setBackground(COLOR_WHITE);
        Label lblGettingStarted = new Label(composite, 0);
        lblGettingStarted.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        lblGettingStarted.setText(MessageConstants.TutorialPart_LBL_GETTING_STARTED);
        lblGettingStarted.setBackground(COLOR_WHITE);
        ControlUtils.setFontSize((Control)lblGettingStarted, (int)14);
        ControlUtils.setFontToBeBold((Control)lblGettingStarted);
        lblGettingStarted.getFont().getFontData();
        this.progressCircle = new ProgressCircle(composite, 0);
        this.progressCircle.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.progressCircle.setBackground(COLOR_WHITE);
        this.progressCircle.setMinimum(0);
        this.progressCircle.setMaximum(this.tutorials.size());
        this.progressCircle.setCircleSize(50);
        this.progressCircle.setThickness(5);
        this.progressCircle.setHighlightColor(THEME_COLOR);
        this.setCurrenProgress();
        return composite;
    }

    private void setCurrenProgress() {
        List readTutorials = this.tutorials.stream().filter(Tutorial::isRead).collect(Collectors.toList());
        this.progressCircle.setSelection(readTutorials.size());
    }

    private Composite createOverviewComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout glOverview = new GridLayout(1, false);
        glOverview.marginWidth = 0;
        glOverview.marginHeight = 0;
        glOverview.horizontalSpacing = 0;
        glOverview.verticalSpacing = 4;
        composite.setLayout((Layout)glOverview);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(COMPOSITE_COLOR);
        for (Tutorial tutorial : this.tutorials) {
            TutorialItem tutorialItem = new TutorialItem(composite, tutorial);
            this.tutorialItems.add(tutorialItem);
        }
        return composite;
    }

    private Composite createDetailsComposite(Composite parent) {
        Canvas container = this.createDetailsMainContainer(parent);
        this.detailsBrowser = this.createDetailsBrowser((Composite)container);
        this.createDetailsSectionButtons((Composite)container);
        return container;
    }

    private Canvas createDetailsMainContainer(Composite parent) {
        final Canvas container = new Canvas(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 15;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setBackground(COMPOSITE_COLOR);
        container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point rect = container.getSize();
                e.gc.setBackground(COLOR_WHITE);
                e.gc.fillRoundRectangle(0, 0, rect.x, rect.y, 8, 8);
            }
        });
        return container;
    }

    private Browser createDetailsBrowser(Composite parent) {
        final Browser browser = new Browser(parent, 0);
        browser.setLayoutData((Object)new GridData(4, 4, true, true));
        browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                if (TutorialPart.this.selectedTutorial != null) {
                    String markdown = TutorialPart.this.selectedTutorial.getContent();
                    markdown = StringEscapeUtils.escapeEcmaScript((String)markdown);
                    browser.evaluate("document.getElementById('content').innerHTML = marked('" + markdown + "');");
                    TutorialPart.this.shouldChangeBrowserContent = false;
                }
            }

            public void changed(ProgressEvent event) {
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (!TutorialPart.this.shouldChangeBrowserContent) {
                    event.doit = false;
                    Program.launch((String)event.location);
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        return browser;
    }

    private void refreshDetailsBrowser() {
        String sourceContent = ResourcesUtil.getFileContent(TutorialPart.class, (String)"resources/template/tutorial_markdown_template.html");
        this.detailsBrowser.setText(sourceContent);
    }

    private void createDetailsSectionButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginTop = 32;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        buttonComposite.setLayoutData((Object)new GridData(4, 1024, true, false));
        buttonComposite.setBackground(COLOR_WHITE);
        this.markAsReadButton = this.createMarkAsReadButton(buttonComposite);
        this.markAsReadButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Canvas overviewButton = this.createOverviewButton(buttonComposite);
        overviewButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.backButton = this.createBackButton(buttonComposite);
        GridData gdBack = new GridData(131072, 0x1000000, false, false);
        gdBack.widthHint = 59;
        this.backButton.setLayoutData((Object)gdBack);
        this.backButton.layout();
        this.nextButton = this.createNextButton(buttonComposite);
        GridData gdNext = new GridData(131072, 0x1000000, false, false);
        gdNext.widthHint = 59;
        this.nextButton.setLayoutData((Object)gdNext);
        this.nextButton.layout();
    }

    private Canvas createMarkAsReadButton(Composite parent) {
        final CustomDrawnCanvas buttonCanvas = new CustomDrawnCanvas(parent, 0, 1, 4, ColorUtil.getColor((String)"#9A9A9A"), COLOR_WHITE, ColorUtil.getColor((String)"#2B7FE1"), COLOR_WHITE, this.getHandCursor()){

            @Override
            protected void createContent(Composite parent) {
                parent.setLayout((Layout)new GridLayout(1, false));
                Label lblMarkAsRead = new Label(parent, 0);
                lblMarkAsRead.setText(MessageConstants.TutorialPart_LBL_MARK_AS_READ);
            }
        };
        ControlUtils.recursivelyAddMouseListener((Control)buttonCanvas, (MouseAdapter)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TutorialPart.this.handleMarkAsReadClicked(buttonCanvas);
            }
        });
        return buttonCanvas;
    }

    private void handleMarkAsReadClicked(Canvas buttonCanvas) {
        this.selectedTutorial.setRead(true);
        this.save();
        ComponentUtil.hide((Control)buttonCanvas);
        this.setCurrenProgress();
        this.refreshOverviewSection();
    }

    private Canvas createOverviewButton(Composite parent) {
        CustomDrawnCanvas buttonCanvas = new CustomDrawnCanvas(parent, 0, 1, 4, ColorUtil.getColor((String)"#9A9A9A"), COLOR_WHITE, ColorUtil.getColor((String)"#2B7FE1"), COLOR_WHITE, this.getHandCursor()){

            @Override
            protected void createContent(Composite parent) {
                parent.setLayout((Layout)new GridLayout(1, false));
                Label lblMarkAsRead = new Label(parent, 0);
                lblMarkAsRead.setText(MessageConstants.TutorialPart_LBL_OVERVIEW);
                ControlUtils.recursivelyAddMouseListener((Control)parent, (MouseAdapter)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        TutorialPart.this.handleOverviewClicked();
                    }
                });
            }
        };
        return buttonCanvas;
    }

    private void handleOverviewClicked() {
        this.mainBodyLayout.topControl = this.overviewComposite;
        this.overviewComposite.getParent().layout();
        this.scrolledComposite.setMinSize(this.scrolledComposite.getSize().x, this.mainComposite.computeSize((int)-1, (int)-1).y);
    }

    private Canvas createBackButton(Composite parent) {
        final Color ACTIVE_COLOR = ColorUtil.getColor((String)"#498F00");
        CustomDrawnCanvas buttonCanvas = new CustomDrawnCanvas(parent, 0, 1, 4, ACTIVE_COLOR, COLOR_WHITE, COLOR_WHITE, ACTIVE_COLOR, this.getHandCursor()){
            private Label lblImage;
            private Label lblBack;

            @Override
            protected void createContent(Composite parent) {
                parent.setLayout((Layout)new GridLayout(2, false));
                this.lblImage = new Label(parent, 0);
                this.lblImage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
                this.lblImage.setImage(ImageManager.getImage((String)"tutorial/back.png"));
                this.lblBack = new Label(parent, 0);
                this.lblBack.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
                this.lblBack.setText(MessageConstants.TutorialPart_LBL_BACK);
                this.lblBack.setForeground(COLOR_BLACK);
                this.lblBack.setAlignment(0x1000000);
                this.registerListeners();
            }

            private void registerListeners() {
                ControlUtils.recursivelyAddMouseTrackListener((Control)this, (MouseTrackListener)new MouseTrackListener(){

                    public void mouseHover(MouseEvent e) {
                    }

                    public void mouseExit(MouseEvent e) {
                        lblImage.setImage(ImageManager.getImage((String)"tutorial/back.png"));
                        lblBack.setForeground(COLOR_BLACK);
                        ComponentUtil.setChildrenBackgroundColor((Composite)lblImage.getParent(), (Color)COLOR_WHITE);
                    }

                    public void mouseEnter(MouseEvent e) {
                        lblImage.setImage(ImageManager.getImage((String)"tutorial/back_active.png"));
                        lblBack.setForeground(COLOR_WHITE);
                        ComponentUtil.setChildrenBackgroundColor((Composite)lblImage.getParent(), (Color)ACTIVE_COLOR);
                    }
                });
                ControlUtils.recursivelyAddMouseListener((Control)this, (MouseAdapter)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        TutorialPart.this.handleBackButtonClicked();
                    }
                });
            }
        };
        return buttonCanvas;
    }

    private void handleBackButtonClicked() {
        int idx = this.tutorials.indexOf(this.selectedTutorial);
        this.selectedTutorial = this.tutorials.get(idx - 1);
        this.refreshDetailsSection();
    }

    private Canvas createNextButton(Composite parent) {
        final Color ACTIVE_COLOR = ColorUtil.getColor((String)"#498F00");
        CustomDrawnCanvas buttonCanvas = new CustomDrawnCanvas(parent, 0, 1, 4, ACTIVE_COLOR, COLOR_WHITE, COLOR_WHITE, ACTIVE_COLOR, this.getHandCursor()){
            private Label lblNext;
            private Label lblImage;

            @Override
            protected void createContent(Composite parent) {
                parent.setLayout((Layout)new GridLayout(2, false));
                this.lblNext = new Label(parent, 0);
                this.lblNext.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
                this.lblNext.setText(MessageConstants.TutorialPart_LBL_NEXT);
                this.lblNext.setForeground(COLOR_BLACK);
                this.lblNext.setAlignment(0x1000000);
                this.lblImage = new Label(parent, 0);
                this.lblImage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
                this.lblImage.setImage(ImageManager.getImage((String)"tutorial/next.png"));
                this.registerListeners();
            }

            private void registerListeners() {
                ControlUtils.recursivelyAddMouseTrackListener((Control)this, (MouseTrackListener)new MouseTrackListener(){

                    public void mouseHover(MouseEvent e) {
                    }

                    public void mouseExit(MouseEvent e) {
                        lblNext.setForeground(COLOR_BLACK);
                        lblImage.setImage(ImageManager.getImage((String)"tutorial/next.png"));
                        ComponentUtil.setChildrenBackgroundColor((Composite)lblNext.getParent(), (Color)COLOR_WHITE);
                    }

                    public void mouseEnter(MouseEvent e) {
                        lblNext.setForeground(COLOR_WHITE);
                        lblImage.setImage(ImageManager.getImage((String)"tutorial/next_active.png"));
                        ComponentUtil.setChildrenBackgroundColor((Composite)lblNext.getParent(), (Color)ACTIVE_COLOR);
                    }
                });
                ControlUtils.recursivelyAddMouseListener((Control)this, (MouseAdapter)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        TutorialPart.this.handleNextButtonClicked();
                    }
                });
            }
        };
        return buttonCanvas;
    }

    private void handleNextButtonClicked() {
        int idx = this.tutorials.indexOf(this.selectedTutorial);
        this.selectedTutorial = this.tutorials.get(idx + 1);
        this.refreshDetailsSection();
    }

    private void refreshOverviewSection() {
        this.tutorialItems.stream().forEach(i -> i.refresh());
    }

    private void refreshDetailsSection() {
        boolean isLast;
        boolean isFirst;
        this.refreshTutorialContent();
        int idx = this.tutorials.indexOf(this.selectedTutorial);
        boolean bl = isFirst = idx == 0;
        if (isFirst) {
            ComponentUtil.hide((Control)this.backButton);
        } else {
            ComponentUtil.show((Control)this.backButton);
        }
        boolean bl2 = isLast = idx == this.tutorials.size() - 1;
        if (isLast) {
            ComponentUtil.hide((Control)this.nextButton);
        } else {
            ComponentUtil.show((Control)this.nextButton);
        }
        if (this.selectedTutorial.isRead()) {
            ComponentUtil.hide((Control)this.markAsReadButton);
        } else {
            ComponentUtil.show((Control)this.markAsReadButton);
        }
        this.scrolledComposite.setMinSize(this.scrolledComposite.getSize().x, this.scrolledComposite.getSize().y);
    }

    private void refreshTutorialContent() {
        this.shouldChangeBrowserContent = true;
        this.refreshDetailsBrowser();
    }

    private Tutorial getFirstUnreadTutorial() {
        for (Tutorial tutorial : this.tutorials) {
            if (tutorial.isRead()) continue;
            return tutorial;
        }
        return null;
    }

    private void save() {
        this.tutorialCollection.setTutorialsByProjectType(this.tutorials, this.projectType);
        try {
            TutorialPreferenceStore.saveTutorialCollection(this.tutorialCollection);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private Cursor getHandCursor() {
        return Display.getCurrent().getSystemCursor(21);
    }

    private static abstract class CustomDrawnCanvas
    extends Canvas {
        private boolean isHovered;
        private int borderWidth;
        private int borderRadius;
        private Color borderColor;
        private Color backgroundColor;
        private Color hoverBorderColor;
        private Color hoverBackgroundColor;
        private Cursor cursor;
        private Canvas self = this;

        public CustomDrawnCanvas(Composite parent, int style, int borderWidth, int borderRadius, Color borderColor, Color backgroundColor, Color hoverBorderColor, Color hoverBackgroundColor, Cursor cursor) {
            super(parent, style);
            this.borderWidth = borderWidth;
            this.borderRadius = borderRadius;
            this.borderColor = borderColor;
            this.backgroundColor = backgroundColor;
            this.hoverBorderColor = hoverBorderColor;
            this.hoverBackgroundColor = hoverBackgroundColor;
            this.cursor = cursor;
            this.createContent((Composite)this);
            this.setBackground(COMPOSITE_COLOR);
            ComponentUtil.setChildrenBackgroundColor((Composite)this, (Color)backgroundColor);
            this.registerListeners();
        }

        protected abstract void createContent(Composite var1);

        private void registerListeners() {
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Point rect = this.getSize();
                    if (isHovered) {
                        this.drawRectangle(gc, rect.x, rect.y, borderWidth, borderRadius, hoverBorderColor, hoverBackgroundColor);
                    } else {
                        this.drawRectangle(gc, rect.x, rect.y, borderWidth, borderRadius, borderColor, backgroundColor);
                    }
                }
            });
            ControlUtils.recursivelyAddMouseTrackListener((Control)this, (MouseTrackListener)new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    isHovered = true;
                    this.setCursor(cursor);
                    this.redraw();
                    ComponentUtil.setChildrenBackgroundColor((Composite)self, (Color)hoverBackgroundColor);
                }

                public void mouseExit(MouseEvent e) {
                    isHovered = false;
                    this.redraw();
                    ComponentUtil.setChildrenBackgroundColor((Composite)self, (Color)backgroundColor);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
        }

        private void drawRectangle(GC gc, int width, int height, int borderWidth, int borderRadius, Color borderColor, Color backgroundColor) {
            if (borderColor != null) {
                gc.setForeground(borderColor);
                gc.setLineWidth(borderWidth);
                gc.drawRoundRectangle(0, 0, width - borderWidth, height - borderWidth, borderRadius, borderRadius);
            }
            if (backgroundColor != null) {
                gc.setBackground(backgroundColor);
                gc.fillRoundRectangle(borderWidth, borderWidth, width - 2 * borderWidth, height - 2 * borderWidth, borderRadius, borderRadius);
            }
        }
    }

    private class TutorialItem {
        private Tutorial tutorial;
        private Canvas container;
        private Label lblIcon;
        private Label lblTitle;
        private Label lblCheckIcon;
        private boolean isHovered = false;

        public TutorialItem(Composite parent, final Tutorial tutorial) {
            this.tutorial = tutorial;
            this.container = new CustomDrawnCanvas(parent, 0, 1, 8, null, COLOR_WHITE, THEME_COLOR, COLOR_WHITE, TutorialPart.this.getHandCursor()){

                @Override
                protected void createContent(Composite parent) {
                    GridLayout glContainer = new GridLayout(3, false);
                    glContainer.marginWidth = 14;
                    glContainer.marginHeight = 11;
                    parent.setLayout((Layout)glContainer);
                    parent.setLayoutData((Object)new GridData(4, 128, true, false));
                    TutorialItem.this.lblIcon = new Label(parent, 0);
                    TutorialItem.this.lblIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
                    TutorialItem.this.lblTitle = new Label(parent, 0);
                    TutorialItem.this.lblTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
                    TutorialItem.this.lblTitle.setText(tutorial.getTitle());
                    TutorialItem.this.lblCheckIcon = new Label(parent, 0);
                    TutorialItem.this.lblCheckIcon.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
                    TutorialItem.this.lblCheckIcon.setImage(ImageManager.getImage((String)"tutorial/check.png"));
                    TutorialItem.this.displayCheckIcon(false);
                    ComponentUtil.setChildrenBackgroundColor((Composite)parent, (Color)COLOR_WHITE);
                }
            };
            this.registerListeners();
            this.populateDataToUI();
        }

        private void registerListeners() {
            ControlUtils.recursivelyAddMouseTrackListener((Control)this.container, (MouseTrackListener)new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    TutorialItem.this.isHovered = true;
                    TutorialItem.this.container.setCursor(TutorialItem.this.container.getDisplay().getSystemCursor(21));
                    TutorialItem.this.container.redraw();
                }

                public void mouseExit(MouseEvent e) {
                    TutorialItem.this.isHovered = false;
                    TutorialItem.this.container.redraw();
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            ControlUtils.recursivelyAddMouseListener((Control)this.container, (MouseAdapter)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ((TutorialItem)TutorialItem.this).TutorialPart.this.mainBodyLayout.topControl = ((TutorialItem)TutorialItem.this).TutorialPart.this.detailsComposite;
                    ((TutorialItem)TutorialItem.this).TutorialPart.this.selectedTutorial = TutorialItem.this.tutorial;
                    TutorialPart.this.refreshDetailsSection();
                    ((TutorialItem)TutorialItem.this).TutorialPart.this.detailsComposite.getParent().layout();
                }
            });
        }

        private void populateDataToUI() {
            this.lblIcon.setImage(this.tutorial.getImage());
            this.lblTitle.setText(this.tutorial.getTitle());
            this.displayCheckIcon(this.tutorial.isRead());
        }

        private void displayCheckIcon(boolean show) {
            ((GridData)this.lblCheckIcon.getLayoutData()).exclude = !show;
            this.lblCheckIcon.setVisible(show);
            this.lblCheckIcon.getParent().layout();
        }

        public void refresh() {
            this.populateDataToUI();
        }
    }
}

